
  $(document).ready(function(){
    flatpickr("#ob_with_effective_from", {
      dateFormat: "d-M-Y",
      allowInput: true,
      onOpen: function (selectedDates, dateStr, instance) {
        instance.setDate(instance.input.value, false);
      },
    });
  });

function isNumberMyKeys(evt) {
    evt = (evt) ? evt : window.event;
    var charCode = (evt.which) ? evt.which : evt.keyCode;
    if (charCode > 31 && (charCode < 48 || charCode > 57)) {
        return false;
    }
    return true;
  }
  $(document).ready(function () {
    $("input[type='checkbox'][value='VW']").on("change", function () {
        let row = $(this).closest("tr"); // Get the row of the clicked checkbox
        let isChecked = $(this).prop("checked"); // Check if 'View' checkbox is checked
        
        // Find all checkboxes in the same row and update their checked status
        row.find("input[type='checkbox']").prop("checked", isChecked);
    });
});
$(document).ready(function () {
  // When the 'View' checkbox is changed
  $("input[type='checkbox'][value='VW']").on("change", function () {
      let row = $(this).closest("tr"); // Get the row of the clicked checkbox
      let isChecked = $(this).prop("checked"); // Check if 'View' checkbox is checked

      // Check/uncheck all checkboxes in the row based on the 'View' checkbox state
      row.find("input[type='checkbox']").prop("checked", isChecked);
  });

  // When any other checkbox in the row is changed
  $("input[type='checkbox']").not("[value='VW']").on("change", function () {
      let row = $(this).closest("tr"); // Get the row of the clicked checkbox
      let viewCheckbox = row.find("input[type='checkbox'][value='VW']"); // Get the 'View' checkbox

      // If any checkbox in the row is checked, ensure 'View' checkbox is also checked
      if (row.find("input[type='checkbox']").not("[value='VW']").is(":checked")) {
          viewCheckbox.prop("checked", true);
      }
  });
});

  $(document).on("click","#city_name_type_select",function(){
    $("#sidebar-menu-toggle").toggle();
  });
  function close_city_checkbox(){
    $("#sidebar-menu-toggle").hide();
  }
  $(document).ready(function() {
      // Function to handle clicking outside the menu to close it
      $(document).click(function(event) {
        var menu = $('#sidebar-menu-toggle');
        var toggleButton = $('#city_name_type_select');
    
        // Check if the click is outside the menu and the toggle button
        if (!menu.is(event.target) && menu.has(event.target).length === 0 &&
            !toggleButton.is(event.target) && toggleButton.has(event.target).length === 0) {
              close_city_checkbox();
        }
      });
  });
  function close_city_checkbox(){
    $("#sidebar-menu-toggle").hide();
  }
  
  function get_selected_item_val(){
    var selectedValues = [];
    var xvalues = [];
    var postype = []
    $("input[name='city_type_select[]']:checked").each(function(){
      postype.push($(this).attr("id"));
      xvalues.push($(this).val());
      selectedValues.push($(this).val());
    });
    if(xvalues.length > 0){
      var xvaluesJoined = xvalues.join(",");
      var postypeJoined = postype.join(",");
      $("#city_name").val(postypeJoined);
      $("#city_name_type_select").val(xvaluesJoined);
    }else{
      $("#city_name").val('');
      $("#city_name_type_select").val('');
    }
  }
  
  function filter_user_list(){
    var useroot = $("#rootXPath").val();
    $(".show_loader").removeClass("hidden");
    $(".no_loader").removeClass("hidden").addClass("hidden")
    $("#myForms").attr("action",useroot+"create_user/user_list/search");
    $("#myForms").submit();
}

function reset_user_password(reqid,userid,username){
  $("#popup_requestid").val(reqid);
  $("#popup_userid").text(userid);
  $("#popup_username").text(username);
  setTimeout(function(){ },500);
  }

     // Function to handle showing/hiding password fields based on selected option
function showHidePasswordFields(option) {
  const newPasswordField = document.getElementById('new_password');
  if (option === 'autoGenerate') {
      newPasswordField.value = generatePassword(); // Function that generates a password
      newPasswordField.type = 'password';
      newPasswordField.readOnly = true;
  } else if (option === 'createNew') {
      newPasswordField.value = '';
      newPasswordField.type = 'password';
      newPasswordField.readOnly = false;
  }
}


  // Function to generate a random password (You can use your implementation here)
function generatePassword() {
  const length = 10; // Define the length of the generated password
  const charset = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()_+{}[]|:;"<>,.?/~'; // Define the characters used in the password
  let password = '';

  for (let i = 0; i < length; i++) {
    const randomIndex = Math.floor(Math.random() * charset.length);
    password += charset[randomIndex];
  }

  return password;
}

function togglePasswordField() {
  const passwordField = document.getElementById('new_password');
  const toggleIcon = document.getElementById('togglePassword');

  if (passwordField.type === 'password') {
      passwordField.type = 'text';
      toggleIcon.classList.remove('fa-eye');
      toggleIcon.classList.add('fa-eye-slash');
  } else {
      passwordField.type = 'password';
      toggleIcon.classList.remove('fa-eye-slash');
      toggleIcon.classList.add('fa-eye');
  }
}

async function copyPasswordToClipboard() {
  const newPasswordField = document.getElementById('new_password');

  // Check if the new_password field has a value
  if (!newPasswordField.value) {
    alert('Password field is empty. Please enter a password.');
    return; // Exit the function if the password field is empty
  }

  try {
    await navigator.clipboard.writeText(newPasswordField.value);
    alert('Text copied to clipboard');
  } catch (err) {
    alert('Unable to copy text to clipboard. Error: ' + err);
  }
}

function process_reset_user_password() {
  var usePath = $.trim($("#rootXPath").val());
  var new_pass = $.trim($("#new_password").val());
  var requestid = $.trim($("#popup_requestid").val());

  if (new_pass === '') {
    alert("New Password is required");
    $("#new_password").focus();
    return false;
  } else if (requestid === '') {
    alert("User ID is required.");
    return false;
  }
  $(".unprocess_loader").removeClass("hidden");
  $(".process_loader").addClass("hidden");

 
    $.ajax({
      url: usePath + "create_user/ajax_process",
      type: 'POST',
      data: { 'reqid': requestid, 'new_pass': new_pass,'identity': 'RESET' },
      async: false,
      success: function (resp) {
        $(".unprocess_loader").addClass("hidden");
        $(".process_loader").removeClass("hidden");

        if (resp.status) {
          alert("Password reset successful.");
          //window.location = window.location.href;
        } else {
          alert("Unable to process");
        }
       
      },
      error: function () {
        $(".unprocess_loader").addClass("hidden");
        $(".process_loader").removeClass("hidden");
      },
      cache: false
    });
 
}

function show_create_check_user_listmodule(){  
  $("#myDIV").toggleClass("hidden")
  var classname = $("#process_side_updown").attr("class");
  if( classname == 'fa fa-plus text-success'){
      $("#process_side_updown").removeClass("fa fa-plus text-success").addClass("fa fa-minus text-danger");
  }else if( classname == 'fa fa-minus text-danger'){
      $("#process_side_updown").removeClass("fa fa-minus text-danger").addClass("fa fa-plus text-success");
  }
  
}

document.addEventListener('DOMContentLoaded', function() {
  // Find all select-all-module checkboxes and attach event listeners
  document.querySelectorAll('.select-all-module').forEach(function(selectAllCheckbox) {
    selectAllCheckbox.addEventListener('change', function() {
      var moduleId = this.getAttribute('data-module-id'); // Get the module ID from the attribute
      var checkboxes = document.querySelectorAll('.module-checkbox-' + moduleId); // Get all checkboxes inside the module
      var moduleCode = this.value; // Get the module code (module name)

      checkboxes.forEach(function(checkbox) {
        checkbox.checked = selectAllCheckbox.checked; // Set the checkbox state to match the select-all checkbox
      });

      updateSelectedModules();
    });
  });

  // Find all individual checkboxes and attach event listeners
  document.querySelectorAll('.module-checkbox').forEach(function(moduleCheckbox) {
    moduleCheckbox.addEventListener('change', function() {
      var moduleId = this.classList[1].split('-')[2]; // Extract module ID from the checkbox class
      var selectAllCheckbox = document.querySelector('#process_common_select_' + moduleId); // Get the select all checkbox for this module
      var allModuleCheckboxes = document.querySelectorAll('.module-checkbox-' + moduleId); // Get all checkboxes inside this module

      // Check if any checkbox in the module is checked
      var anyChecked = Array.from(allModuleCheckboxes).some(function(checkbox) {
        return checkbox.checked;
      });

      // Uncheck the select-all checkbox if all checkboxes are unchecked, else keep it checked
      selectAllCheckbox.checked = anyChecked;

      updateSelectedModules();
    });
  });

  // Function to update selected modules in the hidden input
  function updateSelectedModules() {
    var selectedModules = new Set(); // Use a Set to avoid duplicates

    // Check for each module if any checkbox is selected
    document.querySelectorAll('.select-all-module').forEach(function(selectAllCheckbox) {
      var moduleId = selectAllCheckbox.getAttribute('data-module-id');
      var moduleCode = selectAllCheckbox.value; // Get the module code (module name)

      var allModuleCheckboxes = document.querySelectorAll('.module-checkbox-' + moduleId);
      
      // If the "select all" checkbox is checked OR any menu checkbox is checked, add the module
      var anyChecked = Array.from(allModuleCheckboxes).some(function(checkbox) {
        return checkbox.checked;
      });

      if (selectAllCheckbox.checked || anyChecked) {
        selectedModules.add(moduleCode); // Add the module code to the set
      }
    });

    // Update the hidden input field with selected modules (comma-separated)
    document.querySelector('#selected_module').value = Array.from(selectedModules).join(',');
  }

  // Call the function on page load to ensure the input is up-to-date with preselected values
  updateSelectedModules();
});

$("#allowhrparameter").on("change", function() {
  if ($(this).is(":checked")) {
    $("#specialpermission").prop("checked", true);
  }
});

function handleFormSubmit() {
  var usertype = $.trim($("#usertype").val());
  var faculty = $.trim($("#faculty").val());
  var username = $.trim($("#username").val());
  var userpassword = $.trim($("#userpassword").val());
  var phonenumber = $.trim($("#phonenumber").val());
  var specialpermission = $("#specialpermission").is(":checked");
  var allowhrparameter  = $("#allowhrparameter").is(":checked");
  var department = $.trim($("#sewdepart").val());
  var user_type = $.trim($("#usertype").val());

  if( usertype == ''){
    showToast("error","Select User Type.");
    setTimeout(function(){ set_global_focus('usertype');},500);
    return false;
  }else if( username == ''){
    showToast("error","Username is required.");
    setTimeout(function(){ set_global_focus('username');},500);
    return false;
  // }else if( userpassword == ''){
  //   showToast("error","Password is required.");
  //   setTimeout(function(){ set_global_focus('userpassword');},500);
  //   return false;
  }else if( phonenumber == ''){
    showToast("error","Phone number is required.");
    setTimeout(function(){ set_global_focus('phonenumber');},500);
    return false;
  }
  // if (userpassword.length < 6) {
  //   showToast("error", "Password must be at least 6 characters long.");
  //   setTimeout(function(){ set_global_focus('userpassword');}, 500);
  //   return false; // Prevent form submission
  // }
  if (phonenumber.length !== 10) {
    showToast("error","Please enter a valid 10-digit phone number.");
    setTimeout(function(){ set_global_focus('phonenumber');},500);
    return false; // Prevent form submission
  }

  if (specialpermission) {
    if (user_type == 'exp') {
      // check if at least one multi-select department is chosen
      var selectedDepts = $("input[name='post_type_select_dept[]']:checked").length;
      if (selectedDepts === 0) {
        showToast("info", "Select at least one Department when Department Admin is checked.");
        setTimeout(function(){ $("#exp_department").focus(); }, 500);
        return false;
      }
    } else {
      // normal single select department check
      var department = $.trim($("#sewdepart").val());
      if (department === "") {
        showToast("info", "Select Department when Department Admin is checked.");
        setTimeout(function(){ set_global_focus('sewdepart'); }, 500);
        return false;
      }
    }
  }

  if (allowhrparameter && !specialpermission) {
  showToast("info", "You must check Department Admin when Only Indoor Admin is selected.");
  setTimeout(function(){ $("#specialpermission").focus(); }, 500);
  return false;
  }

   $(".process_loader").show();
   $(".no_loader").removeClass("hidden").addClass("hidden");
  // Function to update selected modules in the hidden input
  var selectedModules = new Set(); // Use a Set to avoid duplicates
  var moduleCheckedStatus = 1; // Default to 1, meaning module is fully checked

  // Check for each module if any checkbox is selected
  document.querySelectorAll('.select-all-module').forEach(function(selectAllCheckbox) {
    var moduleId = selectAllCheckbox.getAttribute('data-module-id');
    var moduleCode = selectAllCheckbox.value; // Get the module code (module name)

    var allModuleCheckboxes = document.querySelectorAll('.module-checkbox-' + moduleId);
    
    // If any menu checkbox inside the module is checked, add the module code
    var anyChecked = Array.from(allModuleCheckboxes).some(function(checkbox) {
      return checkbox.checked;
    });

    if (anyChecked) {
      selectedModules.add(moduleCode); // Add the module code to the set
    }

    // Check if all checkboxes inside the module are checked
    var allChecked = Array.from(allModuleCheckboxes).every(function(checkbox) {
      return checkbox.checked;
    });

    // If any checkbox is unchecked, set moduleCheckedStatus to 0
    if (!allChecked) {
      moduleCheckedStatus = 0;
    }
  });

  // Update the hidden input fields with the module data
  document.querySelector('#selected_module').value = Array.from(selectedModules).join(',');
  document.querySelector('#module_checked_status').value = moduleCheckedStatus;

  // Validate if at least one module is selected
  // if (selectedModules.size === 0) {
  //   showToast("error","Please select at least one module before submitting.");
  //   return false; // Prevent form submission
  // }

  // If validation passes, submit the form
  document.querySelector('form').submit();
}

function process_change_user_status(usercode, userstatus, id) {
  var usePath = $.trim($("#rootXPath").val());
  var formData = new FormData();
  formData.append("identity", "CHANGESTATUS");
  formData.append("usercode", usercode);
  formData.append("userid", id);
  formData.append("userstatus", userstatus);
  var confirmationMessage = userstatus === 'N' ? "Are you sure you want to Inactivate User?" : "Are you sure you want to activate User?";

  if (confirm(confirmationMessage)) {
    $.ajax({
      url: usePath + "create_user/ajax_process",
      type: 'POST',
      data: formData,
      async: false,
      contentType: false,
      processData: false,
      success: function (resp) {
        if (resp.status) {          
          if (resp.status === 'Y') {             
          } else if (resp.status === 'I') {           
          }
          setTimeout(function () {
            location.reload();
          }, 1000); 
        }
      },
      error: function () {
      },
      cache: false
    });
  }
}
function common_onchange(){
  onchange_departments();
  onchange_venue();
}

  $(document).ready(function() {
    common_onchange();
  });

function onchange_departments(){
  var user_type = $.trim($("#usertype").val());
  if (user_type == 'exp'){
    $("#mutliple_departments").removeClass("hidden");
    $("#mutliple_category").removeClass("hidden");
    $("#single_departments").removeClass("hidden").addClass("hidden");
    $("#sewdepart").val("");   // reset single select only
    $("#accordion3").removeClass("hidden").addClass("hidden");
  }else {
    $("#single_departments").removeClass("hidden");
    $("#mutliple_departments").removeClass("hidden").addClass("hidden");
    $("#mutliple_category").removeClass("hidden").addClass("hidden");
    $("#accordion3").removeClass("hidden");
    $("#exp_department").val("");
    $("#usercategory").val("");
    $("input[name='post_type_select_dept[]']").prop("checked", false);
    $("input[name='post_type_select_category[]']").prop("checked", false);
}}
function onchange_venue(){
  var user_type = $.trim($("#usertype").val());
  if (user_type == 'exp'){
    $("#mutliple_venue").removeClass("hidden");
    $("#single_venue").removeClass("hidden").addClass("hidden");
    $("#sewdepart").val("");   // reset single select only

  }else {
    $("#single_venue").removeClass("hidden");
    $("#mutliple_venue").removeClass("hidden").addClass("hidden");
    $("#exp_venue").val("");
    $("input[name='post_type_select_venue[]']").prop("checked", false);
  
}}

$(document).on("click","#exp_department",function(){
  $("#sidebar-menu-toggle-dept").toggle();
});

function close_profile_checkbox_dept(){
  $("#sidebar-menu-toggle-dept").hide();
  }
  
  $(document).on('click', function (e) {
      // Check if the click is outside the input box or sidebar menu
      if (!$(e.target).closest('#exp_department, #sidebar-menu-toggle-dept').length) {
          $("#sidebar-menu-toggle-dept").hide();
      }
  });

function get_selected_item_val_dept(){
  var selectedValues = [];
  var xvalues = [];
  var postype = []
  if( $("input[name='post_type_select_dept[]']").is(":checked") ){
    $("input[name='post_type_select_dept[]']:checked").each(function(){
      postype.push($(this).attr("id"));
      xvalues.push($(this).val() );
      selectedValues.push($(this).val());
    });
   // alert(selectedValues)
   
  }
  if( xvalues.length >0 ){
    xvalues  = xvalues.join(",")
    postypes = postype.join(",")
   // $("#prf_sewa_type").val(xvalues);
    $("#exp_department").val(postypes);
  }else{
   // $("#prf_sewa_type").val('');
    $("#exp_department").val('');
  }

  }

  
$(document).on("click","#exp_venue",function(){
  $("#sidebar-menu-toggle-venue").toggle();
});

function close_profile_checkbox_venue(){
  $("#sidebar-menu-toggle-venue").hide();
  }
  
  $(document).on('click', function (e) {
      // Check if the click is outside the input box or sidebar menu
      if (!$(e.target).closest('#exp_venue, #sidebar-menu-toggle-venue').length) {
          $("#sidebar-menu-toggle-venue").hide();
      }
  });
function get_selected_item_val_venue(){
  var selectedIds = [];
  var selectedNames = [];

  if( $("input[name='post_type_select_venue[]']").is(":checked") ){
    $("input[name='post_type_select_venue[]']:checked").each(function(){
      selectedIds.push($(this).val());       // id
      selectedNames.push($(this).attr("id")); // name (stored in id attr)
    });
  }

  if( selectedIds.length >0 ){
    // hidden field for saving IDs
    $("#hidden_exp_venue_ids").val(selectedIds.join(","));
    // textbox shows names
    $("#exp_venue").val(selectedNames.join(","));
  }else{
    $("#hidden_exp_venue_ids").val('');
    $("#exp_venue").val('');
  }
}


$(document).on("click","#usercategory",function(){
  $("#sidebar-menu-toggle-category").toggle();
});

function close_profile_checkbox_category(){
  $("#sidebar-menu-toggle-category").hide();
  }
  
  $(document).on('click', function (e) {
      // Check if the click is outside the input box or sidebar menu
      if (!$(e.target).closest('#usercategory, #sidebar-menu-toggle-category').length) {
          $("#sidebar-menu-toggle-category").hide();
      }
  });
function get_selected_item_val_category(){
  var selectedIds = [];
  var selectedNames = [];

  if( $("input[name='post_type_select_category[]']").is(":checked") ){
    $("input[name='post_type_select_category[]']:checked").each(function(){
      selectedIds.push($(this).val());       // id
      selectedNames.push($(this).attr("id")); // name (stored in id attr)
    });
  }

  if( selectedIds.length >0 ){
    // hidden field for saving IDs
    $("#category_id").val(selectedIds.join(","));
    // textbox shows names
    $("#usercategory").val(selectedNames.join(","));
  }else{
    $("#category_id").val('');
    $("#usercategory").val('');
  }
}
