function isNumberMyKeys(evt) {

  evt = (evt) ? evt : window.event;

  var charCode = (evt.which) ? evt.which : evt.keyCode;

  if (charCode > 31 && (charCode < 48 || charCode > 57)) {

      return false;

  }

  return true;

}


   $(document).ready(function() {
      $('#trn_amt_contract_no').select2({
        placeholder: "-Select-",
        allowClear: true,
        width: 'resolve'  // auto width
      });
      
       $('#trn_amt_contract_no').on('select2:open', function () {
        $('.select2-search__field').focus();
      });
      
    });


function get_contracts() {
    var usePath = $.trim($("#rootXPath").val());
    var department = $.trim($("#trn_amt_dept").val());

    $.ajax({
        url: usePath + "amount_transaction_list/ajax_process",
        type: 'POST',
        data: { 'department': department, 'identity': 'DEPTCHANGE' },
        async: false,
        success: function (resp) {
            if (resp.status) {

                var contractDropdown = $("#trn_amt_contract_no");

                contractDropdown.empty();
                contractDropdown.append('<option value="">-Select-</option>');

                $.each(resp.data, function (index, contract) {
                    var label = contract.entry_no + ' - ' + contract.guest_name + ' (' + contract.contact_no + ')';
                    contractDropdown.append('<option value="' + contract.entry_no + '">' + label + '</option>');
                });

            } else {
                alert("No contracts found for selected department.");
            }
        },
        error: function () {
            alert("Error while fetching contracts.");
        },
        cache: false
    });
}

function get_amounts() {
    var usePath = $.trim($("#rootXPath").val());
    var department = $.trim($("#trn_amt_dept").val());
    var contractno = $.trim($("#trn_amt_contract_no").val());
    $.ajax({
        url: usePath + "amount_transaction_list/ajax_process",
        type: 'POST',
        data: { 'contractno': contractno,  'department': department, 'identity': 'CONTRACTCHANGE' },
        async: false,
        success: function (resp) {
            if (resp.status) {

              $("#trn_factor_0").val(resp.factor_0);

              if(resp.factor_0 === "Y"){
                  $("#factor_0").prop("checked", true).parent().addClass("is-checked");             
                   } else {
                  $("#factor_0").prop("checked", false).parent().removeClass("is-checked");
              }
              $("#trn_amt_old_total_amt").val(resp.old_total_package);
              $("#trn_amt_old_cash_part").val(resp.old_cash_payment);
              $("#trn_amt_old_tax_c_amt").val(resp.old_tax_c_amount);
              $("#trn_amt_old_tax_percent_c").val(resp.old_tax_percent_c);
              $("#trn_amt_old_tax_d_amt").val(resp.old_tax_d_amount);
              $("#trn_amt_old_tax_percent_d").val(resp.old_tax_percent_d);
              $("#trn_amt_old_cheque").val(resp.old_bank_payment);
              $("#trn_amt_old_tax_percent").val(resp.old_tax_percent);
              $("#trn_amt_old_tax_amt").val(resp.old_total_tax_amt);
              $("#trn_amt_old_net_amt").val(resp.old_contract_amt);

              $("#trn_amt_old_advance_cash").val(resp.old_advance_cash);
              $("#trn_amt_old_advance_chq").val(resp.old_advance_chq);
              $("#trn_amt_old_balance").val(resp.old_balance);

              $("#guest_details_card").removeClass("hidden");
              $("#guest_details_card").html(resp.data2);
            } else {
                alert("No contracts found for selected department.");
            }
        },
        error: function () {
            alert("Error while fetching contracts.");
        },
        cache: false
    });
}
function calculateDecorFinancials() {
  var totalAmount    = parseFloat($("#trn_amt_new_total_amt").val()) || 0;
  var taxCAmount     = parseFloat($("#trn_amt_new_tax_c_amt").val()) || 0;
  var taxDAmount     = parseFloat($("#trn_amt_new_tax_d_amt").val()) || 0;
  var taxPercentC    = parseFloat($("#trn_amt_new_tax_percent_c").val()) || 0;
  var taxPercentD    = parseFloat($("#trn_amt_new_tax_percent_d").val()) || 0;
  var advanceCash    = parseFloat($("#trn_amt_new_advance_cash").val()) || 0;
  var advanceBank    = parseFloat($("#trn_amt_new_advance_chq").val()) || 0;
  var factor_0 = $("#trn_factor_0").val() || 'N';

  // Step 1: Calculate bank payment
  var bankPayment = 0;
  if (taxCAmount >= 0 || taxDAmount >= 0) {
    bankPayment = taxCAmount + taxDAmount;
    $("#trn_amt_new_cheque").val(bankPayment.toFixed(1));
  } else {
    $("#trn_amt_new_cheque").val(""); // Clear if no bank payment
  }

  // Step 2: Calculate dh_cash_part only if bank payment exists
  var cashPayment = 0;

  if (bankPayment >= 0) {
    if (factor_0 == 'N'){
      cashPayment = ((totalAmount*2) - bankPayment) * 0.1;
    }
    else {
      cashPayment = (totalAmount - bankPayment);
    }
    if (cashPayment < 0) cashPayment = 0;
    $("#trn_amt_new_cash_part").val(cashPayment.toFixed(1));
  } else {
    $("#trn_amt_new_cash_part").val(""); // Clear if no valid input
  }

  // Step 3: Calculate tax amounts
  var taxAmountC = (taxCAmount * taxPercentC) / 100;
  var taxAmountD = (taxDAmount * taxPercentD) / 100;

  var totalTaxAmount = taxAmountC + taxAmountD;
  $("#trn_amt_new_tax_amt").val(totalTaxAmount.toFixed(1));

  // Step 4: Net amount
  var netAmount = cashPayment + bankPayment + totalTaxAmount;
  $("#trn_amt_new_net_amt").val(netAmount.toFixed(1));

  // Step 5: Total tax %
  var totalTaxPercent = taxPercentC + taxPercentD;
  $("#trn_amt_new_tax_percent").val(totalTaxPercent.toFixed(1));

  // Step 6: Balance
  var balance = netAmount - (advanceCash + advanceBank);
  $("#trn_amt_new_balance").val(balance.toFixed(1));

  // Step 7: Validation border logic
  var sumCheck = cashPayment + taxCAmount + taxDAmount;
  if (bankPayment > 0 && sumCheck.toFixed(1) != totalAmount.toFixed(1)) {

  } else {

  }
}

$(document).ready(function () {
  $("#trn_amt_new_cash_part, #trn_amt_new_tax_c_amt, #trn_amt_new_tax_d_amt, #trn_amt_new_tax_percent_c, #trn_amt_new_tax_percent_d, #trn_amt_new_advance_cash, #trn_amt_new_advance_chq").on("input", function () {
     calculateDecorFinancials();
  });
 // Also run on page load
});

  function process_update_this_transaction() {
    var usePath = $.trim($("#rootXPath").val());
    var formData = new FormData();
    var other_data = $('form#myforms').serializeArray();
  
    var mid = $.trim($("#mid").val());
    var trn_amt_dept = $.trim($("#trn_amt_dept").val());
    var trn_amt_contract_no = $.trim($("#trn_amt_contract_no").val());

    // Validations
    if (!trn_amt_dept) {
      showToast("error","Department is required");
      $("#trn_amt_dept").focus();
      return false;
    }
  
    if (!trn_amt_contract_no) {
      showToast("error","Contact Number is required");
      $("#trn_amt_contract_no").focus();
      return false;
    }
    // Append data to FormData
    formData.append("identity", "UPDATETRNSCTN");
    formData.append("mid", mid);
    other_data.forEach(input => formData.append(input.name, input.value));
  
        $(".show_loader").removeClass("hidden");
        $(".no_loader").removeClass("hidden").addClass("hidden");

    setTimeout(() => {
      $.ajax({
        url: usePath + "amount_transaction_list/ajax_process",
        type: 'POST',
        data: formData,
        contentType: false,
        processData: false,
        success: function (resp) {

        $(".show_loader").removeClass("hidden").addClass("hidden");
        $(".no_loader").removeClass("hidden");


          if (resp.status) {
            $("#mid").val(resp.profileid);
            alert(resp.message);
            window.location.href = usePath + "amount_transaction_list";
          } else {
            alert(resp.message);
          }
        },
        error: function () {
       $(".show_loader").removeClass("hidden").addClass("hidden");
        $(".no_loader").removeClass("hidden");

          alert("An error occurred while processing the request.");
        },
        cache: false,
      });
    }, 500);
  }

  function process_cancel_this_transaction() {
    var usePath = $.trim($("#rootXPath").val());
    var mid = $.trim($("#mid").val());
    var trn_amt_dept = $.trim($("#trn_amt_dept").val());
    var trn_amt_contract_no = $.trim($("#trn_amt_contract_no").val());
    var cancel_remarks = $.trim($("#trn_cancel_remarks").val())

    if (!cancel_remarks ) {
   showToast("info","Remarks for Cancellation is required!");
   $("#trn_cancel_remarks").focus();
   return false;
  }

   if (!confirm("This will cancel the Transaction. Are you sure you want to cancel the Transaction?")) {
    return false; // Stop if user clicks Cancel
  }
    setTimeout(() => {
      $.ajax({
      url: usePath + "amount_transaction_list/ajax_process",
      type: 'POST',
      data: { 
      trn_amt_contract_no: trn_amt_contract_no, 
      trn_amt_dept: trn_amt_dept,
      mid: mid,
      cancel_remarks: cancel_remarks,
      identity: "CANCELTRNSCTN" 
    },
      async: false,
        success: function (resp) {
          if (resp.status) {
            $("#mid").val(resp.profileid);
            alert(resp.message);
            window.location.href = usePath + "amount_transaction_list";
          } else {
            alert(resp.message);
          }
        },
        error: function () {
          alert("An error occurred while processing the request.");
        },
        cache: false,
      });
    }, 500);
  }
  
  function search_transaction_filter(){
  var useroot = $("#rootXPath").val();
  $(".show_loader").removeClass("hidden");
  $(".no_loader").removeClass("hidden").addClass("hidden")
  $("form#myForms").attr("action",useroot+"date_time_transaction_list/search");
  $("form#myForms").submit();
}


function updateFactorValue() {
    const checkbox = document.getElementById('factor_0');
    const hiddenField = document.getElementById('trn_factor_0');
    hiddenField.value = checkbox.checked ? 'Y' : '';
  }

  