
function isNumberFloatKey(evt)

{

  var charCode = (evt.which) ? evt.which : evt.keyCode;

  if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57)){

      return false;

  }

  return true;

}


   $(document).ready(function() {
      $('#trn_addon_contract_no').select2({
        placeholder: "-Select-",
        allowClear: true,
        width: 'resolve'  // auto width
      });
      
       $('#trn_addon_contract_no').on('select2:open', function () {
        $('.select2-search__field').focus();
      });
      
    });

    
function addon_remarks_type_onchange() {
  var department = $.trim($("#trn_addon_dept").val());
if (department == 'Venue' || department == 'Catering'){
  $("#addon_type").removeClass("hidden");
  $("#addon_remarks").removeClass("hidden").addClass("hidden");
}
else if (department == 'Decor' || department == 'Entertainment'){
  $("#addon_type").removeClass("hidden").addClass("hidden");
  $("#addon_remarks").removeClass("hidden");
}
else{
  $("#addon_type").removeClass("hidden").addClass("hidden");
  $("#addon_remarks").removeClass("hidden").addClass("hidden");
}
}

function get_contracts() {
    var usePath = $.trim($("#rootXPath").val());
    var department = $.trim($("#trn_addon_dept").val());

    $.ajax({
        url: usePath + "addon_transaction_list/ajax_process",
        type: 'POST',
        data: { 'department': department, 'identity': 'DEPTCHANGE' },
        async: false,
        success: function (resp) {
            if (resp.status) {
                var contractDropdown = $("#trn_addon_contract_no");
                var addon_dropdown = $("#trn_ado_addon");

                contractDropdown.empty();
                contractDropdown.append('<option value="">-Select-</option>');

                addon_dropdown.empty();
                addon_dropdown.append('<option value="">-Select-</option>');
                $.each(resp.data, function (index, contract) {
                    var label = contract.entry_no + ' - ' + contract.guest_name + ' (' + contract.contact_no + ')';
                    contractDropdown.append('<option value="' + contract.entry_no + '">' + label + '</option>');
                });
                $.each(resp.addon_list, function (index, addon) {
                    addon_dropdown.append('<option value="' + addon.id + '">' + addon.addon_type + '</option>');
                });
            } else {
                alert("No contracts found for selected department.");
            }
        },
        error: function () {
            alert("Error while fetching contracts.");
        },
        cache: false
    });
}

function get_addons_on_department() {
    var usePath = $.trim($("#rootXPath").val());
    var department = $.trim($("#trn_addon_dept").val());

    $.ajax({
        url: usePath + "addon_transaction_list/ajax_process",
        type: 'POST',
        data: { 'department': department, 'identity': 'DEPTCHANGE' },
        async: false,
        success: function (resp) {
            if (resp.status) {
                var addon_dropdown = $("#trn_ado_addon");
                addon_dropdown.empty();
                addon_dropdown.append('<option value="">-Select-</option>');
                $.each(resp.addon_list, function (index, addon) {
                    addon_dropdown.append('<option value="' + addon.id + '">' + addon.addon_type + '</option>');
                });
            } else {
                alert("No contracts found for selected department.");
            }
        },
        error: function () {
            alert("Error while fetching contracts.");
        },
        cache: false
    });
}

function search_transaction_filter(){
  var useroot = $("#rootXPath").val();
  $(".show_loader").removeClass("hidden");
  $(".no_loader").removeClass("hidden").addClass("hidden")
  $("form#myForms").attr("action",useroot+"addon_transaction_list/search");
  $("form#myForms").submit();
}

$(document).ready(function(){

  flatpickr("#from_date", {

    dateFormat: "d-M-Y",

    allowInput: true,

    onOpen: function (selectedDates, dateStr, instance) {

      instance.setDate(instance.input.value, false);

    },

  });

});

$(document).ready(function(){

  flatpickr("#upto_date", {

    dateFormat: "d-M-Y",

    allowInput: true,

    onOpen: function (selectedDates, dateStr, instance) {

      instance.setDate(instance.input.value, false);

    },

  });

});

function get_functions() {
    var usePath = $.trim($("#rootXPath").val());
    var contractno = $.trim($("#trn_addon_contract_no").val());
    var department = $.trim($("#trn_addon_dept").val());
    $.ajax({
        url: usePath + "addon_transaction_list/ajax_process",
        type: 'POST',
        data: { 'contractno': contractno,  'department': department, 'identity': 'CONTRACTCHANGE' },
        async: false,
        success: function (resp) {
            if (resp.status) {
                var functionDropdown = $("#trn_function_type");
                functionDropdown.empty();
                functionDropdown.append('<option value="">-Select-</option>');
                $.each(resp.data, function (index, functiontype) {
                    functionDropdown.append('<option value="' + functiontype.function_id + '">' + functiontype.function_type + '</option>');
                });
              $("#guest_details_card").removeClass("hidden");
              $("#guest_details_card").html(resp.data2);
            } else {
                alert("No functions found for selected contract.");
                $("#guest_details_card").hide().html(""); 
            }
        },
        error: function () {
            alert("Error while fetching contracts.");
        },
        cache: false
    });
}

function get_guest_details() {
    var usePath = $.trim($("#rootXPath").val());
    var contractno = $.trim($("#trn_addon_contract_no").val());
    var department = $.trim($("#trn_addon_dept").val());
    $.ajax({
        url: usePath + "addon_transaction_list/ajax_process",
        type: 'POST',
        data: { 'contractno': contractno,  'department': department, 'identity': 'CONTRACTCHANGE' },
        async: false,
        success: function (resp) {
            if (resp.status) {
              $("#guest_details_card").removeClass("hidden");
              $("#guest_details_card").html(resp.data2);
            } else {
                alert("No functions found for selected contract.");
                $("#guest_details_card").hide().html(""); 
            }
        },
        error: function () {
            alert("Error while fetching contracts.");
        },
        cache: false
    });
}

function get_addons_details() {
  var usePath = $.trim($("#rootXPath").val());
  const trn_function_type = $("#trn_function_type").val();
  const trn_addon_contract_no = $("#trn_addon_contract_no").val();
  const trn_addon_dept = $("#trn_addon_dept").val();

  $.ajax({
    url: usePath + "addon_transaction_list/ajax_process",
    type: "POST",
    data: { 
      trn_addon_contract_no: trn_addon_contract_no, 
      trn_function_type: trn_function_type, 
      trn_addon_dept: trn_addon_dept,
      identity: "SELECTITEMLIST" 
    },
    async: false,
    success: function (resp) {
      if (resp.status) {
        $("#addon_info_list").html(resp.data);
      } else {
        showToast("error", resp.message);
      }
    },
    error: function () {
      showToast("error", "An error occurred while processing the request.");
    },
    cache: false
  });
}

  function get_all_items_details() {
    var usePath = $.trim($("#rootXPath").val());
    const trn_addon_dept = $("#trn_addon_dept").val();
    const trn_function_type = $("#trn_function_type").val();
    const trn_addon_contract_no = $("#trn_addon_contract_no").val();
    const mid = $("#mid").val();
    $.ajax({
      url: usePath + "addon_transaction_list/ajax_process",
      type: "POST",
      data: { 
        trn_addon_contract_no: trn_addon_contract_no, 
        trn_function_type: trn_function_type, 
        trn_addon_dept: trn_addon_dept,
        mid: mid,
        identity: "SHOWALLITEMS" 
      },
      async: false,
      success: function (resp) {
        if (resp.status) {
          $("#addon_info_list").html(resp.data); 
        } else {
          showToast("error", resp.message);
        }
      },
      error: function () {
        showToast("error", "An error occurred while processing the request.");
      },
      cache: false
    });
  }

  function get_all_add_items_details() {
    var usePath = $.trim($("#rootXPath").val());

  // Get values from hidden fields
    const trn_function_type = $("#trn_function_type").val();
    const trn_addon_contract_no = $("#trn_addon_contract_no").val();
    const mid = $("#mid").val();
    $.ajax({
      url: usePath + "addon_transaction_list/ajax_process",
      type: "POST",
      data: { 
        trn_addon_contract_no: trn_addon_contract_no, 
        trn_function_type: trn_function_type, 
        mid: mid,
        identity: "SHOWADDITEMS" 
      },
      async: false,
      success: function (resp) {
        if (resp.status) {
          $("#addon_info_list_2").html(resp.data); 

        } else {
          showToast("error", resp.message);
        }
      },
      error: function () {
        showToast("error", "An error occurred while processing the request.");
      },
      cache: false
    });
  }

function reset_menu_items_details(){
  $("#trn_group").val('');
  $("#trn_title").val('');
  $("#trn_item").val('');
  $("#trn_group_display").val('')
  $("#trn_title_display").val('');
  $("#trn_item_display").val('') ;
  $("#trn_footer_id").val('');
  $("#trn_cater_entry_num").val('')
  $("#trn_cater_dtl_id").val('');
    $("input[name='post_type_select[]']").prop("checked", false);

  // Uncheck all checkboxes in the title section
  $("input[name='post_type_select2[]']").prop("checked", false);

  // Uncheck all checkboxes in the item section
  $("input[name='post_type_select3[]']").prop("checked", false);
  get_selected_group_titles();
  get_selected_group_items();
  get_selected_items_type();
}

function process_add_to_list() {
    var usePath = $.trim($("#rootXPath").val());
    var formData = new FormData();
    var mid = $.trim($("#mid").val());
    var trn_addon_dept = $.trim($("#trn_addon_dept").val());
    var trn_addon_contract_no = $.trim($("#trn_addon_contract_no").val());
    var trn_function_type = $.trim($("#trn_function_type").val());
  
    // Input Validation
    if (!trn_addon_dept) {
      showToast("error","Please Select Department!");
      $("#trn_addon_dept").focus();
      return false;
    }
  
    if (!trn_addon_contract_no) {
      showToast("error","Contact No. is required");
      $("#trn_addon_contract_no").focus();
      return false;
    }
  
    if (!trn_function_type) {
      showToast("error","Function Type is required");
      $("#trn_function_type").focus();
      return false;
    }
  
    // Prepare Form Data
    formData.append("identity", "ADDMENUITEM");
    var otherData = $('form#myforms').serializeArray();
    otherData.forEach((input) => {
      formData.append(input.name, input.value);
    });
    // formData.append("trd_otherloc", trndbrach);
    $(".no_loader").removeClass("hidden").addClass("hidden");
    $(".loader").removeClass("hidden");  
    // AJAX Request
    $.ajax({
      url: `${usePath}addon_transaction_list/ajax_process`,
      type: "POST",
      data: formData,
      contentType: false,
      processData: false,
      success: function (resp) {
        if (resp.message) {
          $(".no_loader").removeClass("hidden");
          $(".loader").removeClass("hidden").addClass("hidden"); 
          showToast("success",resp.message);
        }
  
        if (resp.headerid > 0) {
          $(".no_loader").removeClass("hidden");
          $(".loader").removeClass("hidden").addClass("hidden"); 
          $("#mid").val(resp.headerid);
          $("#prepid").val(resp.prepid); 
        } else {
          $(".no_loader").removeClass("hidden");
          $(".loader").removeClass("hidden").addClass("hidden"); 
          $("#mid").val('');
        }
  
        if (resp.data && resp.message !== "Already Exists.") {
          $(".no_loader").removeClass("hidden");
          $(".loader").removeClass("hidden").addClass("hidden"); 
          $("#addon_info_list_2").html(resp.data);
          
        }
  
        // setTimeout(() => reset_menu_items_details(), 500);
      
      },
      error: function (xhr, status, error) {
        console.error("AJAX Error:", status, error);
        alert("An error occurred while processing the request.");
      },
      cache: false,
    });
  }
  
function process_decor_remove_from_list(rowId, adc_addon, adc_remarks, adc_quantity, adc_amount) {
  var usePath = $.trim($("#rootXPath").val());
  var formData = new FormData();

  var trn_function_type = $.trim($("#trn_function_type").val());
  var trn_addon_dept = $.trim($("#trn_addon_dept").val());
  var trn_addon_contract_no = $.trim($("#trn_addon_contract_no").val());

    if (!trn_addon_dept) {
      showToast("error","Please Select Department!");
      $("#trn_addon_dept").focus();
      return false;
    }
  
    if (!trn_addon_contract_no) {
      showToast("error","Contact No. is required");
      $("#trn_addon_contract_no").focus();
      return false;
    }
  
    if (!trn_function_type) {
      showToast("error","Function Type is required");
      $("#trn_function_type").focus();
      return false;
    }

  formData.append("identity", "REMOVEMENUITM");
  formData.append("trn_newaddon", adc_addon);
  formData.append("trn_newremarks", adc_remarks);
  formData.append("trn_newquantity", adc_quantity);
  formData.append("trn_newamount", adc_amount);
  formData.append("trn_footer_id", rowId);

  // Include other fields from form
  var otherData = $('form#myforms').serializeArray();
  otherData.forEach((input) => {
    formData.append(input.name, input.value);
  });

  $(".loader").removeClass("hidden");

  $.ajax({
    url: `${usePath}addon_transaction_list/ajax_process`,
    type: "POST",
    data: formData,
    contentType: false,
    processData: false,
    success: function (resp) {
      $(".loader").addClass("hidden");

      if (resp.message) showToast("success", resp.message);
      if (resp.headerid > 0) {
        $("#mid").val(resp.headerid);
        $("#prepid").val(resp.prepid);
      }

      if (resp.data) {
       get_all_items_details();
      }

      // Add strike-through effect

    },
    error: function (xhr, status, error) {
      $(".loader").addClass("hidden");
      alert("An error occurred while processing.");
    },
    cache: false,
  });
}
  
function process_catering_remove_from_list(rowId, acc_addon, acc_remarks, acc_quantity, acc_amount) {
  var usePath = $.trim($("#rootXPath").val());
  var formData = new FormData();

  var trn_function_type = $.trim($("#trn_function_type").val());
  var trn_addon_dept = $.trim($("#trn_addon_dept").val());
  var trn_addon_contract_no = $.trim($("#trn_addon_contract_no").val());

    if (!trn_addon_dept) {
      showToast("error","Please Select Department!");
      $("#trn_addon_dept").focus();
      return false;
    }
  
    if (!trn_addon_contract_no) {
      showToast("error","Contact No. is required");
      $("#trn_addon_contract_no").focus();
      return false;
    }
  
    if (!trn_function_type) {
      showToast("error","Function Type is required");
      $("#trn_function_type").focus();
      return false;
    }

  formData.append("identity", "REMOVEMENUITM");
  formData.append("trn_newaddon", acc_addon);
  formData.append("trn_newtype", acc_remarks);
  formData.append("trn_newquantity", acc_quantity);
  formData.append("trn_newamount", acc_amount);
  formData.append("trn_footer_id", rowId);

  // Include other fields from form
  var otherData = $('form#myforms').serializeArray();
  otherData.forEach((input) => {
    formData.append(input.name, input.value);
  });

  $(".loader").removeClass("hidden");

  $.ajax({
    url: `${usePath}addon_transaction_list/ajax_process`,
    type: "POST",
    data: formData,
    contentType: false,
    processData: false,
    success: function (resp) {
      $(".loader").addClass("hidden");

      if (resp.message) showToast("success", resp.message);
      if (resp.headerid > 0) {
        $("#mid").val(resp.headerid);
        $("#prepid").val(resp.prepid);
      }

      if (resp.data) {
       get_all_items_details();
      }

      // Add strike-through effect

    },
    error: function (xhr, status, error) {
      $(".loader").addClass("hidden");
      alert("An error occurred while processing.");
    },
    cache: false,
  });
}

function process_entertain_remove_from_list(rowId, aec_addon, aec_remarks, aec_quantity, aec_amount) {
  var usePath = $.trim($("#rootXPath").val());
  var formData = new FormData();

  var trn_function_type = $.trim($("#trn_function_type").val());
  var trn_addon_dept = $.trim($("#trn_addon_dept").val());
  var trn_addon_contract_no = $.trim($("#trn_addon_contract_no").val());

    if (!trn_addon_dept) {
      showToast("error","Please Select Department!");
      $("#trn_addon_dept").focus();
      return false;
    }
  
    if (!trn_addon_contract_no) {
      showToast("error","Contact No. is required");
      $("#trn_addon_contract_no").focus();
      return false;
    }
  
    if (!trn_function_type) {
      showToast("error","Function Type is required");
      $("#trn_function_type").focus();
      return false;
    }

  formData.append("identity", "REMOVEMENUITM");
  formData.append("trn_newaddon", aec_addon);
  formData.append("trn_newremarks", aec_remarks);
  formData.append("trn_newquantity", aec_quantity);
  formData.append("trn_newamount", aec_amount);
  formData.append("trn_footer_id", rowId);

  // Include other fields from form
  var otherData = $('form#myforms').serializeArray();
  otherData.forEach((input) => {
    formData.append(input.name, input.value);
  });

  $(".loader").removeClass("hidden");

  $.ajax({
    url: `${usePath}addon_transaction_list/ajax_process`,
    type: "POST",
    data: formData,
    contentType: false,
    processData: false,
    success: function (resp) {
      $(".loader").addClass("hidden");

      if (resp.message) showToast("success", resp.message);
      if (resp.headerid > 0) {
        $("#mid").val(resp.headerid);
        $("#prepid").val(resp.prepid);
      }

      if (resp.data) {
       get_all_items_details();
      }

      // Add strike-through effect

    },
    error: function (xhr, status, error) {
      $(".loader").addClass("hidden");
      alert("An error occurred while processing.");
    },
    cache: false,
  });
}

function process_venue_remove_from_list(rowId, avc_addon, avc_remarks, avc_quantity, avc_amount) {
  var usePath = $.trim($("#rootXPath").val());
  var formData = new FormData();

  var trn_function_type = $.trim($("#trn_function_type").val());
  var trn_addon_dept = $.trim($("#trn_addon_dept").val());
  var trn_addon_contract_no = $.trim($("#trn_addon_contract_no").val());

    if (!trn_addon_dept) {
      showToast("error","Please Select Department!");
      $("#trn_addon_dept").focus();
      return false;
    }
  
    if (!trn_addon_contract_no) {
      showToast("error","Contact No. is required");
      $("#trn_addon_contract_no").focus();
      return false;
    }
  
    if (!trn_function_type) {
      showToast("error","Function Type is required");
      $("#trn_function_type").focus();
      return false;
    }

  formData.append("identity", "REMOVEMENUITM");
  formData.append("trn_newaddon", avc_addon);
  formData.append("trn_newtype", avc_remarks);
  formData.append("trn_newquantity", avc_quantity);
  formData.append("trn_newamount", avc_amount);
  formData.append("trn_footer_id", rowId);

  // Include other fields from form
  var otherData = $('form#myforms').serializeArray();
  otherData.forEach((input) => {
    formData.append(input.name, input.value);
  });

  $(".loader").removeClass("hidden");

  $.ajax({
    url: `${usePath}addon_transaction_list/ajax_process`,
    type: "POST",
    data: formData,
    contentType: false,
    processData: false,
    success: function (resp) {
      $(".loader").addClass("hidden");

      if (resp.message) showToast("success", resp.message);
      if (resp.headerid > 0) {
        $("#mid").val(resp.headerid);
        $("#prepid").val(resp.prepid);
      }

      if (resp.data) {
       get_all_items_details();
      }

      // Add strike-through effect

    },
    error: function (xhr, status, error) {
      $(".loader").addClass("hidden");
      alert("An error occurred while processing.");
    },
    cache: false,
  });
}

$(document).ready(function() {
  get_all_items_details();
  get_all_add_items_details();

    var contractno = $.trim($("#trn_addon_contract_no").val());
    if (contractno !== ''){
      get_guest_details();
    }
    var departmnet = $.trim($("#trn_addon_dept").val());
    if (departmnet !== ''){
    get_addons_on_department();
    addon_remarks_type_onchange();
    }
});

function handleAdoTypeChange() {
  const adoType = document.getElementById("trn_ado_type").value;
  const adoRate = document.getElementById("trn_ado_rate");
  const adoFunctionPax = document.getElementById("ado_function_pax");
  const adoAmount = document.getElementById("trn_ado_amount");

  if (adoType === "lumpsum") {
    // For lumpsum, set the rate to 1, make it readonly, and clear amount
    adoRate.value = 1;
    adoRate.readOnly = true;
    if (!adoAmount.value) {
      adoAmount.value = "";
    }
    adoAmount.readOnly = false;
  } else if (adoType === "person") {
    // Make the amount field readonly and calculate amount
    adoRate.readOnly = false; // Allow editing the rate
    adoFunctionPax.addEventListener("input", updateAmount);
    adoRate.addEventListener("input", updateAmount);
    adoAmount.readOnly = true;
    updateAmount(); // Initial calculation
  } else {
    // Default case: Allow editing both rate and amount
    adoRate.readOnly = false;
    adoAmount.readOnly = false;
  }

  function updateAmount() {
    const pax = parseFloat(adoFunctionPax.value) || 0; // Default to 0 if empty
    const rate = parseFloat(adoRate.value) || 0;       // Default to 0 if empty
    adoAmount.value = (pax * rate);         // Calculate and set amount
  }
}


function delete_menu_item(addonid) {
  const usePath = $("#rootXPath").val();
  var trn_cater_entry_num = $.trim($("#trn_cater_entry_num").val());
  var trn_cater_dtl_id = $.trim($("#trn_cater_dtl_id").val());

  if (confirm("Are you sure you want to delete this record ?")) {
      $.ajax({
          url: `${usePath}addon_transaction_list/ajax_process`,
          type: 'POST',
          data: {
            addonid: addonid,
              identity: 'DELETEADDON'
          },
          success: function (resp) {
              if (resp.status) {
                  // Update the UI with new data
                  $("#addon_info_list_2").html(resp.data);

                  // Show success toast
                  showToast("success", resp.message);
              } else {
                  // Handle failure response
                  $(".no_loader").addClass("hidden");
                  $(".loader").addClass("hidden");
                  $(".process_qualif_save").show();

                  // Show error toast
                  showToast("error", resp.message);
              }
          },
          error: function () {
              // Handle request failure
              $(".unprocess_loader").removeClass("hidden");
              $(".process_loader").addClass("hidden");

              showToast("error", "An error occurred while processing your request.");
          },
          cache: false
      });
  }
}

function process_add_again(addonid) {
  const usePath = $("#rootXPath").val();
  var trn_ado_fis_enrty_no = $.trim($("#trn_ado_fis_enrty_no").val());
  var trn_addon_dtl_id = $.trim($("#trn_addon_dtl_id").val());
  var trn_addon_contract_no = $.trim($("#trn_addon_contract_no").val());
      $.ajax({
          url: `${usePath}addon_transaction_list/ajax_process`,
          type: 'POST',
          data: {
            addonid: addonid,
            trn_addon_contract_no : trn_addon_contract_no,
              identity: 'ADDAGAIN'
          },
          success: function (resp) {
              if (resp.status) {
                  // Update the UI with new data
                  showToast("success", resp.message);

                  get_all_items_details();
                  // $("#func_info_list").html(resp.fisdtl);

                  // Show success toast
              } else {
                  // Handle failure response
                  $(".no_loader").addClass("hidden");
                  $(".loader").addClass("hidden");
                  $(".process_qualif_save").show();

                  // Show error toast
                  showToast("error", resp.message);
              }
          },
          error: function () {
              // Handle request failure
              $(".unprocess_loader").removeClass("hidden");
              $(".process_loader").addClass("hidden");

              showToast("error", "An error occurred while processing your request.");
          },
          cache: false
      });
  
}

function process_update_this_transaction(){
      var usePath = $.trim($("#rootXPath").val());
      var transaction_no = $.trim($("#trn_addon_no").val());
      var departmnet = $.trim($("#trn_addon_dept").val());
  // Get values from hidden fields
    var function_type = $("#trn_function_type").val();
    var contract_no = $("#trn_addon_contract_no").val();
    var mid = $("#mid").val();
    $.ajax({
      url: usePath + "addon_transaction_list/ajax_process",
      type: "POST",
      data: { 
        contract_no: contract_no, 
        function_type: function_type, 
        transaction_no: transaction_no,
        departmnet: departmnet,
        mid: mid,
        identity: "UPDATETRNSCTN" 
      },
      async: false,
      success: function (resp) {
        alert(resp.message);
        window.location.reload();
      },
      error: function () {
        showToast("error", "An error occurred while processing the request.");
      },
      cache: false
    });
}

function process_cancel_this_transaction(){
      var usePath = $.trim($("#rootXPath").val());
      var transaction_no = $.trim($("#trn_addon_no").val());
      var departmnet = $.trim($("#trn_addon_dept").val());
  // Get values from hidden fields
    var function_type = $("#trn_function_type").val();
    var contract_no = $("#trn_addon_contract_no").val();
    var mid = $("#mid").val();

    var cancel_remarks = $.trim($("#trn_cancel_remarks").val())

    if (!cancel_remarks ) {
   showToast("info","Remarks for Cancellation is required!");
   $("#trn_cancel_remarks").focus();
   return false;
  }

   if (!confirm("This will cancel the Transaction. Are you sure you want to cancel the Transaction?")) {
    return false; // Stop if user clicks Cancel
  }

    $.ajax({
      url: usePath + "addon_transaction_list/ajax_process",
      type: "POST",
      data: { 
        contract_no: contract_no, 
        function_type: function_type, 
        transaction_no: transaction_no,
        departmnet: departmnet,
        cancel_remarks: cancel_remarks,
        mid: mid,
        identity: "CANCELTRNSCTN" 
      },
      async: false,
      success: function (resp) {
        alert(resp.message);
        window.location.reload();
      },
      error: function () {
        showToast("error", "An error occurred while processing the request.");
      },
      cache: false
    });
}