function set_global_focus(id){

    $("#"+id).focus();
  
  }

  
    $("#catering_search").on("keypress", function(e) {
    if (e.which === 13) { // 13 = Enter key
        e.preventDefault();
        search_lead_catering_filter();
    }
});


function updateDateLabels() {
    let type = $("#search_date_type").val();

    if (type === "CD") {
        $("label[for='from_date']").text("Created From");
        $("label[for='upto_date']").text("Created Upto");

    } else {
        $("label[for='from_date']").text("Function From");
        $("label[for='upto_date']").text("Function Upto");

    }
}

// Run once after page refresh
$(document).ready(function() {
    updateDateLabels();
});

// Run again when select changes
$(document).on("change", "#search_date_type", function () {
    updateDateLabels();
});

  function saveCateringDetail() {
      var usePath = $.trim($("#rootXPath").val());
      var formData = new FormData();
      var mid = $.trim($("#mid").val());
      var ch_guest_name = $.trim($("#ch_guest_name").val());
      var ch_contact_no = $.trim($("#ch_contact_no").val());
      var ch_address = $.trim($("#ch_address").val());
      var ch_state = $.trim($("#ch_state").val());
      var ch_email = $.trim($("#ch_email").val());
      var chd_entry_num = $.trim($("#chd_entry_num").val());
      var chd_function = $.trim($("#chd_function").val());
      var chd_date = $.trim($("#chd_date").val());
      var chd_time = $.trim($("#chd_time").val());
      var chd_lead_type = $.trim($("#chd_lead_type").val());
      var chd_venue1 = $.trim($("#chd_venue1").val());
      var chd_address1 = $.trim($("#chd_address1").val());
      var chd_venue2 = $.trim($("#chd_venue2").val());
      var chd_address2 = $.trim($("#chd_address2").val());
      var chd_min_guarante = $.trim($("#chd_min_guarante").val());
      var chd_session = $.trim($("#chd_session").val());
      var chd_lumpsum = $.trim($("#chd_lumpsum").val());
      var chd_priority = $.trim($("#chd_priority").val());
      var chd_remarks = $.trim($("#chd_remarks").val());
      var trdLocation = $.trim($("#trd_location").val());
      var trq_mobile_no = $.trim($("#trq_mobile_no").val());
    
      let trndbrach = "";
    
      // Input Validation
      if (!ch_guest_name) {
        showToast("error","Guest Name is required");
        $("#ch_guest_name").focus();
        return false;
      }
    
      if (!ch_contact_no) {
        showToast("error","Contact No. is required");
        $("#ch_contact_no").focus();
        return false;
      }
    
      if (!ch_address) {
        showToast("error","Address is required");
        $("#ch_address").focus();
        return false;
      }
    
      if (!ch_state) {
        showToast("error","State is required");
        $("#ch_state").focus();
        return false;
      }
    
      // Validate Mobile Number (if provided)
      if (ch_contact_no && ch_contact_no.length < 10) {
        showToast("error","Mobile number should be at least 10 digits");
        $("#ch_contact_no").focus();
        return false;
      }
  
      if (ch_email!=''){
        if (!check_email_validation(ch_email, 'ch_email')) {
         setTimeout(function(){ set_global_focus('ch_email');},500);
         return false;
       }}
  
       if (!chd_function) {
        showToast("error","Function is required");
        $("#chd_function").focus();
        return false;
      }
  
      if (!chd_date) {
        showToast("error","Date is required");
        $("#chd_date").focus();
        return false;
      }

      if (!chd_time) {
        showToast("error","Time is required");
        $("#chd_time").focus();
        return false;
      }
  
      if (!chd_lead_type) {
        showToast("error","Lead Type is required");
        $("#chd_lead_type").focus();
        return false;
      }

  if (chd_lead_type == 'I') {
    if (!chd_venue1) {
      showToast("error", "Venue is required");
      $("#chd_venue1").focus();
      return false;
    }
    if (!chd_address1) {
      showToast("error", "Location is required");
      $("#chd_address1").focus();
      return false;
    }
  }

  if (chd_lead_type == 'O') {
    if (!chd_venue2) {
      showToast("error", "Venue Name is required");
      $("#chd_venue2").focus();
      return false;
    }
    if (!chd_address2) {
      showToast("error", "Location Name is required");
      $("#chd_address2").focus();
      return false;
    }
  }
    
      // Prepare Form Data
      formData.append("identity", "CATERINGDTL");
      var otherData = $('form#myforms').serializeArray();
      otherData.forEach((input) => {
        formData.append(input.name, input.value);
      });
      // formData.append("trd_otherloc", trndbrach);
      $(".no_loader").removeClass("hidden").addClass("hidden");
      $(".loader").removeClass("hidden");  
      // AJAX Request
      $.ajax({
        url: `${usePath}lead_department/ajax_process`,
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (resp) {
          if (resp.message) {
            $(".no_loader").removeClass("hidden");
            $(".loader").removeClass("hidden").addClass("hidden"); 
            showToast("success",resp.message);
            setTimeout(() => get_pick_a_lead_counts(), 1000);
            refreshTotalAmount();
            // window.location = usePath+"lead_department/lead_decor/"+mid;
          }
    
          if (resp.headerid > 0) {
            $(".no_loader").removeClass("hidden");
            $(".loader").removeClass("hidden").addClass("hidden"); 
            $("#mid").val(resp.headerid);
            $("#prepid").val(resp.prepid); 
            $("#curmobile").val(resp.currmobileno);
            $("#attach_gp_button").removeAttr('hidden'); // Show the Attach GP button
          } else {
            $(".no_loader").removeClass("hidden");
            $(".loader").removeClass("hidden").addClass("hidden"); 
            $("#mid").val('');
            $("#curmobile").val('');
            $("#attach_gp_button").attr('hidden', true); // Hide the Attach GP button if no tour ID
          }
          
    
          if (resp.data) {
            $(".no_loader").removeClass("hidden");
            $(".loader").removeClass("hidden").addClass("hidden"); 
            $("#cateringdetailgrid").html(resp.data);
          }
    
          // Call create_blanks() only when resp.status is true
        if (resp.status === true) {
          setTimeout(() => create_blanks(), 500);
        }
        },
        error: function (xhr, status, error) {
          console.error("AJAX Error:", status, error);
          alert("An error occurred while processing the request.");
        },
        cache: false,
      });
    }
  
    function create_blanks() {
      $("#prepid").val('');
      $("#chd_function").val('');
      $("#chd_date").val('');
      $("#chd_time").val('');
      $("#chd_lead_type").val('');
      $("#chd_min_guarante").val('');
      $("#chd_session").val('');
      $("#chd_lumpsum").val('');
      $("#chd_priority").val('');
      $("#chd_remarks").val('');
    
      // Clear dropdown & input values
      $("#chd_venue1").val('');
      $("#chd_address1").val('');
      $("#chd_venue2").val('');
      $("#chd_address2").val('');
    
      // Re-hide all optional blocks (Indoor/Outdoor sections)
      $("#venue_dropdown").addClass("hidden").find("select").val('');
      $("#address_dropdown").addClass("hidden").find("select").val('');
      $("#venue_input").addClass("hidden").find("input").val('');
      $("#address_input").addClass("hidden").find("input").val('');

      $("#chd_session").val('');
      $("#chd_catering").val('');
      $("#chd_menu").val('');
      $("#chd_pax").val('');
      $("#chd_freepax").val('');
      $("#chd_type").val('')
      $("#chd_rate").val('');
      $("#chd_value").val('');
      $("#chd_extra_plate").val('');
      $("#chd_transport_cost").val('');
    }
    
    
    function process_save_catering_header() {
      var usePath = $.trim($("#rootXPath").val());
      var formData = new FormData();
      var other_data = $('form#myforms').serializeArray();
    
      // Form field values
      var mid = $.trim($("#mid").val());
      var ch_entry_no = $.trim($("#ch_entry_no").val());
      var ch_guest_name = $.trim($("#ch_guest_name").val());
      var ch_contact_no = $.trim($("#ch_contact_no").val());
      var ch_func_from_date = $.trim($("#ch_func_from_date").val());
      var ch_func_upto_date = $.trim($("#ch_func_upto_date").val());
      var ch_state = $.trim($("#ch_state").val());
      var ch_address = $.trim($("#ch_address").val());
      var ch_city = $.trim($("#ch_city").val());
      var ch_pincode = $.trim($("#ch_pincode").val());
      var ch_email = $.trim($("#ch_email").val());
      var ch_enquiry_mode = $.trim($("#ch_enquiry_mode").val());
      var ch_proposal = $.trim($("#ch_proposal").val());
      var ch_total_tax = $.trim($("#ch_total_tax").val());
      var ch_total_amnt = $.trim($("#ch_total_amnt").val());
  
      // Validations
      if (!ch_guest_name) {
        showToast("error","Guest Name is required");
        $("#ch_guest_name").focus();
        return false;
      }
    
      if (!ch_contact_no) {
        showToast("error","Contact Number is required");
        $("#ch_contact_no").focus();
        return false;
      }
  
      if (!ch_address) {
        showToast("error","Address is required");
        $("#ch_address").focus();
        return false;
      }
  
      if (!ch_state) {
        showToast("error","State is required");
        $("#ch_state").focus();
        return false;
      }
    
      if (ch_contact_no) {
        if (ch_contact_no.length <= 9 || ch_contact_no.length > 10) {
          showToast("error","Mobile Number should be of 10 digits!");
            $("#ch_contact_no").focus();
            return false;
        }
      }
    
      if (ch_email!=''){
        if (!check_email_validation(ch_email, 'ch_email')) {
         setTimeout(function(){ set_global_focus('ch_email');},500);
         return false;
       }}
    
      // Append data to FormData
      formData.append("identity", "CATERINGSAVE");
      formData.append("mid", mid);
      other_data.forEach(input => formData.append(input.name, input.value));
    
      setTimeout(() => {
        $.ajax({
          url: usePath + "lead_department/ajax_process",
          type: 'POST',
          data: formData,
          contentType: false,
          processData: false,
          success: function (resp) {
            if (resp.status) {
              $("#mid").val(resp.decorid);
              showToast("success",resp.message);
              window.location.href = usePath + "lead_department";
    
            } else {
              alert(resp.message);
            }
          },
          error: function () {
            alert("An error occurred while processing the request.");
          },
          cache: false,
        });
      }, 500);
    }
    
  
    function fill_catering_list(guestInfoId){
      var usePath = $("#rootXPath").val();
  
      $.ajax({
               url: usePath+"lead_department/ajax_process",
               type: 'POST',
               data: {'identity':'FILLGUESTINFO','guestInfoId':guestInfoId},
               async: false,            
               success: function (resp) {
                if (resp.status === 'success') {
                  var data = resp.data;
                  $("#ch_guestinfo_id").val(data.id || '');
                  // Set form fields
                  $("#ch_guest_name").val(data.name || '');
                  $("#ch_contact_no").val(data.contact || '');
                  $("#chd_date").val(data.function_date || '');
                  $("#ch_city").val(data.city || '');
                  $("#ch_email").val(data.email || '');   // Not coming in response, left blank
                  $("#chd_remarks").val(data.remarks	 || '');   // Not coming in response, left blank
                  $("#ch_enquiry_mode").val(data.source		 || '');   // Not coming in response, left blank
                  $("#ch_enquiry_mode").val(data.source || '');      // Mode of Enquiry dropdown
                  $("#chd_function").val(data.function_type || '');  // Function dropdown
                  
                } else {
                  alert(resp.message || "Guest not found");
                }
                $("button[data-bs-dismiss='modal']").click();
  
               },
               error: function (textStatus, errorThrown) {
                   alert("Facing technical issue!");
               },
               cache: false
   
           });
     }
     var currentPrepidIndex = null;
  
     function fis_addon_list() {
      var usePath = $.trim($("#rootXPath").val());
      var prepid = $.trim($("#prepid").val());
      var ado_fis_enrty_no = $.trim($("#ch_entry_no").val());
      var ado_fis_dtl_id = $.trim($("#chd_function"+currentPrepidIndex).val());
      var ado_addon = $.trim($("#ado_addon").val());
      var ado_type = $.trim($("#ado_type").val());
      var ado_rate = $.trim($("#ado_rate").val());
      var ado_amount = $.trim($("#ado_amount").val());
      var ado_footer_id = $.trim($("#ado_footer_id").val());
      var addtype = $.trim($("#addtype").val());
    
      if (ado_addon === '') {
        showToast("error","Select Addon from list");
        $("#ado_addon").focus();
        return false;
      } else if (ado_type === '') {
        showToast("error","Select Addon Type.");
        $("#ado_type").focus();
        return false;
      }else if (ado_rate === '') {
        showToast("error","Addon Rate is required.");
        $("#ado_rate").focus();
        return false;
      }else if (ado_amount === '') {
        showToast("error","Addon Amount is required.");
        $("#ado_amount").focus();
        return false;
      }
    
    
     
        $.ajax({
          url: usePath+"lead_department/ajax_process",
          type: 'POST',
          data: { 'enrty_no': ado_fis_enrty_no, 'fis_dtl_id': ado_fis_dtl_id,'ado_addon': ado_addon, 'ado_type': ado_type,'ado_rate': ado_rate, 'ado_amount': ado_amount, 'ado_footer_id':ado_footer_id,'addtype':addtype,'identity': 'ADDON' },
          async: false,
          success: function (resp) {
            if( resp.status ){         
    
              $("#addon_info_list").html(resp.data);
              $("#ado_footer_id").html(resp.footerid);
            
              $("#func_info_list").html(resp.fisdtl);
              showToast("success",resp.message); 
              refreshTotalAmount();
    
              setTimeout(function(){ reset_addons_details();},500);         
    
            }else{
    
  
    
                $(".process_qualif_save").show();
    
                showToast("error",resp.message); 
    
              
    
            }
           
          },
          error: function () {
            $(".unprocess_loader").addClass("hidden");
            $(".process_loader").removeClass("hidden");
          },
          cache: false
        });
     
    }
  
    function reset_addons_details(){
  
      $("#ado_addon").val('');
    
      $("#ado_type").val('');
    
      $("#ado_rate").val('');
    
      $("#ado_amount").val('');
    
      $("#ado_footer_id").val('');
    
    }
    
    function edit_addon_list(id,addon,type,rate,amount){
    
      $("#ado_footer_id").val(id);
    
      $("#ado_addon").val(addon);
    
      $("#cur_ado_addon").val(addon);
    
      $("#ado_type").val(type);
    
      $("#ado_rate").val(rate);
    
      $("#ado_amount").val(amount);
      setTimeout(function(){ handleAdoTypeChange();},500);    
    
    }
    
    function delete_addon_record(addonId) {
      const usePath = $("#rootXPath").val();
      var ado_fis_enrty_no = $.trim($("#ado_fis_enrty_no").val());
      var ado_fis_dtl_id = $.trim($("#ado_fis_dtl_id").val());
    
      if (confirm("Are you sure you want to delete this record ?")) {
          $.ajax({
              url: `${usePath}lead_department/ajax_process`,
              type: 'POST',
              data: {
                  addonid: addonId,
                  ado_fis_enrty_no: ado_fis_enrty_no,
                  ado_fis_dtl_id: ado_fis_dtl_id,
                  identity: 'DELETE'
              },
              success: function (resp) {
                  if (resp.status) {
                      // Update the UI with new data
                      $("#addon_info_list").html(resp.data);
    
                      $("#func_info_list").html(resp.fisdtl);
    
                      // Show success toast
                      showToast("success", resp.message);
                  } else {
                      // Handle failure response
                      $(".no_loader").addClass("hidden");
                      $(".loader").addClass("hidden");
                      $(".process_qualif_save").show();
    
                      // Show error toast
                      showToast("error", resp.message);
                  }
              },
              error: function () {
                  // Handle request failure
                  $(".unprocess_loader").removeClass("hidden");
                  $(".process_loader").addClass("hidden");
    
                  showToast("error", "An error occurred while processing your request.");
              },
              cache: false
          });
      }
    }
  
    function handleAdoTypeChange() {
      const adoType = document.getElementById("ado_type").value;
      const adoRate = document.getElementById("ado_rate");
      const adoFunctionPax = document.getElementById("ado_function_pax");
      const adoAmount = document.getElementById("ado_amount");
    
      if (adoType === "lumpsum") {
        // For lumpsum, set the rate to 1, make it readonly, and clear amount
        adoRate.value = 1;
        adoRate.readOnly = true;
        if (!adoAmount.value) {
          adoAmount.value = "";
        }
        adoAmount.readOnly = false;
      } else if (adoType === "person") {
        // Make the amount field readonly and calculate amount
        adoRate.readOnly = false; // Allow editing the rate
        adoFunctionPax.addEventListener("input", updateAmount);
        adoRate.addEventListener("input", updateAmount);
        adoAmount.readOnly = true;
        updateAmount(); // Initial calculation
      } else {
        // Default case: Allow editing both rate and amount
        adoRate.readOnly = false;
        adoAmount.readOnly = false;
      }
    
      function updateAmount() {
        const pax = parseFloat(adoFunctionPax.value) || 0; // Default to 0 if empty
        const rate = parseFloat(adoRate.value) || 0;       // Default to 0 if empty
        adoAmount.value = (pax * rate);         // Calculate and set amount
      }
    }
  
    // USING FOR VIEW FIS SCREEN
  function get_fis_details_view(id, fis_entry,fnctn_pax) {
    var usePath = $.trim($("#rootXPath").val());
  
    // Set hidden field values
    $("#ado_fis_dtl_id").val(id);
    $("#ch_entry_no").val(fis_entry);
    $("#ado_function_pax").val(fnctn_pax);
  
    // Get values from hidden fields
    const ado_fis_dtl_id = $("#ado_fis_dtl_id").val();
    const ado_fis_enrty_no = $("#ch_entry_no").val();
  
    $.ajax({
      url: usePath + "lead_department/ajax_process",
      type: "POST",
      data: { 
        
        ado_fis_enrty_no: ado_fis_enrty_no, 
        identity: "ADDONLISTVIEW" 
      },
      async: false,
      success: function (resp) {
        if (resp.status) {
          // Populate the table with response data
          $("#addon_info_list_fis").html(resp.data);
          //showToast("success", resp.message);
        } else {
          showToast("error", resp.message);
        }
      },
      error: function () {
        showToast("error", "An error occurred while processing the request.");
      },
      cache: false
    });
  }
  function get_fis_details(id, entry_num,ck) {
    var usePath = $.trim($("#rootXPath").val());
    currentPrepidIndex = ck; // store globally
  
    // Set hidden field values
    $("#ch_entry_no").val(entry_num);
    $("#ado_fis_dtl_id").val(id);
  
    // Get values from hidden fields
    const ado_fis_dtl_id = $("#ado_fis_dtl_id").val();
    const ado_fis_enrty_no = $("#ch_entry_no").val();
  
    $.ajax({
      url: usePath + "lead_department/ajax_process",
      type: "POST",
      data: { 
        ado_fis_dtl_id: ado_fis_dtl_id, 
        ado_fis_enrty_no: ado_fis_enrty_no, 
        identity: "ADDONLIST" 
      },
      async: false,
      success: function (resp) {
        if (resp.status) {
          // Populate the table with response data
          $("#addon_info_list").html(resp.data);
          //showToast("success", resp.message);
        } else {
          showToast("error", resp.message);
        }
      },
      error: function () {
        showToast("error", "An error occurred while processing the request.");
      },
      cache: false
    });
  }
  
  $(document).ready(function(){
    flatpickr("#ch_func_from_date", {
     dateFormat: "d-M-Y",
     allowInput: true,
      onOpen: function (selectedDates, dateStr, instance) {
     instance.setDate(instance.input.value, false);
    },
   });
  });
  
  $(document).ready(function(){
    flatpickr("#ch_func_upto_date", {
     dateFormat: "d-M-Y",
     allowInput: true,
      onOpen: function (selectedDates, dateStr, instance) {
     instance.setDate(instance.input.value, false);
    },
   });
  });
  
  $(document).ready(function(){
    flatpickr("#chd_date", {
     dateFormat: "d-M-Y",
     allowInput: true,
      onOpen: function (selectedDates, dateStr, instance) {
     instance.setDate(instance.input.value, false);
    },
   });
  });
  
  $(document).ready(function(){
    flatpickr("#chd_date", {
     dateFormat: "d-M-Y",
     allowInput: true,
      onOpen: function (selectedDates, dateStr, instance) {
     instance.setDate(instance.input.value, false);
    },
   });
  });
  
  $(document).ready(function(){
    flatpickr("#from_date", {
     dateFormat: "d-M-Y",
     allowInput: true,
      onOpen: function (selectedDates, dateStr, instance) {
     instance.setDate(instance.input.value, false);
    },
   });
  });
  
  $(document).ready(function(){
    flatpickr("#upto_date", {
     dateFormat: "d-M-Y",
     allowInput: true,
      onOpen: function (selectedDates, dateStr, instance) {
     instance.setDate(instance.input.value, false);
    },
   });
  });
  
  function modify_function_list(id, functin, date, time, lead_type, venue1, address1, venue2, address2, session, catering, menu, pax, freepax, type, rate, value, extra_plate,transport_cost) {
    $("#prepid").val(id);
    $("#chd_function").val(functin);
    $("#chd_date").val(date);
    $("#chd_time").val(time);
    $("#chd_lead_type").val(lead_type);
      venue_leadtype();
    if (lead_type === "I") {
      $("#chd_venue1").val(venue1);
      $("#chd_address1").val(address1);
      getVenueLocationList();
    } else if (lead_type === "O") {
      $("#chd_venue2").val(venue2);
      $("#chd_address2").val(address2);
    }
    $("#chd_session").val(session);
    $("#chd_catering").val(catering);
    $("#chd_menu").val(menu);
    $("#chd_pax").val(pax);
    $("#chd_freepax").val(freepax);
    $("#chd_type").val(type);
    $("#chd_rate").val(rate);
    $("#chd_value").val(value);
    $("#chd_extra_plate").val(extra_plate);
    $("#chd_transport_cost").val(transport_cost);
      handleChargeTypeChange();

  }
  
  $(document).on("keypress","#catering_search",function(e){
    var keycode = (e.keyCode ? e.keyCode : e.which );
      if( keycode == '13' ){
        search_lead_catering_filter();
      }
  
  });
  function search_lead_catering_filter(){
    var useroot = $("#rootXPath").val();
    $(".show_loader").removeClass("hidden");
    $(".no_loader").removeClass("hidden").addClass("hidden")
    $("form#myForms").attr("action",useroot+"lead_department/search");
    $("form#myForms").submit();
  }

  function show_open_status_list() {
  $("#catering_status_search").val("open");
  search_lead_catering_filter();
}

function show_mild_status_list() {
  $("#catering_status_search").val("mild");
  search_lead_catering_filter();
}

function show_warm_status_list() {
  $("#catering_status_search").val("warm");
  search_lead_catering_filter();
}

function show_hot_status_list() {
  $("#catering_status_search").val("hot");
  search_lead_catering_filter();
}

function show_closed_status_list() {
  $("#catering_status_search").val("closed");
  search_lead_catering_filter();
}

function show_dead_status_list() {
  $("#catering_status_search").val("dead");
  search_lead_catering_filter();
}

function show_waste_status_list() {
  $("#catering_status_search").val("waste");
  search_lead_catering_filter();
}
  
  function check_email_validation(email, id) {
  
    if (!ValidateEmail(email)) {
  
      showToast("error", "Invalid Email Address!");
  
      $("#" + id).focus(); 
  
      return false; 
  
    }
  
    return true; 
  
  }
  
  
  function ValidateEmail(mail) {
  
    var emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
  
    return emailRegex.test(mail);
  
  }
  
  function isNumberKeys(evt) {
  
    evt = (evt) ? evt : window.event;
  
    var charCode = (evt.which) ? evt.which : evt.keyCode;
  
    if (charCode > 31 && (charCode < 48 || charCode > 57)) {
  
        return false;
  
    }
  
    return true;
  
  }
  
  
  function isFloatNegativeKey(e,vls){
  
  
  
    if (e.charCode >= 32 && e.charCode < 127 && !/^-?\d*[.,]?\d*$/.test(vls + '' + String.fromCharCode(e.charCode)))
  
    {
  
      return false;
  
    }
  
    return true;
  
  }
  
    
  function delete_catering_detail(id){
    var usePath      = $.trim( $("#rootXPath").val() );    
  
    if( confirm("Are you sure you want to delete?")){
        window.location = usePath+"lead_department/add_lead_department/"+id+"/deletecatreingdetail";
      }
  
  }
  
  
  function isNumberFloatKey(evt)
  
  {
  
    var charCode = (evt.which) ? evt.which : evt.keyCode;
  
    if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57)){
  
        return false;
  
    }
  
    return true;
  
  }
  
  function get_pick_a_lead_counts() {
    var usePath = $.trim($("#rootXPath").val());
  
    $.ajax({
      url: usePath + "lead_department/ajax_process",
      type: "POST",
      data: { identity: "SHOWCOUNT" },
      success: function (resp) {
        if (resp.guestinfocounts !== undefined) {
          $("#lead_count").text(resp.guestinfocounts);
        }
        if (resp.html) {
          $("#pickaleadgrid").html(resp.html);
        }
      },
      error: function () {
        console.error("Failed to fetch Pick a Lead count.");
      }
    });
  }
  
  function refreshTotalAmount() {
    var usePath = $.trim($("#rootXPath").val());
    var entry_no = $.trim($("#ch_entry_no").val());
  
    $.ajax({
      url: usePath + "lead_department/ajax_process",
      type: "POST",
      data: { identity: "GET_TOTAL_AMOUNT", entry_no: entry_no },
      success: function (resp) {
        if (resp.total_amount !== undefined) {
          $("#ch_total_amt").val(resp.total_amount);
          calculateDecorFinancials(); // Recalculate all dependent fields
        }
      },
      error: function () {
        console.error("Failed to fetch total amount.");
      }
    });
  }
  

function calculateDecorFinancials() {
  var totalAmount    = parseFloat($("#ch_total_amt").val()) || 0;
  var taxCAmount     = parseFloat($("#ch_tax_c_amt").val()) || 0;
  var taxDAmount     = parseFloat($("#ch_tax_d_amt").val()) || 0;
  var taxPercentC    = parseFloat($("#ch_tax_percent_c").val()) || 0;
  var taxPercentD    = parseFloat($("#ch_tax_percent_d").val()) || 0;
  var advanceCash    = parseFloat($("#ch_advance_cash").val()) || 0;
  var advanceBank    = parseFloat($("#ch_advance_chq").val()) || 0;
  var factor_0 = $("#ch_factor_0").is(":checked") ? 'Y' : 'N';

  // Step 1: Calculate bank payment
  var bankPayment = 0;
  if (taxCAmount >= 0 || taxDAmount >= 0) {
    bankPayment = taxCAmount + taxDAmount;
    $("#ch_cheque").val(bankPayment);
  } else {
    $("#ch_cheque").val(""); // Clear if no bank payment
  }

  // Step 2: Calculate dh_cash_part only if bank payment exists
  var cashPayment = 0;

  if (bankPayment >= 0) {
    if (factor_0 == 'N'){
      cashPayment = ((totalAmount*2) - bankPayment) * 0.1;
    }
    else {
      cashPayment = (totalAmount - bankPayment);
    }
    if (cashPayment < 0) cashPayment = 0;
    $("#ch_cash_part").val(cashPayment);
  } else {
    $("#ch_cash_part").val(""); // Clear if no valid input
  }

  // Step 3: Calculate tax amounts
  var taxAmountC = (taxCAmount * taxPercentC) / 100;
  var taxAmountD = (taxDAmount * taxPercentD) / 100;

  var totalTaxAmount = taxAmountC + taxAmountD;
  $("#ch_tax_amt").val(totalTaxAmount);

  // Step 4: Net amount
  var netAmount = cashPayment + bankPayment + totalTaxAmount;
  $("#ch_net_amt").val(netAmount);

  // Step 5: Total tax %
  var totalTaxPercent = taxPercentC + taxPercentD;
  $("#ch_tax_percent").val(totalTaxPercent);

  // Step 6: Balance
  var balance = netAmount - (advanceCash + advanceBank);
  $("#ch_balance").val(balance);

  // Step 7: Validation border logic
  var sumCheck = cashPayment + taxCAmount + taxDAmount;
  if (bankPayment > 0 && sumCheck != totalAmount) {

  } else {

  }
}
  
  $(document).ready(function () {
    $("#ch_cash_part,#ch_tax_c_amt, #ch_tax_d_amt, #ch_tax_percent_c, #ch_tax_percent_d,  #ch_advance_cash, #ch_advance_chq").on("input", function () {
      calculateDecorFinancials();
    });
    refreshTotalAmount();
    // Optional: also calculate once on page load if values exist
    calculateDecorFinancials();
  });
  
  function venue_leadtype(){
    var chd_lead_type = $.trim($("#chd_lead_type").val());
    if (chd_lead_type == 'I'){
      $("#venue_dropdown").removeClass("hidden");
      $("#address_dropdown").removeClass("hidden");
      $("#venue_input").removeClass("hidden").addClass("hidden").find("input").val("");;
      $("#address_input").removeClass("hidden").addClass("hidden").find("input").val("");;
    }else if (chd_lead_type == 'O'){
      $("#venue_input").removeClass("hidden");
      $("#address_input").removeClass("hidden");
      $("#venue_dropdown").removeClass("hidden").addClass("hidden").find("input").val("");;
      $("#address_dropdown").removeClass("hidden").addClass("hidden").find("input").val("");;
    }else {
      $("#venue_input").removeClass("hidden").addClass("hidden").find("input").val("");;
      $("#address_input").removeClass("hidden").addClass("hidden").find("input").val("");;
      $("#venue_dropdown").removeClass("hidden").addClass("hidden").find("input").val("");;
      $("#address_dropdown").removeClass("hidden").addClass("hidden").find("input").val("");;
    }
  }
  
  function getVenueLocationList() {
    var usePath = $.trim($("#rootXPath").val());
    var fisd_venue = $.trim($("#chd_venue1").val());
  
    $.ajax({
      url: `${usePath}information_list/ajax_process`,
      type: 'POST',
      data: {
        fisd_venue: fisd_venue,
        identity: "VLOC"
      },
      success: function (resp) {
        var sdata = resp.data;
        var mhtml = '<option value="">-Select-</option>';
        if (sdata.length > 0) {
          $.each(sdata, function (key, leds) {
            mhtml += '<option value="' + leds.id + '">' + leds.vloc_locname + '</option>';
          });
        } else {
          mhtml += '<option value="">No locations available</option>';
        }
        $("#chd_address1").html(mhtml);
      },
      error: function () {
        showToast("error", "Failed to fetch venue locations. Please try again.");
      },
      cache: false
    });
  }
  function get_fis_id_followup(id) {
    $("#FLLW_fis_id").val(id);
  }
  
  function get_fis_detals(id) {
    $("#FIS_id").val(id);
  }
  
  function get_fis_id_transfr(id,user,username) {
    $("#transfr_fis_id").val(id);
    $("#current_assigne_id").val(user);
    $("#current_assigne").val(username);
  }
  
  function saveAssignModal() {
    var usePath = $.trim($("#rootXPath").val());
    const FIS_id = $("#FIS_id").val();
    const FIS_Assign_User = document.getElementById('FIS_Assign_User').value || '';
    const FIS_Assign_Date = document.getElementById('FIS_Assign_Date').value || '';
    const FIS_Assign_Time = document.getElementById('FIS_Assign_Time').value || '';
    const FIS_Assign_Remarks = document.getElementById('FIS_Assign_Remarks').value || '';
    const FIS_Assign_type = document.getElementById('FIS_Assign_type').value || '';
  
    // Validation
    if (!FIS_Assign_User) {
      alert('Please select a user to assign.');
      return;
    }
  
    if (!FIS_Assign_Date) {
      alert('Please select an assign date.');
      return;
    }
  
    if (!FIS_Assign_Time) {
      alert('Please select an assign time.');
      return;
    }
  
    // CSRF Token (if needed)
    const csrfToken = $('meta[name="csrf-token"]').attr('content');
  
    $.ajax({
      url: usePath + "information_list/ajax_process",
      type: "POST",
      // headers: {
      //   'X-CSRF-Token': csrfToken // Include CSRF token if required
      // },
      data: {
        FIS_id,
        FIS_Assign_User,
        FIS_Assign_Date,
        FIS_Assign_Time,
        FIS_Assign_Remarks,
        identity: "FISASSIGN"
      },
      success: function (resp) {
        if (resp.status) {
          showToast("success", resp.message);
          // Optionally close the modal or refresh the table
          const modal = bootstrap.Modal.getInstance(document.getElementById('assignModal'));
          modal.hide();
           //location.reload(); // Uncomment if needed to refresh the page
           window.location.href = window.location.origin + window.location.pathname;
        } else {
          showToast("error", resp.message);
        }
      },
      error: function (xhr, status, error) {
        console.error('AJAX Error:', status, error);
        showToast("error", "An error occurred while processing the request.");
      },
      cache: false
    });
  }
  
  function save_followup_details() {
    var usePath = $.trim($("#rootXPath").val());
    const FLLW_fis_id = $("#FLLW_fis_id").val();
    const FLLW_By_User = document.getElementById('FLLW_By_User').value || '';
    const FLLW_Date = document.getElementById('FLLW_Date').value || '';
    const FLLW_time = document.getElementById('FLLW_time').value || '';
    const FLLW_Next_Date = document.getElementById('FLLW_Next_Date').value || '';
    const FLLW_Next_Time = document.getElementById('FLLW_Next_Time').value || '';
    const FLLW_Next_Remarks = document.getElementById('FLLW_Next_Remarks').value || '';
    const FLLW_Status = document.getElementById('FLLW_Status').value || '';
    const FLLW_FIS_Status = document.getElementById('FLLW_FIS_Status').value || '';
    const FLLW_type = document.getElementById('FLLW_type').value || '';
  
  
    // Validation
    if (!FLLW_By_User) {
      alert('Please select a user.');
      return;
    }
  
  if (FLLW_FIS_Status.toLowerCase() !== 'dead' && FLLW_FIS_Status.toLowerCase() !== 'waste') {
    if (!FLLW_Next_Date) {
      alert('Please select the next follow-up date.');
      return;
    }

    if (!FLLW_Next_Time) {
      alert('Please select the next follow-up time.');
      return;
    }
  }
  
    // CSRF Token (if needed)
    //const csrfToken = $('meta[name="csrf-token"]').attr('content');
  
    $.ajax({
      url: usePath + "lead_department/ajax_process",
      type: "POST",
      // headers: {
      //   'X-CSRF-Token': csrfToken // Include CSRF token if required
      // },
      data: {
        FLLW_fis_id,
        FLLW_By_User,
        FLLW_Date,
        FLLW_time,
        FLLW_Next_Date,
        FLLW_Next_Time,
        FLLW_Next_Remarks,
        FLLW_Status,
        FLLW_FIS_Status,
        FLLW_type,
        identity: "FOLLOWUP"
      },
      success: function (resp) {
        if (resp.status) {
          showToast("success", resp.message);
          // Close the modal
          const modal = bootstrap.Modal.getInstance(document.getElementById('followUpModal'));
          modal.hide();
          //location.reload(); 
        window.location.reload();
  
        } else {
          showToast("error", resp.message);
        }
      },
      error: function (xhr, status, error) {
        console.error('AJAX Error:', status, error);
        showToast("error", "An error occurred while processing the request.");
      },
      cache: false
    });
  }
  
  
  function view_fis_details(id) {
    var usePath = $.trim($("#rootXPath").val());
  
    // Set hidden field value
    $("#view_fis_id").val(id);
  
    $.ajax({
        url: `${usePath}lead_department/ajax_process`,
        type: "POST",
        data: {
            fis_id: id,
            identity: "VIEWFIS"
        },
        success: function (resp) {
            if (resp.status) {
                // Update modal content and show modal
                $("#viewDetailsModal .modal-body").html(resp.data);
                $("#viewDetailsModal").modal("show");
  
                // Optional: Display success notification
                // showToast("success", resp.message);
            } else {
                // Show error message
                showToast("error", resp.message);
            }
        },
        error: function () {
            // Show generic error message
            showToast("error", "An error occurred while processing the request.");
        },
        cache: false
    });
  }
  
  function saveTransferAssignee() {
    const usePath = $.trim($("#rootXPath").val());
    const transfer_fis_id = $("#transfr_fis_id").val();
    const current_assignee_id = document.getElementById('current_assigne_id').value || '';
    const new_assignee = document.getElementById('new_assignee').value || '';
    const transfer_date = document.getElementById('transfer_date').value || '';
    const transfer_time = document.getElementById('transfer_time').value || '';
    const remarks = document.getElementById('remarks').value || '';
    const assignee_type = document.getElementById('assignee_type').value || '';
  
    // Validation
    if (!new_assignee) {
      showToast("error", 'Please select a user to assign.');
      return;
    }
    if (current_assignee_id === new_assignee) {
      showToast("error", 'Please select a different user to assign.');
      return;
    }
    if (!transfer_date) {
      showToast("error", 'Transfer date is required.');
      return;
    }
    if (!transfer_time) {
      showToast("error", 'Transfer time is required.');
      return;
    }
  
    // Perform AJAX request
    $.ajax({
      url: usePath + "lead_department/ajax_process",
      type: "POST",
      data: {
        transfer_fis_id,
        current_assignee_id,
        new_assignee,
        transfer_date,
        transfer_time,
        remarks,
        assignee_type,
        identity: "TRANSFER"
      },
      success: function (resp) {
        if (resp.status) {
          showToast("success", resp.message);
  
          // Optionally close the modal
          const modal = bootstrap.Modal.getInstance(document.getElementById('transferModal'));
          if (modal) modal.hide();
  
          // Reload the page or refresh data
        window.location.reload();
        } else {
          showToast("error", resp.message);
        }
      },
      error: function (xhr, status, error) {
        console.error('AJAX Error:', status, error);
        showToast("error", "An error occurred while processing the request.");
      },
      cache: false
    });
  }
  
  function cancelFollowUp(followupId, date, time, remarks) {
    var usePath = $.trim($("#rootXPath").val());
    
    if (!usePath) {
      showToast("error", "Invalid base path. Please contact the administrator.");
      return;
    }
  
    // Confirmation Alert
    const message = `Are you sure you want to cancel this follow-up?\n\nDate: ${date}\nTime: ${time}\nRemarks: ${remarks}`;
    if (confirm(message)) {
      // AJAX Request to Update Follow-Up Status
      $.ajax({
        url: usePath + "lead_department/ajax_process",
        type: 'POST',
        data: {
          followup_id: followupId,
          status: 'C',
          identity: "CANCEL"
  
        },
        // headers: {
        //   'X-CSRF-Token': $('meta[name="csrf-token"]').attr('content') // Include CSRF token for security
        // },
        success: function(response) {
          if (response.status) {
            showToast("success", 'Follow-up record successfully canceled.');
           // location.reload(); // Reload page to reflect changes
           window.location.href = window.location.origin + window.location.pathname;
  
          } else {
            showToast("error", `Error: ${response.message}`);
          }
        },
        error: function(xhr, status, error) {
          console.error('AJAX Error:', {
            status: status,
            error: error,
            response: xhr.responseText
          });
          showToast("error", 'An error occurred while canceling the follow-up.');
        }
      });
    }
  }

  function save_item_list() {
    var usePath              = $.trim( $("#rootXPath").val() );
    var formData             = new FormData();
    var other_data           = $('form#myforms').serializeArray();
    var mid                  = $.trim( $("#itemId").val() );
    var menu_description      = $.trim( $("#menu_description").val() );
    var menu_type    = $.trim( $("#menu_type").val() );
    var mld_group      = $.trim( $("#mld_group").val() );
    var mld_title      = $.trim( $("#mld_title").val() );
    var mld_item      = $.trim( $("#mld_item").val() );
    var mld_type      = $.trim( $("#mld_type").val() );
    var menu_id                = $.trim( $("#mid").val() );

    if( menu_type == ''){
      showToast("error","Type is required.");
      setTimeout(function(){ set_global_focus('menu_type');},500);
      return false;
    }else if( menu_description == ''){
      showToast("error","Description is required.");
      setTimeout(function(){ set_global_focus('menu_description');},500);
      return false;
    }
    else if( mld_group == ''){
      showToast("error","Group is required.");
      setTimeout(function(){ set_global_focus('mld_group');},500);
      return false;
    }
    formData.append("identity", "ADDITEM");
    formData.append("itemId", mid);
    formData.append("mid", menu_id);

    $.each(other_data,function(key,input){
      formData.append(input.name,input.value);
    });
    $(".no_loader").removeClass("hidden").addClass("hidden");
    $(".loader").removeClass("hidden");     
    setTimeout(function(){
      $.ajax({
             url: usePath+"menu_list/ajax_process",
             type: 'POST',
             data: formData,
             async: false,
             contentType: false,
             processData: false,
             success: function (resp) {               
                if( resp.status ){         
  
                  // $("#item_grid").html(resp.data);
                  $(".no_loader").removeClass("hidden");
                  $(".loader").removeClass("hidden").addClass("hidden"); 
                  showToast("success",resp.message); 
                  window.location = usePath+"menu_list/add_menu/"+menu_id;
                  setTimeout(function(){ reset_menu_grid_afteradd();},500);         
                         
  
                }else{
                    $(".no_loader").removeClass("hidden");
                    $(".loader").removeClass("hidden").addClass("hidden");     
                    $(".process_qualif_save").show();
                    showToast("error",resp.message); 
                  
                }
             },
             error: function () {
              $(".no_loader").removeClass("hidden");
              $(".loader").removeClass("hidden").addClass("hidden");     
             },
             cache: false
     });
  
    },500);
  
  }

  
  function set_global_focus(id){

    $("#"+id).focus();

}

function get_selected_group_titles(){
  var usePath = $.trim($("#rootXPath").val());
  var mld_group = $.trim($("#mid_group").val()).split(",");

  $.ajax({
    url: usePath + "lead_department/ajax_process",
    type: 'POST',
    data: {'mld_group[]': mld_group, 'identity': 'GETITLES'},
    async: false,
    success: function (resp) {
      var sdata = resp.data;
      var html = '';

      if(sdata.length > 0){
        $.each(sdata, function(index, item){
          html += '<li style="display:flex;">' +
                    '<div style="width: 100%;">' +
                      '<span class="float-left">' + item.tc_title_counter + '</span>' +
                      '<span class="float-right">' +
                        '<input type="checkbox" onclick="get_selected_item_val2();" name="post_type_select2[]" id="' + item.id + '" value="' + item.id + '" style="width: 20px;height: 18px;" />' +
                      '</span>' +
                    '</div>' +
                  '</li>';
        });
      } else {
        html = '<li><div>No titles available</div></li>';
      }

      // Add Close button again at the end
      html += '<li class="mt5 mr5" style="display: flex;">' +
                '<div style="width: 100%;">' +
                  '<span class="float-left"></span>' +
                  '<span class="float-right" onclick="close_profile_checkbox2();">' +
                    '<button type="button" title="Close" class="btn-close" aria-label="Close"></button>' +
                  '</span>' +
                '</div>' +
              '</li>';

          $("#process_specification2").html(html); // Replace full UL content
        },
        error: function () {
          console.error("Error fetching titles");
        },
        cache: false
      });
    }


function get_selected_group_items() {
  var usePath   = $.trim($("#rootXPath").val());
  var mld_group = $.trim($("#mid_group").val()).split(",");
  var mld_title = $.trim($("#mid_title").val()).split(",");

  $.ajax({
    url: usePath + "lead_department/ajax_process",
    type: 'POST',
    data: { 'mld_group[]': mld_group, 'mld_title[]': mld_title, 'identity': 'GETITEMS' },
    async: false,
    success: function(resp) {
      var sdata = resp.data;
      var html = '<option value="">-Select-</option>';

      if(sdata.length > 0){
        $.each(sdata, function(index, item){
          html += '<li style="display:flex;">' +
                    '<div style="width: 100%;">' +
                      '<span class="float-left">' + item.mi_item + '</span>' +
                      '<span class="float-right">' +
                        '<input type="checkbox" onclick="get_selected_item_val3();" name="post_type_select3[]" id="' + item.id + '" value="' + item.id + '" style="width: 20px;height: 18px;" />' +
                      '</span>' +
                    '</div>' +
                  '</li>';
        });
      } else {
        html = '<li><div>No titles available</div></li>';
      }
      // Add Close button again at the end
      html += '<li class="mt5 mr5" style="display: flex;">' +
                '<div style="width: 100%;">' +
                  '<span class="float-left"></span>' +
                  '<span class="float-right" onclick="close_profile_checkbox3();">' +
                    '<button type="button" title="Close" class="btn-close" aria-label="Close"></button>' +
                  '</span>' +
                '</div>' +
              '</li>';

          $("#process_specification3").html(html);
    },
    error: function() { console.log("Error fetching items"); },
    cache: false
  });
}

function get_selected_items_type() {
  var usePath   = $.trim($("#rootXPath").val());
  var mld_group = $.trim($("#mid_group").val()).split(",");
  var mld_title = $.trim($("#mid_title").val()).split(",");
  var mld_item = $.trim($("#mid_item").val()).split(",");

  $.ajax({
    url: usePath + "lead_department/ajax_process",
    type: 'POST',
    data: { 'mld_group[]': mld_group, 'mld_title[]': mld_title, 'mld_item[]': mld_item, 'identity': 'GETTYPE' },
    async: false,
    success: function(resp) {
      var sdata = resp.data;
      var inputValue = "";

      if (sdata.length > 0) {
        inputValue = sdata[0].mi_type; // Assuming first item is the default value
      }
      
      $("#mid_type").val(inputValue);
    },
    error: function() { console.log("Error fetching items"); },
    cache: false
  });
}

function reset_menu_grid_afteradd(){
  $("#mld_item_id").val('');
  $("#mld_type").val('');
  $("#mld_group").val('');
  $("#mld_title").val('')
  $("#mld_item").val('');
  $("#itemId").val('') ;
}

function modify_guest_list(id,group,title,type,item){
  $("#itemId").val(id);
  $("#mld_group").val(group);
  $("#mld_title").val(title);
  $("#mld_type").val(type);
  $("#mld_item").val(item);
  
}

function save_item_list() {
  var usePath              = $.trim( $("#rootXPath").val() );
  var formData             = new FormData();
  var other_data           = $('form#myforms').serializeArray();
  var mid                  = $.trim( $("#itemId").val() );
  var menu_description      = $.trim( $("#menu_description").val() );
  var menu_type    = $.trim( $("#menu_type").val() );
  var mid_group      = $.trim( $("#mid_group").val() );
  var mld_title      = $.trim( $("#mld_title").val() );
  var mld_item      = $.trim( $("#mld_item").val() );
  var mld_type      = $.trim( $("#mld_type").val() );
  var menu_id                = $.trim( $("#mid").val() );

 if( mid_group == ''){
    showToast("error","Group is required.");
    setTimeout(function(){ set_global_focus('mid_group');},500);
    return false;
  }
  formData.append("identity", "ADDITEM");
  formData.append("itemId", mid);
  formData.append("mid", menu_id);

  $.each(other_data,function(key,input){
    formData.append(input.name,input.value);
  });
  $(".no_loader").removeClass("hidden").addClass("hidden");
  $(".loader").removeClass("hidden");     
  setTimeout(function(){
    $.ajax({
           url: usePath+"menu_list/ajax_process",
           type: 'POST',
           data: formData,
           async: false,
           contentType: false,
           processData: false,
           success: function (resp) {               
              if( resp.status ){         

                $("#item_grid").html(resp.data);
                $(".no_loader").removeClass("hidden");
                $(".loader").removeClass("hidden").addClass("hidden"); 
                showToast("success",resp.message); 
                // window.location = usePath+"menu_list/add_menu/"+menu_id;
                setTimeout(function(){ reset_menu_grid_afteradd();},500);         
                       

              }else{
                  $(".no_loader").removeClass("hidden");
                  $(".loader").removeClass("hidden").addClass("hidden");     
                  $(".process_qualif_save").show();
                  showToast("error",resp.message); 
                
              }
           },
           error: function () {
            $(".no_loader").removeClass("hidden");
            $(".loader").removeClass("hidden").addClass("hidden");     
           },
           cache: false
   });

  },500);

}

function get_items_details(id, entry_num,ck) {
  var usePath = $.trim($("#rootXPath").val());
  currentPrepidIndex = ck; // store globally

  // Set hidden field values
  $("#ch_entry_no").val(entry_num);
  $("#mid_cater_dtl_id").val(id);

  // Get values from hidden fields
  const mid_cater_dtl_id = $("#mid_cater_dtl_id").val();
  const mid_cater_entry_num = $("#ch_entry_no").val();

  $.ajax({
    url: usePath + "lead_department/ajax_process",
    type: "POST",
    data: { 
      mid_cater_dtl_id: mid_cater_dtl_id, 
      mid_cater_entry_num: mid_cater_entry_num, 
      identity: "SELECTITEMLIST" 
    },
    async: false,
    success: function (resp) {
      if (resp.status) {
        // Populate the table with response data
        $("#item_grid").html(resp.data);
        //showToast("success", resp.message);
      } else {
        showToast("error", resp.message);
      }
    },
    error: function () {
      showToast("error", "An error occurred while processing the request.");
    },
    cache: false
  });
}

function delete_menu_item(menuitemid) {
  const usePath = $("#rootXPath").val();
  var mid_cater_entry_num = $.trim($("#mid_cater_entry_num").val());
  var mid_cater_dtl_id = $.trim($("#mid_cater_dtl_id").val());

  if (confirm("Are you sure you want to delete this record ?")) {
      $.ajax({
          url: `${usePath}lead_department/ajax_process`,
          type: 'POST',
          data: {
            menuitemid: menuitemid,
              mid_cater_entry_num: mid_cater_entry_num,
              mid_cater_dtl_id: mid_cater_dtl_id,
              identity: 'DELETEMENUITM'
          },
          success: function (resp) {
              if (resp.status) {
                  // Update the UI with new data
                  $("#item_grid").html(resp.data);

                  // $("#func_info_list").html(resp.fisdtl);

                  // Show success toast
                  showToast("success", resp.message);
              } else {
                  // Handle failure response
                  $(".no_loader").addClass("hidden");
                  $(".loader").addClass("hidden");
                  $(".process_qualif_save").show();

                  // Show error toast
                  showToast("error", resp.message);
              }
          },
          error: function () {
              // Handle request failure
              $(".unprocess_loader").removeClass("hidden");
              $(".process_loader").addClass("hidden");

              showToast("error", "An error occurred while processing your request.");
          },
          cache: false
      });
  }
}

function followup_lead_status(){
  var usePath = $.trim($("#rootXPath").val());
  var lead_status = $.trim($("#FLLW_FIS_Status").val());

  $.ajax({
    url: `${usePath}information_list/ajax_process`,
    type: 'POST',
    data: {
      lead_status: lead_status,
      identity: "FLLWUPSTATUS"
    },
    success: function (resp) {
      var sdata = resp.data;
      var mhtml = '<option value="">--Select--</option>';
      if (sdata.length > 0) {
        $.each(sdata, function (key, leds) {
          mhtml += '<option value="' + leds.followup_status + '">' + leds.followup_status + '</option>';
        });
      } else {
        mhtml += '<option value="">No available</option>';
      }
      $("#FLLW_Status").html(mhtml);
    },
    error: function () {
      showToast("error", "Failed to fetch venue locations. Please try again.");
    },
    cache: false
  });
}

function save_menu_items_to_list() {
  var usePath = $.trim($("#rootXPath").val());
  var prepid = $.trim($("#prepid").val());
  var mid_cater_entry_num = $.trim($("#ch_entry_no").val());
  var mid_cater_dtl_id = $.trim($("#chd_function"+currentPrepidIndex).val());
  var mid_group = $.trim($("#mid_group").val()).split(",");
  var mid_title = $.trim($("#mid_title").val()).split(",");
  var mid_item = $.trim($("#mid_item").val()).split(",");
  // var ado_amount = $.trim($("#ado_amount").val());
  var mid_footer_id = $.trim($("#mid_footer_id").val());
  // var addtype = $.trim($("#addtype").val());
  var chd_menu = $.trim($("#chd_menu").val());
    $.ajax({
      url: usePath+"lead_department/ajax_process",
      type: 'POST',
      data: { 'mid_cater_entry_num': mid_cater_entry_num, 'mid_cater_dtl_id': mid_cater_dtl_id,'mid_group[]': mid_group, 'mid_title[]': mid_title,'mid_item[]': mid_item, 'chd_menu':chd_menu,'mid_footer_id':mid_footer_id,'identity': 'ADDMENUITEM' },
      async: false,
      success: function (resp) {
        if( resp.status ){         

          $("#item_grid").html(resp.data);
          $("#mid_footer_id").html(resp.footerid);
        
          // $("#func_info_list").html(resp.fisdtl);
          showToast("success",resp.message); 
          // refreshTotalAmount();

          setTimeout(function(){ reset_menu_items_details();},500);         

        }else{

            $(".process_qualif_save").show();

            showToast("error",resp.message); 

        }
       
      },
      error: function () {
        $(".unprocess_loader").addClass("hidden");
        $(".process_loader").removeClass("hidden");
      },
      cache: false
    });
 
}

function handleChargeTypeChange() {
  var type = $("#chd_type").val();
  var rateInput = $("#chd_rate");
  var valueInput = $("#chd_value");
  var pax = parseFloat($("#chd_pax").val()) || 0;
  var rate = parseFloat(rateInput.val()) || 0;

  if (type === "Lumpsum") {
    rateInput.val(0).prop("readonly", true);
    valueInput.prop("readonly", false);
  } else if (type === "Per Person") {
    rateInput.prop("readonly", false);
    valueInput.prop("readonly", true);
    valueInput.val(pax * rate);
  } else {
    rateInput.prop("readonly", false);
    valueInput.prop("readonly", false);
  }
}

$(document).ready(function () {
  // Initial setup if any default value is selected
  handleChargeTypeChange();

  // Bind type selector change
  $("#chd_type").change(function () {
    handleChargeTypeChange();
  });

  // Recalculate value on input if type is Per Person
  $("#chd_pax, #chd_rate").on("input", function () {
    if ($("#chd_type").val() === "Per Person") {
      var pax = parseFloat($("#chd_pax").val()) || 0;
      var rate = parseFloat($("#chd_rate").val()) || 0;
      $("#chd_value").val(pax * rate);
    }
  });
});

function fetch_status_list(type) {
  var usePath = $.trim($("#rootXPath").val());
  var formData = new FormData();

  var function_from_date = $.trim($("#function_from_date").val());
  var function_upto_date = $.trim($("#function_upto_date").val());
  var statustype = type;
  var department_search = $.trim($("#department_search").val());
  var source_search = $.trim($("#source_search").val());

  formData.append("identity", "STATUSSEARCH");
  formData.append("statustype", statustype);
  formData.append("function_from_date", function_from_date);
  formData.append("function_upto_date", function_upto_date);
  formData.append("department_search", department_search);
  formData.append("source_search", source_search);

  $(".no_loader").addClass("hidden");
  $(".show_loader").removeClass("hidden");

  $.ajax({
    url: usePath + "lead_department/ajax_process",
    type: 'POST',
    data: formData,
    async: false,
    contentType: false,
    processData: false,
    success: function (resp) {
      var ntml = '<tr><td colspan="4">No record(s) found.</td></tr>';
      if (resp.status) {
        $("#status_filter_list").html(resp.data);
      } else {
        $("#status_filter_list").html(ntml);
      }
      $(".show_loader").addClass("hidden");
      $(".no_loader").removeClass("hidden");
    },
    error: function () {
      $(".show_loader").addClass("hidden");
      $(".no_loader").removeClass("hidden");
    },
    cache: false
  });
}

function changeMenuList(){  
  var mid_group = $("#mid_group").val();
  var mid_title = $("#mid_title").val();
  var mid_item=$("#mid_item").val();
  // var fee_sem=$("#fee_sem").val();
  setTimeout(function(){ show_list(mid_group,mid_title,mid_item);},500);
}

function show_list(mid_group,mid_title,mid_item) {
  var usePath = $("#rootXPath").val();
  var formData = new FormData();
  var mid_group      = $.trim( $("#mid_group").val() );
  var mid_title      = $.trim( $("#mid_title").val() );
  var mid_item      = $.trim( $("#mid_item").val() );
  var mid_cater_entry_num = $.trim($("#ch_entry_no").val());
  var mid_cater_dtl_id = $.trim($("#chd_function"+currentPrepidIndex).val());

  formData.append("identity", "MENULISTSEARCH");
  formData.append("mid_group", mid_group);
  formData.append("mid_title", mid_title);
  formData.append("mid_item", mid_item);
  formData.append("mid_cater_entry_num", mid_cater_entry_num);
  formData.append("mid_cater_dtl_id", mid_cater_dtl_id);


  $.ajax({
    url: usePath + "lead_department/ajax_process",
    type: 'POST',
    data: formData,
    processData: false,
    contentType: false,
    success: function(resp) {
      if (resp.status) {
        //clear_fee_fields();
        $("#item_grid").html(resp.data);
      } else {
        //showToaster( resp.message);
        $("#item_grid").html('<tr><td colspan="4">No record(s) found.</td></tr>');
      }
    },
    error: function(xhr, status, error) {
      showToast('error', "An error occurred :" + error);
    }
  });

}

  $(document).on("click","#mid_title_display",function(){
    $("#sidebar-menu-toggle2").toggle();
  });
  
  function close_profile_checkbox2(){
    $("#sidebar-menu-toggle2").hide();
    }
    
    $(document).on('click', function (e) {
        // Check if the click is outside the input box or sidebar menu
        if (!$(e.target).closest('#mid_title_display, #sidebar-menu-toggle2').length) {
            $("#sidebar-menu-toggle2").hide();
        }
    });
  
function get_selected_item_val2(){
  var selectedValues = [];
  var postype = [];
  var displayNames = [];

  if( $("input[name='post_type_select2[]']").is(":checked") ){
    $("input[name='post_type_select2[]']:checked").each(function(){
      postype.push($(this).attr("id"));
      selectedValues.push($(this).val());

      var groupName = $(this).closest('li').find('span.float-left').text().trim();
      displayNames.push(groupName);
    });
  }

  if( selectedValues.length > 0 ){
    $("#mid_title").val(postype.join(","));
    $("#mid_title_display").val(displayNames.join(", "));
  }else{
    $("#mid_title").val('');
    $("#mid_title_display").val('');
  }

    get_selected_group_items();
  changeMenuList();
}

  $(document).on("click","#mid_group_display",function(){
    $("#sidebar-menu-toggle").toggle();
  });
  
  function close_profile_checkbox(){
    $("#sidebar-menu-toggle").hide();
    }
    
    $(document).on('click', function (e) {
        // Check if the click is outside the input box or sidebar menu
        if (!$(e.target).closest('#mid_group_display, #sidebar-menu-toggle').length) {
            $("#sidebar-menu-toggle").hide();
        }
    });
  
function get_selected_item_val(){
  var selectedValues = [];
  var postype = [];
  var displayNames = [];

  if( $("input[name='post_type_select[]']").is(":checked") ){
    $("input[name='post_type_select[]']:checked").each(function(){
      postype.push($(this).attr("id"));
      selectedValues.push($(this).val());

      var groupName = $(this).closest('li').find('span.float-left').text().trim();
      displayNames.push(groupName);
    });
  }

  if( selectedValues.length > 0 ){
    $("#mid_group").val(postype.join(","));
    $("#mid_group_display").val(displayNames.join(", "));
  }else{
    $("#mid_group").val('');
    $("#mid_group_display").val('');
  }

    get_selected_group_titles();
  changeMenuList();
}


  $(document).on("click","#mid_item_display",function(){
    $("#sidebar-menu-toggle3").toggle();
  });
  
  function close_profile_checkbox3(){
    $("#sidebar-menu-toggle3").hide();
    }
    
    $(document).on('click', function (e) {
        // Check if the click is outside the input box or sidebar menu
        if (!$(e.target).closest('#mid_item_display, #sidebar-menu-toggle3').length) {
            $("#sidebar-menu-toggle3").hide();
        }
    });
  
function get_selected_item_val3(){
  var selectedValues = [];
  var postype = [];
  var displayNames = [];

  if( $("input[name='post_type_select3[]']").is(":checked") ){
    $("input[name='post_type_select3[]']:checked").each(function(){
      postype.push($(this).attr("id"));
      selectedValues.push($(this).val());

      var groupName = $(this).closest('li').find('span.float-left').text().trim();
      displayNames.push(groupName);
    });
  }

  if( selectedValues.length > 0 ){
    $("#mid_item").val(postype.join(","));
    $("#mid_item_display").val(displayNames.join(", "));
  }else{
    $("#mid_item").val('');
    $("#mid_item_display").val('');
  }

  get_selected_items_type();
    // changeMenuList();

}

function reset_menu_items_details(){
  $("#mid_group").val('');
  $("#mid_title").val('');
  $("#mid_item").val('');
  $("#mid_group_display").val('')
  $("#mid_title_display").val('');
  $("#mid_item_display").val('') ;
  $("#mid_footer_id").val('');
  $("#mid_cater_entry_num").val('')
  $("#mid_cater_dtl_id").val('');
    $("input[name='post_type_select[]']").prop("checked", false);

  // Uncheck all checkboxes in the title section
  $("input[name='post_type_select2[]']").prop("checked", false);

  // Uncheck all checkboxes in the item section
  $("input[name='post_type_select3[]']").prop("checked", false);
    get_selected_group_titles();
  get_selected_group_items();
  get_selected_items_type();
}

  function search_additional_remarks() {
    var usePath = $.trim($("#rootXPath").val());
    var ch_addtional_remrks = $.trim($("#ch_addtional_remrks").val());

  if (ch_addtional_remrks !== '') {
        $(".load_employee").removeClass("hidden");

        setTimeout(function () {
            $.ajax({
                url: usePath + "lead_department/ajax_process",
                type: 'POST',
                data: {
                    'requestcode': '',
                    'additional_remarks_ch': ch_addtional_remrks,
                    'requesttype': 'CODE',
                    'identity': 'ADDREMARKSEARCH'
                },
                async: false,
                success: function (resp) {
                    $(".load_employee").addClass("hidden");
                    var nhtml = '';

                    if (resp.status) {
                        nhtml += '<select id="new_remarks_select" onchange="selected_my_remarks_list(this.value);"><option value="">-Select-</option>';
                        var sdata = resp.data;

                        if (sdata.length > 0) {
                            $.each(sdata, function (key, leds) {
                                nhtml += `<option value="${leds.ch_addtional_remrks}">${leds.ch_addtional_remrks}</option>`;
                            });
                        }

                        nhtml += '</select>';
                    }

                    $("#additional_remarks_ch").html(nhtml);
                },
                error: function () {
                    $(".load_employee").addClass("hidden");
                },
                cache: false
            });
        }, 500);
    }
}

function selected_my_remarks_list(val){            
    var nstr         = val.split(",");
    for(var i = 0; i < nstr.length; i++) {
       nstr[i] = nstr[i].replace(/'/g, "");
    }   
     if( nstr[0] =='null' ){
         nstr[0] = '';
     }
     if( nstr[1] =='null' ){
         nstr[1] = '';
     }
     $("#ch_addtional_remrks").val(nstr[0]);
     $("#additional_remarks_ch").html('');
}


  function view_original_contract(departmnet,contractno){
    var usePath = $("#rootXPath").val();

    $.ajax({
             url: usePath+"lead_department/ajax_process",
             type: 'POST',
             data: {'identity':'VIEWCONTRACT','departmnet':departmnet,'contractno':contractno},
             async: false,            
             success: function (resp) {
                var sid = resp.data;
                
                if (departmnet == "Venue"){
                    window.open( usePath + 'contract_venue_list/create_venue_contract/'+sid+'?department='+
            encodeURIComponent(departmnet) +
            '&contractno=' + encodeURIComponent(contractno),'_blank')             
           }else if(departmnet == "Entertainment"){
                    window.open( usePath + 'contract_entertainment_list/create_entertainment_contract/'+sid+'?department='+
            encodeURIComponent(departmnet) +
            '&contractno=' + encodeURIComponent(contractno),'_blank')             
           }else if(departmnet == "decor"){
                    window.open( usePath + 'contract_list/create_contract/'+sid+'?department='+
            encodeURIComponent(departmnet) +
            '&contractno=' + encodeURIComponent(contractno),'_blank')             
           }
             },
             error: function (textStatus, errorThrown) {
                 alert("Facing technical issue!");
             },
             cache: false
 
         });
  }


  
  function open_forward_lead_modal(leadno){
          $('#contractno').val(leadno); 
          $('#display_contractno').text(leadno); 
}



function forward_to_departments() {
    var usePath = $.trim($("#rootXPath").val());
    var contractno = $.trim($("#contractno").val());
    var departmnet = $.trim($("#forward_to").val());
    var userid = $.trim($("#forward_to_user").val());

if (!departmnet ) {
   showToast("info","Select Department you want to forward this contract to ");
   $("#forward_to").focus();
   return false;
  }

    // Show the loader
    $(".process_loader_table").show();

    $.ajax({
        url: usePath + "lead_department/ajax_process",
        type: 'POST',
        data: { 'identity': 'FORWARD', 'contractno':contractno , 'departmnet' : departmnet, 'userid' : userid},
        success: function (resp) {
          if (resp.status) {
            showToast("success", resp.message);
          if (departmnet.toLowerCase() === "decor") {
            alert("Contract forwarded to Decor Department!");
          } else if (departmnet.toLowerCase() === "entertainment") {
            alert("Contract forwarded to Entertainment Department!");
          }  else if (departmnet.toLowerCase() === "venue") {
            alert("Contract forwarded to Venue Department!");
          }             
            const modal = bootstrap.Modal.getInstance(document.getElementById('forwardToDeptModal'));
            modal.hide();
            //location.reload(); 
            window.location.reload();

          } else {
            alert(resp.message);
            showToast("error", resp.message);
          }
        },
        error: function () {
            alert("An error occurred while processing the request.");
        },
        complete: function () {
            // Hide the loader when done
            $(".process_loader_table").hide();
        },
        cache: false
    });
}


  function get_department_users() {
    var usePath = $.trim($("#rootXPath").val());
    var departmnet = $.trim($("#forward_to").val());

  if (departmnet !== '') {
        $(".show_loader").removeClass("hidden");
        $(".no_loader").removeClass("hidden").addClass("hidden");
        setTimeout(function () {
            $.ajax({
                url: usePath + "contract_catering_list/ajax_process",
                type: 'POST',
                data: {
                    'departmnet': departmnet,
                    'requesttype': 'CODE',
                    'identity': 'GETDEPTUSERS'
                },
                async: false,
                success: function (resp) {
                    $(".show_loader").removeClass("hidden").addClass("hidden");
                    $(".no_loader").removeClass("hidden");
                    var nhtml = '';

                    if (resp.status) {
                        nhtml += '<select class="form-select"><option value="">-Select-</option>';

                        var sdata = resp.data;

                        if (sdata.length > 0) {
                            $.each(sdata, function (key, leds) {
                                nhtml += `<option value="${leds.id}">${leds.username}</option>`;
                            });
                        }

                        nhtml += '</select>';
                    }

                    $("#forward_to_user").html(nhtml);
                },
                error: function () {
                    $(".show_loader").removeClass("hidden").addClass("hidden");
                    $(".no_loader").removeClass("hidden");
                },
                cache: false
            });
        }, 500);
    }
}
