function set_global_focus(id){

  $("#"+id).focus();

}

function updateDateLabels() {
    let type = $("#search_date_type").val();

    if (type === "CD") {
        $("label[for='from_date']").text("Created From");
        $("label[for='upto_date']").text("Created Upto");

    } else {
        $("label[for='from_date']").text("Function From");
        $("label[for='upto_date']").text("Function Upto");

    }
}

// Run once after page refresh
$(document).ready(function() {
    updateDateLabels();
});

// Run again when select changes
$(document).on("change", "#search_date_type", function () {
    updateDateLabels();
});


function saveDecorDetail() {
    var usePath = $.trim($("#rootXPath").val());
    var formData = new FormData();
    var mid = $.trim($("#mid").val());
    var dh_guest_name = $.trim($("#dh_guest_name").val());
    var dh_contact_no = $.trim($("#dh_contact_no").val());
    var dh_address = $.trim($("#dh_address").val());
    var dh_state = $.trim($("#dh_state").val());
    var dh_email = $.trim($("#dh_email").val());
    var dhd_entry_num = $.trim($("#dhd_entry_num").val());
    var dhd_function = $.trim($("#dhd_function").val());
    var dhd_date = $.trim($("#dhd_date").val());
    var dhd_lead_type = $.trim($("#dhd_lead_type").val());
    var dhd_time = $.trim($("#dhd_time").val());

    var dhd_venue1 = $.trim($("#dhd_venue1").val());
    var dhd_address1 = $.trim($("#dhd_address1").val());
    var dhd_venue2 = $.trim($("#dhd_venue2").val());
    var dhd_address2 = $.trim($("#dhd_address2").val());
    var dhd_min_guarante = $.trim($("#dhd_min_guarante").val());
    var dhd_session = $.trim($("#dhd_session").val());
    var dhd_lumpsum = $.trim($("#dhd_lumpsum").val());
    var dhd_priority = $.trim($("#dhd_priority").val());
    var dhd_remarks = $.trim($("#dhd_remarks").val());
    var trdLocation = $.trim($("#trd_location").val());
    var trq_mobile_no = $.trim($("#trq_mobile_no").val());
  
    let trndbrach = "";
  
    // Input Validation
    if (!dh_guest_name) {
      showToast("error","Guest Name is required");
      $("#dh_guest_name").focus();
      return false;
    }
  
    if (!dh_contact_no) {
      showToast("error","Contact No. is required");
      $("#dh_contact_no").focus();
      return false;
    }
  
    if (!dh_address) {
      showToast("error","Address is required");
      $("#dh_address").focus();
      return false;
    }
  
    // if (!dh_state) {
    //   showToast("error","State is required");
    //   $("#dh_state").focus();
    //   return false;
    // }
  
    // Validate Mobile Number (if provided)
    if (dh_contact_no && dh_contact_no.length < 10) {
      showToast("error","Mobile number should be at least 10 digits");
      $("#dh_contact_no").focus();
      return false;
    }

    if (dh_email!=''){
      if (!check_email_validation(dh_email, 'dh_email')) {
       setTimeout(function(){ set_global_focus('dh_email');},500);
       return false;
     }}

     if (!dhd_function) {
      showToast("error","Function is required");
      $("#dhd_function").focus();
      return false;
    }

    if (!dhd_date) {
      showToast("error","Date is required");
      $("#dhd_date").focus();
      return false;
    }

    if (!dhd_time) {
      showToast("error","Time is required");
      $("#dhd_time").focus();
      return false;
    }

    if (!dhd_lead_type) {
      showToast("error","Lead Type is required");
      $("#dhd_lead_type").focus();
      return false;
    }

  if (dhd_lead_type == 'I') {
    if (!dhd_venue1) {
      showToast("error", "Venue is required");
      $("#dhd_venue1").focus();
      return false;
    }
    if (!dhd_address1) {
      showToast("error", "Location is required");
      $("#dhd_address1").focus();
      return false;
    }
  }

  if (dhd_lead_type == 'O') {
    if (!dhd_venue2) {
      showToast("error", "Venue Name is required");
      $("#dhd_venue2").focus();
      return false;
    }
    if (!dhd_address2) {
      showToast("error", "Location Name is required");
      $("#dhd_address2").focus();
      return false;
    }
  }
  
    if (!dhd_lumpsum) {
      showToast("error","Lumpsum is required");
      $("#dhd_lumpsum").focus();
      return false;
    }

    if (!dhd_remarks) {
      showToast("error","Remarks is required");
      $("#dhd_remarks").focus();
      return false;
    }
    // Prepare Form Data
    formData.append("identity", "DECORDTL");
    var otherData = $('form#myforms').serializeArray();
    otherData.forEach((input) => {
      formData.append(input.name, input.value);
    });
    // formData.append("trd_otherloc", trndbrach);
    $(".no_loader").removeClass("hidden").addClass("hidden");
    $(".loader").removeClass("hidden");  
    // AJAX Request
    $.ajax({
      url: `${usePath}lead_decor_list/ajax_process`,
      type: "POST",
      data: formData,
      contentType: false,
      processData: false,
      success: function (resp) {
        if (resp.message) {
          $(".no_loader").removeClass("hidden");
          $(".loader").removeClass("hidden").addClass("hidden"); 
          showToast("success",resp.message);
          setTimeout(() => get_pick_a_lead_counts(), 1000);
          refreshTotalAmount();
          // window.location = usePath+"lead_decor_list/lead_decor/"+mid;
        }
  
        if (resp.headerid > 0) {
          $(".no_loader").removeClass("hidden");
          $(".loader").removeClass("hidden").addClass("hidden"); 
          $("#mid").val(resp.headerid);
          $("#prepid").val(resp.prepid); 
          $("#curmobile").val(resp.currmobileno);
          $("#attach_gp_button").removeAttr('hidden'); // Show the Attach GP button
        } else {
          $(".no_loader").removeClass("hidden");
          $(".loader").removeClass("hidden").addClass("hidden"); 
          $("#mid").val('');
          $("#curmobile").val('');
          $("#attach_gp_button").attr('hidden', true); // Hide the Attach GP button if no tour ID
        }
        
  
        if (resp.data) {
          $(".no_loader").removeClass("hidden");
          $(".loader").removeClass("hidden").addClass("hidden"); 
          $("#decordetailgrid").html(resp.data);
        }
  
        // Call create_blanks() only when resp.status is true
      if (resp.status === true) {
        setTimeout(() => create_blanks(), 500);
      }
      },
      error: function (xhr, status, error) {
        console.error("AJAX Error:", status, error);
        alert("An error occurred while processing the request.");
      },
      cache: false,
    });
  }

  function view_original_contract(departmnet, contractno){

  }

  function create_blanks() {
    $("#prepid").val('');
    $("#dhd_function").val('');
    $("#dhd_date").val('');
    $("#dhd_time").val('');
    $("#dhd_lead_type").val('');
    $("#dhd_min_guarante").val('');
    $("#dhd_session").val('');
    $("#dhd_lumpsum").val('');
    $("#dhd_priority").val('');
    $("#dhd_remarks").val('');
  
    // Clear dropdown & input values
    $("#dhd_venue1").val('');
    $("#dhd_address1").val('');
    $("#dhd_venue2").val('');
    $("#dhd_address2").val('');
  
    // Re-hide all optional blocks (Indoor/Outdoor sections)
    $("#venue_dropdown").addClass("hidden").find("select").val('');
    $("#address_dropdown").addClass("hidden").find("select").val('');
    $("#venue_input").addClass("hidden").find("input").val('');
    $("#address_input").addClass("hidden").find("input").val('');
  }
  
  
  function process_save_decor_header() {
    var usePath = $.trim($("#rootXPath").val());
    var formData = new FormData();
    var other_data = $('form#myforms').serializeArray();
  
    // Form field values
    var mid = $.trim($("#mid").val());
    var dh_entry_no = $.trim($("#dh_entry_no").val());
    var dh_guest_name = $.trim($("#dh_guest_name").val());
    var dh_contact_no = $.trim($("#dh_contact_no").val());
    var dh_func_from_date = $.trim($("#dh_func_from_date").val());
    var dh_func_upto_date = $.trim($("#dh_func_upto_date").val());
    var dh_state = $.trim($("#dh_state").val());
    var dh_address = $.trim($("#dh_address").val());
    var dh_city = $.trim($("#dh_city").val());
    var dh_pincode = $.trim($("#dh_pincode").val());
    var dh_email = $.trim($("#dh_email").val());
    var dh_enquiry_mode = $.trim($("#dh_enquiry_mode").val());
    var dh_proposal = $.trim($("#dh_proposal").val());
    var dh_total_tax = $.trim($("#dh_total_tax").val());
    var dh_total_amnt = $.trim($("#dh_total_amnt").val());

    // Validations
    if (!dh_guest_name) {
      showToast("error","Guest Name is required");
      $("#dh_guest_name").focus();
      return false;
    }
  
    if (!dh_contact_no) {
      showToast("error","Contact Number is required");
      $("#dh_contact_no").focus();
      return false;
    }

    if (!dh_address) {
      showToast("error","Address is required");
      $("#dh_address").focus();
      return false;
    }

    // if (!dh_state) {
    //   showToast("error","State is required");
    //   $("#dh_state").focus();
    //   return false;
    // }
  
    if (dh_contact_no) {
      if (dh_contact_no.length <= 9 || dh_contact_no.length > 10) {
        showToast("error","Mobile Number should be of 10 digits!");
          $("#dh_contact_no").focus();
          return false;
      }
    }
  
    if (dh_email!=''){
      if (!check_email_validation(dh_email, 'dh_email')) {
       setTimeout(function(){ set_global_focus('dh_email');},500);
       return false;
     }}
  
    // Append data to FormData
    formData.append("identity", "DECORSAVE");
    formData.append("mid", mid);
    other_data.forEach(input => formData.append(input.name, input.value));
  
    setTimeout(() => {
      $.ajax({
        url: usePath + "lead_decor_list/ajax_process",
        type: 'POST',
        data: formData,
        contentType: false,
        processData: false,
        success: function (resp) {
          if (resp.status) {
            $("#mid").val(resp.decorid);
          setTimeout(() => get_pick_a_lead_counts(), 1000);
          refreshTotalAmount();
            showToast("success",resp.message);
            // window.location.href = usePath + "lead_decor_list";
              let redirectPage = $.trim($("#page_redirect").val());
              let redirectURL = usePath + "lead_decor_list";
              if (redirectPage) {
                redirectURL += "?page=" + redirectPage;
              }
              window.location.href = redirectURL;
          } else {
            alert(resp.message);
          }
        },
        error: function () {
          alert("An error occurred while processing the request.");
        },
        cache: false,
      });
    }, 500);
  }
  
  function view_original_contract(departmnet,contractno){
    var usePath = $("#rootXPath").val();

    $.ajax({
             url: usePath+"lead_decor_list/ajax_process",
             type: 'POST',
             data: {'identity':'VIEWCONTRACT','departmnet':departmnet,'contractno':contractno},
             async: false,            
             success: function (resp) {
                var sid = resp.data;
                
                if (departmnet == "Venue"){
                    window.open( usePath + 'contract_venue_list/create_venue_contract/'+sid+'?department='+
            encodeURIComponent(departmnet) +
            '&contractno=' + encodeURIComponent(contractno),'_blank')             
           }else if(departmnet == "Entertainment"){
                    window.open( usePath + 'contract_entertainment_list/create_entertainment_contract/'+sid+'?department='+
            encodeURIComponent(departmnet) +
            '&contractno=' + encodeURIComponent(contractno),'_blank')             
           }else if(departmnet == "Catering"){
                    window.open( usePath + 'contract_catering_list/create_catering_contract/'+sid+'?department='+
            encodeURIComponent(departmnet) +
            '&contractno=' + encodeURIComponent(contractno),'_blank')             
           }
             },
             error: function (textStatus, errorThrown) {
                 alert("Facing technical issue!");
             },
             cache: false
 
         });
  }

      $("#decor_search").on("keypress", function(e) {
    if (e.which === 13) { // 13 = Enter key
        e.preventDefault();
        search_lead_decor_filter();
    }
});

  function fill_decor_list(guestInfoId){
    var usePath = $("#rootXPath").val();

    $.ajax({
             url: usePath+"lead_decor_list/ajax_process",
             type: 'POST',
             data: {'identity':'FILLGUESTINFO','guestInfoId':guestInfoId},
             async: false,            
             success: function (resp) {
              if (resp.status === 'success') {
                var data = resp.data;
                $("#dh_guestinfo_id").val(data.id || '');
                // Set form fields
                $("#dh_guest_name").val(data.name || '');
                $("#dh_contact_no").val(data.contact || '');
                $("#dhd_date").val(data.function_date || '');
                $("#dh_city").val(data.city || '');
                $("#dh_email").val(data.email || '');   // Not coming in response, left blank
                $("#dhd_remarks").val(data.remarks	 || '');   // Not coming in response, left blank
                $("#dh_enquiry_mode").val(data.source		 || '');   // Not coming in response, left blank
                $("#dh_enquiry_mode").val(data.source || '');      // Mode of Enquiry dropdown
                $("#dhd_function").val(data.function_type || '');  // Function dropdown
                
              } else {
                alert(resp.message || "Guest not found");
              }
              $("button[data-bs-dismiss='modal']").click();

             },
             error: function (textStatus, errorThrown) {
                 alert("Facing technical issue!");
             },
             cache: false
 
         });
   }
   var currentPrepidIndex = null;

   function fis_addon_list() {
    var usePath = $.trim($("#rootXPath").val());
    var prepid = $.trim($("#prepid").val());
    var ado_fis_enrty_no = $.trim($("#dh_entry_no").val());
    var ado_fis_dtl_id = $.trim($("#dhd_function"+currentPrepidIndex).val());
    var ado_addon = $.trim($("#ado_addon").val());
    var ado_type = $.trim($("#ado_type").val());
    var ado_rate = $.trim($("#ado_rate").val());
    var ado_amount = $.trim($("#ado_amount").val());
    var ado_footer_id = $.trim($("#ado_footer_id").val());
    var addtype = $.trim($("#addtype").val());
  
    if (ado_addon === '') {
      showToast("error","Select Addon from list");
      $("#ado_addon").focus();
      return false;
    } else if (ado_rate === '') {
      showToast("error","Quantity is required.");
      $("#ado_rate").focus();
      return false;
    }else if (ado_amount === '') {
      showToast("error","Addon Amount is required.");
      $("#ado_amount").focus();
      return false;
    }
  
  
   
      $.ajax({
        url: usePath+"lead_decor_list/ajax_process",
        type: 'POST',
        data: { 'enrty_no': ado_fis_enrty_no, 'fis_dtl_id': ado_fis_dtl_id,'ado_addon': ado_addon, 'ado_type': ado_type,'ado_rate': ado_rate, 'ado_amount': ado_amount, 'ado_footer_id':ado_footer_id,'addtype':addtype,'identity': 'ADDON' },
        async: false,
        success: function (resp) {
          if( resp.status ){         
  
            $("#addon_info_list").html(resp.data);
            $("#ado_footer_id").html(resp.footerid);
          
            $("#func_info_list").html(resp.fisdtl);
            showToast("success",resp.message); 
            refreshTotalAmount();
  
  
            setTimeout(function(){ reset_addons_details();},500);         
  
                   
  
  
  
          }else{
  

  
              $(".process_qualif_save").show();
  
              showToast("error",resp.message); 
  
            
  
          }
         
        },
        error: function () {
          $(".unprocess_loader").addClass("hidden");
          $(".process_loader").removeClass("hidden");
        },
        cache: false
      });
   
  }

  function reset_addons_details(){

    $("#ado_addon").val('');
  
    $("#ado_type").val('');
  
    $("#ado_rate").val('');
  
    $("#ado_amount").val('');
  
    $("#ado_footer_id").val('');
  
  }
  
  function edit_addon_list(id,addon,type,rate,amount){
  
    $("#ado_footer_id").val(id);
  
    $("#ado_addon").val(addon);
  
    $("#cur_ado_addon").val(addon);
  
    $("#ado_type").val(type);
  
    $("#ado_rate").val(rate);
  
    $("#ado_amount").val(amount);
    setTimeout(function(){ handleAdoTypeChange();},500);    
  
  }
  
  function delete_addon_record(addonId) {
    const usePath = $("#rootXPath").val();
    var ado_fis_enrty_no = $.trim($("#ado_fis_enrty_no").val());
    var ado_fis_dtl_id = $.trim($("#ado_fis_dtl_id").val());
  
    if (confirm("Are you sure you want to delete this record ?")) {
        $.ajax({
            url: `${usePath}lead_decor_list/ajax_process`,
            type: 'POST',
            data: {
                addonid: addonId,
                ado_fis_enrty_no: ado_fis_enrty_no,
                ado_fis_dtl_id: ado_fis_dtl_id,
                identity: 'DELETE'
            },
            success: function (resp) {
                if (resp.status) {
                    // Update the UI with new data
                    $("#addon_info_list").html(resp.data);
  
                    $("#func_info_list").html(resp.fisdtl);
  
                    // Show success toast
                    showToast("success", resp.message);
                } else {
                    // Handle failure response
                    $(".no_loader").addClass("hidden");
                    $(".loader").addClass("hidden");
                    $(".process_qualif_save").show();
  
                    // Show error toast
                    showToast("error", resp.message);
                }
            },
            error: function () {
                // Handle request failure
                $(".unprocess_loader").removeClass("hidden");
                $(".process_loader").addClass("hidden");
  
                showToast("error", "An error occurred while processing your request.");
            },
            cache: false
        });
    }
  }

  function handleAdoTypeChange() {
    const adoType = document.getElementById("ado_type").value;
    const adoRate = document.getElementById("ado_rate");
    const adoFunctionPax = document.getElementById("ado_function_pax");
    const adoAmount = document.getElementById("ado_amount");
  
    if (adoType === "lumpsum") {
      // For lumpsum, set the rate to 1, make it readonly, and clear amount
      adoRate.value = 1;
      adoRate.readOnly = true;
      if (!adoAmount.value) {
        adoAmount.value = "";
      }
      adoAmount.readOnly = false;
    } else if (adoType === "person") {
      // Make the amount field readonly and calculate amount
      adoRate.readOnly = false; // Allow editing the rate
      adoFunctionPax.addEventListener("input", updateAmount);
      adoRate.addEventListener("input", updateAmount);
      adoAmount.readOnly = true;
      updateAmount(); // Initial calculation
    } else {
      // Default case: Allow editing both rate and amount
      adoRate.readOnly = false;
      adoAmount.readOnly = false;
    }
  
    function updateAmount() {
      const pax = parseFloat(adoFunctionPax.value) || 0; // Default to 0 if empty
      const rate = parseFloat(adoRate.value) || 0;       // Default to 0 if empty
      adoAmount.value = (pax * rate);         // Calculate and set amount
    }
  }

  // USING FOR VIEW FIS SCREEN
function get_fis_details_view(id, fis_entry,fnctn_pax) {
  var usePath = $.trim($("#rootXPath").val());

  // Set hidden field values
  $("#dhd_function").val(id);
  $("#dh_entry_no").val(fis_entry);
  $("#ado_function_pax").val(fnctn_pax);

  // Get values from hidden fields
  const ado_fis_dtl_id = $("#dhd_function").val();
  const ado_fis_enrty_no = $("#dh_entry_no").val();

  $.ajax({
    url: usePath + "lead_decor_list/ajax_process",
    type: "POST",
    data: { 
      ado_fis_dtl_id: ado_fis_dtl_id, 
      ado_fis_enrty_no: ado_fis_enrty_no, 
      identity: "ADDONLISTVIEW" 
    },
    async: false,
    success: function (resp) {
      if (resp.status) {
        // Populate the table with response data
        $("#addon_info_list_fis").html(resp.data);
        //showToast("success", resp.message);
      } else {
        showToast("error", resp.message);
      }
    },
    error: function () {
      showToast("error", "An error occurred while processing the request.");
    },
    cache: false
  });
}
function get_fis_details(id, entry_num,ck) {
  var usePath = $.trim($("#rootXPath").val());
  currentPrepidIndex = ck; // store globally

  // Set hidden field values
  $("#dh_entry_no").val(entry_num);
  $("#ado_fis_dtl_id").val(id);

  // Get values from hidden fields
  const ado_fis_dtl_id = $("#ado_fis_dtl_id").val();
  const ado_fis_enrty_no = $("#dh_entry_no").val();

  $.ajax({
    url: usePath + "lead_decor_list/ajax_process",
    type: "POST",
    data: { 
      ado_fis_dtl_id: ado_fis_dtl_id, 
      ado_fis_enrty_no: ado_fis_enrty_no, 
      identity: "ADDONLIST" 
    },
    async: false,
    success: function (resp) {
      if (resp.status) {
        // Populate the table with response data
        $("#addon_info_list").html(resp.data);
        //showToast("success", resp.message);
      } else {
        showToast("error", resp.message);
      }
    },
    error: function () {
      showToast("error", "An error occurred while processing the request.");
    },
    cache: false
  });
}

$(document).ready(function(){
  flatpickr("#dh_func_from_date", {
   dateFormat: "d-M-Y",
   allowInput: true,
    onOpen: function (selectedDates, dateStr, instance) {
   instance.setDate(instance.input.value, false);
  },
 });
});

$(document).ready(function(){
  flatpickr("#dh_func_upto_date", {
   dateFormat: "d-M-Y",
   allowInput: true,
    onOpen: function (selectedDates, dateStr, instance) {
   instance.setDate(instance.input.value, false);
  },
 });
});

$(document).ready(function(){
  flatpickr("#dhd_date", {
   dateFormat: "d-M-Y",
   allowInput: true,
    onOpen: function (selectedDates, dateStr, instance) {
   instance.setDate(instance.input.value, false);
  },
 });
});

$(document).ready(function(){
  flatpickr("#dhd_date", {
   dateFormat: "d-M-Y",
   allowInput: true,
    onOpen: function (selectedDates, dateStr, instance) {
   instance.setDate(instance.input.value, false);
  },
 });
});

$(document).ready(function(){
  flatpickr("#from_date", {
   dateFormat: "d-M-Y",
   allowInput: true,
    onOpen: function (selectedDates, dateStr, instance) {
   instance.setDate(instance.input.value, false);
  },
 });
});

$(document).ready(function(){
  flatpickr("#upto_date", {
   dateFormat: "d-M-Y",
   allowInput: true,
    onOpen: function (selectedDates, dateStr, instance) {
   instance.setDate(instance.input.value, false);
  },
 });
});

function modify_function_list(id, functin, date, time, lead_type, venue1, address1, venue2, address2, min_gurantee, session, lumpsum, priority, remarks) {
  $("#prepid").val(id);
  $("#dhd_function").val(functin);
  $("#dhd_date").val(date);
  $("#dhd_time").val(time);
  $("#dhd_lead_type").val(lead_type);

  // Trigger lead type dropdown change to reveal/hide the correct inputs
  venue_leadtype();

  if (lead_type === "I") {
    $("#dhd_venue1").val(venue1);
    $("#dhd_address1").val(address1);
    getVenueLocationList();

  } else if (lead_type === "O") {
    $("#dhd_venue2").val(venue2);
    $("#dhd_address2").val(address2);
  }

  $("#dhd_min_guarante").val(min_gurantee);
  $("#dhd_session").val(session);
  $("#dhd_lumpsum").val(lumpsum);
  $("#dhd_priority").val(priority);
  $("#dhd_remarks").val(remarks);
}


function delete_decor_detail(id){
  var usePath      = $.trim( $("#rootXPath").val() );    

  if( confirm("Are you sure you want to delete?")){
      window.location = usePath+"lead_decor_list/lead_decor/"+id+"/deletedecordetail";
    }

}

function delete_decor(){
  var usePath      = $.trim( $("#rootXPath").val() );    

  if( confirm("Are you sure you want to delete?")){
      window.location = usePath+"lead_decor_list/"+id+"/destroy";
    }

}

$(document).on("keypress","#decor_search",function(e){
  var keycode = (e.keyCode ? e.keyCode : e.which );
    if( keycode == '13' ){
      search_lead_decor_filter();
    }

});
function search_lead_decor_filter(){
  var useroot = $("#rootXPath").val();
  $(".show_loader").removeClass("hidden");
  $(".no_loader").removeClass("hidden").addClass("hidden")
  $("form#myForms").attr("action",useroot+"lead_decor_list/search");
  $("form#myForms").submit();
}

function show_open_status_list() {
  $("#decor_status_search").val("open");
  search_lead_decor_filter();
}

function show_mild_status_list() {
  $("#decor_status_search").val("mild");
  search_lead_decor_filter();
}

function show_warm_status_list() {
  $("#decor_status_search").val("warm");
  search_lead_decor_filter();
}

function show_hot_status_list() {
  $("#decor_status_search").val("hot");
  search_lead_decor_filter();
}

function show_closed_status_list() {
  $("#decor_status_search").val("closed");
  search_lead_decor_filter();
}

function show_dead_status_list() {
  $("#decor_status_search").val("dead");
  search_lead_decor_filter();
}

function show_waste_status_list() {
  $("#decor_status_search").val("waste");
  search_lead_decor_filter();
}

function check_email_validation(email, id) {

  if (!ValidateEmail(email)) {

    showToast("info", "Invalid Email Address! Please type a valid email address.");

    $("#" + id).focus(); 

    return false; 

  }

  return true; 

}


function ValidateEmail(mail) {

  var emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;

  return emailRegex.test(mail);

}

function isNumberKeys(evt) {

  evt = (evt) ? evt : window.event;

  var charCode = (evt.which) ? evt.which : evt.keyCode;

  if (charCode > 31 && (charCode < 48 || charCode > 57)) {

      return false;

  }

  return true;

}


function isFloatNegativeKey(e,vls){



  if (e.charCode >= 32 && e.charCode < 127 && !/^-?\d*[.,]?\d*$/.test(vls + '' + String.fromCharCode(e.charCode)))

  {

    return false;

  }

  return true;

}



function isNumberFloatKey(evt)

{

  var charCode = (evt.which) ? evt.which : evt.keyCode;

  if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57)){

      return false;

  }

  return true;

}

function get_pick_a_lead_counts() {
  var usePath = $.trim($("#rootXPath").val());

  $.ajax({
    url: usePath + "lead_decor_list/ajax_process",
    type: "POST",
    data: { identity: "SHOWCOUNT" },
    success: function (resp) {
      if (resp.guestinfocounts !== undefined) {
        $("#lead_count").text(resp.guestinfocounts);
      }
      if (resp.html) {
        $("#pickaleadgrid").html(resp.html);
      }
    },
    error: function () {
      console.error("Failed to fetch Pick a Lead count.");
    }
  });
}

function refreshTotalAmount() {
  var usePath = $.trim($("#rootXPath").val());
  var entry_no = $.trim($("#dh_entry_no").val());

  $.ajax({
    url: usePath + "lead_decor_list/ajax_process",
    type: "POST",
    data: { identity: "GET_TOTAL_AMOUNT", entry_no: entry_no },
    success: function (resp) {
      if (resp.total_amount !== undefined) {
        $("#dh_total_amt").val(resp.total_amount);
        calculateDecorFinancials(); // Recalculate all dependent fields
      }
    },
    error: function () {
      console.error("Failed to fetch total amount.");
    }
  });
}

  function search_additional_remarks() {
    var usePath = $.trim($("#rootXPath").val());
    var dh_addtional_remrks = $.trim($("#dh_addtional_remrks").val());

  if (dh_addtional_remrks !== '') {
        $(".load_employee").removeClass("hidden");

        setTimeout(function () {
            $.ajax({
                url: usePath + "lead_decor_list/ajax_process",
                type: 'POST',
                data: {
                    'requestcode': '',
                    'additional_remarks': dh_addtional_remrks,
                    'requesttype': 'CODE',
                    'identity': 'ADDREMARKSEARCH'
                },
                async: false,
                success: function (resp) {
                    $(".load_employee").addClass("hidden");
                    var nhtml = '';

                    if (resp.status) {
                        nhtml += '<select id="new_remarks_select" onchange="selected_my_remarks_list(this.value);"><option value="">-Select-</option>';
                        var sdata = resp.data;

                        if (sdata.length > 0) {
                            $.each(sdata, function (key, leds) {
                                nhtml += `<option value="${leds.dh_addtional_remrks}">${leds.dh_addtional_remrks}</option>`;
                            });
                        }

                        nhtml += '</select>';
                    }

                    $("#additional_remarks").html(nhtml);
                },
                error: function () {
                    $(".load_employee").addClass("hidden");
                },
                cache: false
            });
        }, 500);
    }
}


function selected_my_remarks_list(val){            
    var nstr         = val.split(",");
    for(var i = 0; i < nstr.length; i++) {
       nstr[i] = nstr[i].replace(/'/g, "");
    }   
     if( nstr[0] =='null' ){
         nstr[0] = '';
     }
     if( nstr[1] =='null' ){
         nstr[1] = '';
     }
     $("#dh_addtional_remrks").val(nstr[0]);
     $("#additional_remarks").html('');
}

function calculateDecorFinancials() {
  var totalAmount    = parseFloat($("#dh_total_amt").val()) || 0;
  var taxCAmount     = parseFloat($("#dh_tax_c_amt").val()) || 0;
  var taxDAmount     = parseFloat($("#dh_tax_d_amt").val()) || 0;
  var taxPercentC    = parseFloat($("#dh_tax_percent_c").val()) || 0;
  var taxPercentD    = parseFloat($("#dh_tax_percent_d").val()) || 0;
  var advanceCash    = parseFloat($("#dh_advance_cash").val()) || 0;
  var advanceBank    = parseFloat($("#dh_advance_chq").val()) || 0;
  var factor_0 = $("#dh_factor_0").is(":checked") ? 'Y' : 'N';

  // Step 1: Calculate bank payment
  var bankPayment = 0;
  if (taxCAmount >= 0 || taxDAmount >= 0) {
    bankPayment = taxCAmount + taxDAmount;
    $("#dh_cheque").val(bankPayment);
  } else {
    $("#dh_cheque").val(""); // Clear if no bank payment
  }

  // Step 2: Calculate dh_cash_part only if bank payment exists
  var cashPayment = 0;

  if (bankPayment >= 0) {
    if (factor_0 == 'N'){
      cashPayment = ((totalAmount*2) - bankPayment) * 0.1;
    }
    else {
      cashPayment = (totalAmount - bankPayment);
    }
    if (cashPayment < 0) cashPayment = 0;
    $("#dh_cash_part").val(cashPayment);
  } else {
    $("#dh_cash_part").val(""); // Clear if no valid input
  }

  // Step 3: Calculate tax amounts
  var taxAmountC = (taxCAmount * taxPercentC) / 100;
  var taxAmountD = (taxDAmount * taxPercentD) / 100;

  var totalTaxAmount = taxAmountC + taxAmountD;
  $("#dh_tax_amt").val(totalTaxAmount);

  // Step 4: Net amount
  var netAmount = cashPayment + bankPayment + totalTaxAmount;
  $("#dh_net_amt").val(netAmount);

  // Step 5: Total tax %
  var totalTaxPercent = taxPercentC + taxPercentD;
  $("#dh_tax_percent").val(totalTaxPercent);

  // Step 6: Balance
  var balance = netAmount - (advanceCash + advanceBank);
  $("#dh_balance").val(balance);

  // Step 7: Validation border logic
  var sumCheck = cashPayment + taxCAmount + taxDAmount;
  if (bankPayment > 0 && sumCheck != totalAmount) {

  } else {

  }
}

$(document).ready(function () {
  $("#dh_cash_part, #dh_tax_c_amt, #dh_tax_d_amt, #dh_tax_percent_c, #dh_tax_percent_d, #dh_advance_cash, #dh_advance_chq").on("input", function () {
    calculateDecorFinancials();
  });
refreshTotalAmount();
setTimeout(function () {
  calculateDecorFinancials();
}, 300); // Also run on page load
});

function followup_lead_status(){
  var usePath = $.trim($("#rootXPath").val());
  var lead_status = $.trim($("#FLLW_FIS_Status").val());

  $.ajax({
    url: `${usePath}lead_decor_list/ajax_process`,
    type: 'POST',
    data: {
      lead_status: lead_status,
      identity: "FLLWUPSTATUS"
    },
    success: function (resp) {
      var sdata = resp.data;
      var mhtml = '<option value="">--Select--</option>';
      if (sdata.length > 0) {
        $.each(sdata, function (key, leds) {
          mhtml += '<option value="' + leds.followup_status + '">' + leds.followup_status + '</option>';
        });
      } else {
        mhtml += '<option value="">No available</option>';
      }
      $("#FLLW_Status").html(mhtml);
    },
    error: function () {
      showToast("error", "Failed to fetch venue locations. Please try again.");
    },
    cache: false
  });
}

function venue_leadtype(){
  var dhd_lead_type = $.trim($("#dhd_lead_type").val());
  if (dhd_lead_type == 'I'){
    $("#venue_dropdown").removeClass("hidden");
    $("#address_dropdown").removeClass("hidden");
    $("#venue_input").removeClass("hidden").addClass("hidden").find("input").val("");;
    $("#address_input").removeClass("hidden").addClass("hidden").find("input").val("");;
  }else if (dhd_lead_type == 'O'){
    $("#venue_input").removeClass("hidden");
    $("#address_input").removeClass("hidden");
    $("#venue_dropdown").removeClass("hidden").addClass("hidden").find("input").val("");;
    $("#address_dropdown").removeClass("hidden").addClass("hidden").find("input").val("");;
  }else {
    $("#venue_input").removeClass("hidden").addClass("hidden").find("input").val("");;
    $("#address_input").removeClass("hidden").addClass("hidden").find("input").val("");;
    $("#venue_dropdown").removeClass("hidden").addClass("hidden").find("input").val("");;
    $("#address_dropdown").removeClass("hidden").addClass("hidden").find("input").val("");;
  }
}

function getVenueLocationList() {
  var usePath = $.trim($("#rootXPath").val());
  var fisd_venue = $.trim($("#dhd_venue1").val());

  $.ajax({
    url: `${usePath}information_list/ajax_process`,
    type: 'POST',
    data: {
      fisd_venue: fisd_venue,
      identity: "VLOC"
    },
    success: function (resp) {
      var sdata = resp.data;
      var mhtml = '<option value="">-Select-</option>';
      if (sdata.length > 0) {
        $.each(sdata, function (key, leds) {
          mhtml += '<option value="' + leds.id + '">' + leds.vloc_locname + '</option>';
        });
      } else {
        mhtml += '<option value="">No locations available</option>';
      }
      $("#dhd_address1").html(mhtml);
    },
    error: function () {
      showToast("error", "Failed to fetch venue locations. Please try again.");
    },
    cache: false
  });
}
function get_fis_id_followup(id) {
  $("#FLLW_fis_id").val(id);
}

function get_fis_detals(id) {
  $("#FIS_id").val(id);
}

function get_fis_id_transfr(id,user,username) {
  $("#transfr_fis_id").val(id);
  $("#current_assigne_id").val(user);
  $("#current_assigne").val(username);
}

function saveAssignModal() {
  var usePath = $.trim($("#rootXPath").val());
  const FIS_id = $("#FIS_id").val();
  const FIS_Assign_User = document.getElementById('FIS_Assign_User').value || '';
  const FIS_Assign_Date = document.getElementById('FIS_Assign_Date').value || '';
  const FIS_Assign_Time = document.getElementById('FIS_Assign_Time').value || '';
  const FIS_Assign_Remarks = document.getElementById('FIS_Assign_Remarks').value || '';
  const FIS_Assign_type = document.getElementById('FIS_Assign_type').value || '';

  // Validation
  if (!FIS_Assign_User) {
    alert('Please select a user to assign.');
    return;
  }

  if (!FIS_Assign_Date) {
    alert('Please select an assign date.');
    return;
  }

  if (!FIS_Assign_Time) {
    alert('Please select an assign time.');
    return;
  }

  // CSRF Token (if needed)
  const csrfToken = $('meta[name="csrf-token"]').attr('content');

  $.ajax({
    url: usePath + "information_list/ajax_process",
    type: "POST",
    // headers: {
    //   'X-CSRF-Token': csrfToken // Include CSRF token if required
    // },
    data: {
      FIS_id,
      FIS_Assign_User,
      FIS_Assign_Date,
      FIS_Assign_Time,
      FIS_Assign_Remarks,
      identity: "FISASSIGN"
    },
    success: function (resp) {
      if (resp.status) {
        showToast("success", resp.message);
        // Optionally close the modal or refresh the table
        const modal = bootstrap.Modal.getInstance(document.getElementById('assignModal'));
        modal.hide();
         //location.reload(); // Uncomment if needed to refresh the page
         window.location.href = window.location.origin + window.location.pathname;
      } else {
        showToast("error", resp.message);
      }
    },
    error: function (xhr, status, error) {
      console.error('AJAX Error:', status, error);
      showToast("error", "An error occurred while processing the request.");
    },
    cache: false
  });
}

function save_followup_details() {
  var usePath = $.trim($("#rootXPath").val());
  const FLLW_fis_id = $("#FLLW_fis_id").val();
  const FLLW_By_User = document.getElementById('FLLW_By_User').value || '';
  const FLLW_Date = document.getElementById('FLLW_Date').value || '';
  const FLLW_time = document.getElementById('FLLW_time').value || '';
  const FLLW_Next_Date = document.getElementById('FLLW_Next_Date').value || '';
  const FLLW_Next_Time = document.getElementById('FLLW_Next_Time').value || '';
  const FLLW_Next_Remarks = document.getElementById('FLLW_Next_Remarks').value || '';
  const FLLW_Status = document.getElementById('FLLW_Status').value || '';
  const FLLW_FIS_Status = document.getElementById('FLLW_FIS_Status').value || '';
  const FLLW_type = document.getElementById('FLLW_type').value || '';


  // Validation
  if (!FLLW_By_User) {
    alert('Please select a user.');
    return;
  }

  if (FLLW_FIS_Status.toLowerCase() !== 'dead' && FLLW_FIS_Status.toLowerCase() !== 'waste') {
    if (!FLLW_Next_Date) {
      alert('Please select the next follow-up date.');
      return;
    }

    if (!FLLW_Next_Time) {
      alert('Please select the next follow-up time.');
      return;
    }
  }

  // CSRF Token (if needed)
  //const csrfToken = $('meta[name="csrf-token"]').attr('content');

  $.ajax({
    url: usePath + "lead_decor_list/ajax_process",
    type: "POST",
    // headers: {
    //   'X-CSRF-Token': csrfToken // Include CSRF token if required
    // },
    data: {
      FLLW_fis_id,
      FLLW_By_User,
      FLLW_Date,
      FLLW_time,
      FLLW_Next_Date,
      FLLW_Next_Time,
      FLLW_Next_Remarks,
      FLLW_Status,
      FLLW_FIS_Status,
      FLLW_type,
      identity: "FOLLOWUP"
    },
    success: function (resp) {
      if (resp.status) {
        showToast("success", resp.message);
        // Close the modal
        const modal = bootstrap.Modal.getInstance(document.getElementById('followUpModal'));
        modal.hide();
        //location.reload(); 
        window.location.reload();

      } else {
        showToast("error", resp.message);
      }
    },
    error: function (xhr, status, error) {
      console.error('AJAX Error:', status, error);
      showToast("error", "An error occurred while processing the request.");
    },
    cache: false
  });
}


function view_fis_details(id) {
  var usePath = $.trim($("#rootXPath").val());

  // Set hidden field value
  $("#view_fis_id").val(id);

  $.ajax({
      url: `${usePath}lead_decor_list/ajax_process`,
      type: "POST",
      data: {
          fis_id: id,
          identity: "VIEWFIS"
      },
      success: function (resp) {
          if (resp.status) {
              // Update modal content and show modal
              $("#viewDetailsModal .modal-body").html(resp.data);
              $("#viewDetailsModal").modal("show");

              // Optional: Display success notification
              // showToast("success", resp.message);
          } else {
              // Show error message
              showToast("error", resp.message);
          }
      },
      error: function () {
          // Show generic error message
          showToast("error", "An error occurred while processing the request.");
      },
      cache: false
  });
}

function saveTransferAssignee() {
  const usePath = $.trim($("#rootXPath").val());
  const transfer_fis_id = $("#transfr_fis_id").val();
  const current_assignee_id = document.getElementById('current_assigne_id').value || '';
  const new_assignee = document.getElementById('new_assignee').value || '';
  const transfer_date = document.getElementById('transfer_date').value || '';
  const transfer_time = document.getElementById('transfer_time').value || '';
  const remarks = document.getElementById('remarks').value || '';
  const assignee_type = document.getElementById('assignee_type').value || '';

  // Validation
  if (!new_assignee) {
    showToast("error", 'Please select a user to assign.');
    return;
  }
  if (current_assignee_id === new_assignee) {
    showToast("error", 'Please select a different user to assign.');
    return;
  }
  if (!transfer_date) {
    showToast("error", 'Transfer date is required.');
    return;
  }
  if (!transfer_time) {
    showToast("error", 'Transfer time is required.');
    return;
  }

  // Perform AJAX request
  $.ajax({
    url: usePath + "lead_decor_list/ajax_process",
    type: "POST",
    data: {
      transfer_fis_id,
      current_assignee_id,
      new_assignee,
      transfer_date,
      transfer_time,
      remarks,
      assignee_type,
      identity: "TRANSFER"
    },
    success: function (resp) {
      if (resp.status) {
        showToast("success", resp.message);

        // Optionally close the modal
        const modal = bootstrap.Modal.getInstance(document.getElementById('transferModal'));
        if (modal) modal.hide();

        // Reload the page or refresh data
        window.location.reload();

      } else {
        showToast("error", resp.message);
      }
    },
    error: function (xhr, status, error) {
      console.error('AJAX Error:', status, error);
      showToast("error", "An error occurred while processing the request.");
    },
    cache: false
  });
}

function cancelFollowUp(followupId, date, time, remarks) {
  var usePath = $.trim($("#rootXPath").val());
  
  if (!usePath) {
    showToast("error", "Invalid base path. Please contact the administrator.");
    return;
  }

  // Confirmation Alert
  const message = `Are you sure you want to cancel this follow-up?\n\nDate: ${date}\nTime: ${time}\nRemarks: ${remarks}`;
  if (confirm(message)) {
    // AJAX Request to Update Follow-Up Status
    $.ajax({
      url: usePath + "lead_decor_list/ajax_process",
      type: 'POST',
      data: {
        followup_id: followupId,
        status: 'C',
        identity: "CANCEL"

      },
      // headers: {
      //   'X-CSRF-Token': $('meta[name="csrf-token"]').attr('content') // Include CSRF token for security
      // },
      success: function(response) {
        if (response.status) {
          showToast("success", 'Follow-up record successfully canceled.');
         // location.reload(); // Reload page to reflect changes
         window.location.href = window.location.origin + window.location.pathname;

        } else {
          showToast("error", `Error: ${response.message}`);
        }
      },
      error: function(xhr, status, error) {
        console.error('AJAX Error:', {
          status: status,
          error: error,
          response: xhr.responseText
        });
        showToast("error", 'An error occurred while canceling the follow-up.');
      }
    });
  }
}

function fetch_status_list(type) {
  var usePath = $.trim($("#rootXPath").val());
  var formData = new FormData();

  var function_from_date = $.trim($("#function_from_date").val());
  var function_upto_date = $.trim($("#function_upto_date").val());
  var statustype = type;
  var department_search = $.trim($("#department_search").val());
  var source_search = $.trim($("#source_search").val());

  formData.append("identity", "STATUSSEARCH");
  formData.append("statustype", statustype);
  formData.append("function_from_date", function_from_date);
  formData.append("function_upto_date", function_upto_date);
  formData.append("department_search", department_search);
  formData.append("source_search", source_search);

  $(".no_loader").addClass("hidden");
  $(".show_loader").removeClass("hidden");

  $.ajax({
    url: usePath + "lead_decor_list/ajax_process",
    type: 'POST',
    data: formData,
    async: false,
    contentType: false,
    processData: false,
    success: function (resp) {
      var ntml = '<tr><td colspan="4">No record(s) found.</td></tr>';
              $(".hide_pagination").addClass("hidden");

      if (resp.status) {
        $("#status_filter_list").html(resp.data);
      } else {
        $("#status_filter_list").html(ntml);
      }
      $(".show_loader").addClass("hidden");
      $(".no_loader").removeClass("hidden");
    },
    error: function () {
      $(".show_loader").addClass("hidden");
      $(".no_loader").removeClass("hidden");
    },
    cache: false
  });
}




  function open_forward_lead_modal(leadno){
          $('#contractno').val(leadno); 
          $('#display_contractno').text(leadno); 
}



function forward_to_departments() {
    var usePath = $.trim($("#rootXPath").val());
    var contractno = $.trim($("#contractno").val());
    var departmnet = $.trim($("#forward_to").val());
    var userid = $.trim($("#forward_to_user").val());

if (!departmnet ) {
   showToast("info","Select Department you want to forward this contract to ");
   $("#forward_to").focus();
   return false;
  }

    // Show the loader
    $(".process_loader_table").show();

    $.ajax({
        url: usePath + "lead_decor_list/ajax_process",
        type: 'POST',
        data: { 'identity': 'FORWARD', 'contractno':contractno , 'departmnet' : departmnet, 'userid' : userid},
        success: function (resp) {
          if (resp.status) {
            showToast("success", resp.message);
          if (departmnet.toLowerCase() === "venue") {
            alert("Lead forwarded to Venue Department!");
          } else if (departmnet.toLowerCase() === "catering") {
            alert("Lead forwarded to Catering Department!");
          } else if (departmnet.toLowerCase() === "entertainment") {
            alert("Lead forwarded to Entertainment Department!");
          }   else if (departmnet.toLowerCase() === "venue") {
            alert("Lead forwarded to Venue Department!");
          }                 
            const modal = bootstrap.Modal.getInstance(document.getElementById('forwardToDeptModal'));
            modal.hide();
            //location.reload(); 
            window.location.reload();

          } else {
            alert(resp.message);
            showToast("error", resp.message);
          }
        },
        error: function () {
            alert("An error occurred while processing the request.");
        },
        complete: function () {
            // Hide the loader when done
            $(".process_loader_table").hide();
        },
        cache: false
    });
}



  function get_department_users() {
    var usePath = $.trim($("#rootXPath").val());
    var departmnet = $.trim($("#forward_to").val());

  if (departmnet !== '') {
        $(".show_loader").removeClass("hidden");
        $(".no_loader").removeClass("hidden").addClass("hidden");
        setTimeout(function () {
            $.ajax({
                url: usePath + "contract_catering_list/ajax_process",
                type: 'POST',
                data: {
                    'departmnet': departmnet,
                    'requesttype': 'CODE',
                    'identity': 'GETDEPTUSERS'
                },
                async: false,
                success: function (resp) {
                    $(".show_loader").removeClass("hidden").addClass("hidden");
                    $(".no_loader").removeClass("hidden");
                    var nhtml = '';

                    if (resp.status) {
                        nhtml += '<select class="form-select"><option value="">-Select-</option>';

                        var sdata = resp.data;

                        if (sdata.length > 0) {
                            $.each(sdata, function (key, leds) {
                                nhtml += `<option value="${leds.id}">${leds.username}</option>`;
                            });
                        }

                        nhtml += '</select>';
                    }

                    $("#forward_to_user").html(nhtml);
                },
                error: function () {
                    $(".show_loader").removeClass("hidden").addClass("hidden");
                    $(".no_loader").removeClass("hidden");
                },
                cache: false
            });
        }, 500);
    }
}

