function alertChecked(url){

  if( confirm("Are you sure want to delete ?")){

    

      window.location = url

  }

}

  function set_global_focus(id){

    $("#"+id).focus();

}

  $(document).ready(function() {
    venue_leadtype();
  });

   function venue_leadtype(){
    var fisd_lead_type = $.trim($("#fisd_lead_type").val());
    if (fisd_lead_type == 'I'){
      $("#venue_dropdown").removeClass("hidden");
      $("#address_dropdown").removeClass("hidden");
      $("#venue_input").removeClass("hidden").addClass("hidden").find("input").val("");;
      $("#address_input").removeClass("hidden").addClass("hidden").find("input").val("");;
    }else if (fisd_lead_type == 'O'){
      $("#venue_input").removeClass("hidden");
      $("#address_input").removeClass("hidden");
      $("#venue_dropdown").removeClass("hidden").addClass("hidden").find("input").val("");;
      $("#address_dropdown").removeClass("hidden").addClass("hidden").find("input").val("");;
    }else {
      $("#venue_input").removeClass("hidden").addClass("hidden").find("input").val("");;
      $("#address_input").removeClass("hidden").addClass("hidden").find("input").val("");;
      $("#venue_dropdown").removeClass("hidden").addClass("hidden").find("input").val("");;
      $("#address_dropdown").removeClass("hidden").addClass("hidden").find("input").val("");;
    }
  }

  $("#fis_search").on("keypress", function(e) {
    if (e.which === 13) { // 13 = Enter key
        e.preventDefault();
        search_fis_filter();
    }
});


function updateDateLabels() {
    let type = $("#search_date_type").val();

    if (type === "CD") {
        $("label[for='from_date']").text("Created From");
        $("label[for='upto_date']").text("Created Upto");

    } else {
        $("label[for='from_date']").text("Function From");
        $("label[for='upto_date']").text("Function Upto");

    }
}

// Run once after page refresh
$(document).ready(function() {
    updateDateLabels();
});

// Run again when select changes
$(document).on("change", "#search_date_type", function () {
    updateDateLabels();
});


function fis_function_list() {
  var usePath = $.trim($("#rootXPath").val());
  var formData = new FormData();
  var other_data = $("form#myforms").serializeArray();

  var mid = $.trim($("#funcInfoId").val());
var fisd_lead_type= $.trim($("#fisd_lead_type").val());
  // Basic Validations for Required Fields
  var fis_guest_name = $.trim($("#fis_guest_name").val());
  var fis_client_mobile = $.trim($("#fis_client_mobile").val());
  var fis_address = $.trim($("#fis_address").val());
  var fis_client_email = $.trim($("#fis_client_email").val());
  var fisd_function_type = $.trim($("#fisd_function_type").val());
  var fisd_function_date = $.trim($("#fisd_function_date").val());
  var fisd_function_timings = $.trim($("#fisd_function_timings").val());

  var fisd_venue_id = $.trim($("#fisd_venue_id").val());
  var fisd_location_id = $.trim($("#fisd_location_id").val());
  var fisd_venue_name   = $.trim($("#fisd_venue_name").val());
  var fisd_location_name= $.trim($("#fisd_location_name").val());
  var fisd_menu_value = $.trim($("#fisd_menu_value").val());
  var fisd_decoration_lumpsum = $.trim($("#fisd_decoration_lumpsum").val());
  var fisd_decoration_remarks = $.trim($("#fisd_decoration_remarks").val());
  var fisd_entertainment_lumpsum = $.trim($("#fisd_entertainment_lumpsum").val());
  var fisd_entertainment_remarks = $.trim($("#fisd_entertainment_remarks").val());
  var fisd_extra_plate_charge =  $.trim($("#fisd_extra_plate_charge").val());

  if (fis_guest_name == "") {
    showToast("error", "Guest is required.");
    setTimeout(function () {
      set_global_focus("fis_guest_name");
    }, 500);
    return false;
  } else if (fis_client_mobile == "") {
    showToast("error", "Client Mobile is required.");
    setTimeout(function () {
      set_global_focus("fis_client_mobile");
    }, 500);
    return false;
  } else if (fis_address == "") {
    showToast("error", "Address is required.");
    setTimeout(function () {
      set_global_focus("fis_address");
    }, 500);
    return false;
  } else if (fisd_function_type == "") {
    showToast("error", "Function Type is required.");
    setTimeout(function () {
      set_global_focus("fisd_function_type");
    }, 500);
    return false;
  }  

if (fis_client_mobile.length !== 10 || !/^\d+$/.test(fis_client_mobile)) {
  showToast("error", "Mobile number should be exactly 10 digits.");
  setTimeout(function() { set_global_focus('fis_client_mobile'); }, 500);
  return false;
}

  if (!fisd_lead_type) {
      showToast("error","Lead Type is required");
      $("#fisd_lead_type").focus();
      return false;
    }

    if (!fisd_function_date) {
      showToast("error","Function Date is required");
      $("#fisd_function_date").focus();
      return false;
    }

    if (!fisd_function_timings) {
      showToast("error","Function Time is required");
      $("#fisd_function_timings").focus();
      return false;
    }

  if (fisd_lead_type == 'I') {
    if (!fisd_venue_id) {
      showToast("error", "Venue is required");
      $("#fisd_venue_id").focus();
      return false;
    }
    if (!fisd_location_id) {
      showToast("error", "Location is required");
      $("#fisd_location_id").focus();
      return false;
    }
  }

  if (fisd_lead_type == 'O') {
    if (!fisd_venue_name) {
      showToast("error", "Venue Name is required");
      $("#fisd_venue_name").focus();
      return false;
    }
    if (!fisd_location_name) {
      showToast("error", "Location Name is required");
      $("#fisd_location_name").focus();
      return false;
    }
  }

    if (!fisd_menu_value) {
      showToast("error","Catering Value is required");
      $("#fisd_menu_value").focus();
      return false;
    }

      if (!fisd_extra_plate_charge) {
      showToast("error","Extra Plate Charge is required");
      $("#fisd_extra_plate_charge").focus();
      return false;
    }

    if (!fisd_decoration_lumpsum) {
      showToast("error","Decor Lumpsum is required");
      $("#fisd_decoration_lumpsum").focus();
      return false;
    }

    if (!fisd_decoration_remarks) {
      showToast("error","Decor Remarks is required");
      $("#fisd_decoration_remarks").focus();
      return false;
    }

    if (!fisd_entertainment_lumpsum) {
      showToast("error","Entertainment Lumpsum is required");
      $("#fisd_entertainment_lumpsum").focus();
      return false;
    }

    if (!fisd_entertainment_remarks) {
      showToast("error","Entertainment Remarks is required");
      $("#fisd_entertainment_remarks").focus();
      return false;
    }

  if (fis_client_email) {
  var emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
  if (!emailPattern.test(fis_client_email)) {
    showToast("error", "Please enter a valid email address.");
    setTimeout(function() { set_global_focus('fis_client_email'); }, 500);
    return false;
  }
  }

  formData.append("identity", "INFORMATIONFUNCTION");
  formData.append("funcInfoId", mid);

  // Collect Data from Inputs
  $.each(other_data, function (key, input) {
    formData.append(input.name, input.value);
  });

  $(".no_loader").removeClass("hidden").addClass("hidden");
  $(".loader").removeClass("hidden");

  setTimeout(function () {
    $.ajax({
      url: usePath + "information_list/ajax_process",
      type: "POST",
      data: formData,
      async: false,
      contentType: false,
      processData: false,
      success: function (resp) {
        if (resp.status) {
          $("#func_info_list").html(resp.data);
          $("#mid").val(resp.headerid);
          $("#prepid").val(resp.prepid); 
          showToast("success", resp.message);
          setTimeout(() => get_pick_a_lead_counts(), 1000);
          refreshTotalAmount();
          setTimeout(function () {
            reset_functionlist_afteradd();
          }, 500);
        } else {
          $(".no_loader").removeClass("hidden");
          $(".loader").removeClass("hidden").addClass("hidden");
          $(".process_qualif_save").show();

          showToast("error", resp.message);
        }
      },
      error: function () {
        $(".no_loader").removeClass("hidden");
        $(".loader").removeClass("hidden").addClass("hidden");
      },
      cache: false,
    });
  }, 500);
}


document.addEventListener("DOMContentLoaded", function () {
  // Attach event listener to fisd_menu_type dropdown
  const menuTypeDropdown = document.getElementById("fisd_menu_type");
  const menuValueInput = document.getElementById("fisd_menu_value");

  if (menuTypeDropdown && menuValueInput) {
    menuTypeDropdown.addEventListener("change", function () {
      handleMenuTypeChange();
    });

    // Initial call in case form is loaded with a pre-selected value
    handleMenuTypeChange();
  }
});

function handleMenuTypeChange() {
  const menuType = document.getElementById("fisd_menu_type").value;
  const menuValueInput = document.getElementById("fisd_menu_value");
  const paxNoInput = document.getElementById("fisd_pax_no");
  const menuRateInput = document.getElementById("fisd_menu_rate");

  if (menuType === "Per Person") {
    menuValueInput.value = "";
    menuValueInput.readOnly = true;
    menuRateInput.readOnly = false;
    // Auto-calculate Value when Pax No. or Rate is updated
    paxNoInput.addEventListener("input", calculateMenuValue);
    menuRateInput.addEventListener("input", calculateMenuValue);
    calculateMenuValue();
  } else if (menuType === "Lumpsum") {
    menuRateInput.value = "";
    menuValueInput.readOnly = false;
    menuRateInput.readOnly = true;
    // Remove calculation event listeners (optional)
    paxNoInput.removeEventListener("input", calculateMenuValue);
    menuRateInput.removeEventListener("input", calculateMenuValue);
  }
}

function calculateMenuValue() {
  const paxNo = parseFloat(document.getElementById("fisd_pax_no").value) || 0;
  const rate = parseFloat(document.getElementById("fisd_menu_rate").value) || 0;
  const menuValueInput = document.getElementById("fisd_menu_value");

  menuValueInput.value = (paxNo * rate).toFixed(2);
}




function isFloatNegativeKey(e,vls){



  if (e.charCode >= 32 && e.charCode < 127 && !/^-?\d*[.,]?\d*$/.test(vls + '' + String.fromCharCode(e.charCode)))

  {

    return false;

  }

  return true;

}



function isNumberFloatKey(evt)

{

  var charCode = (evt.which) ? evt.which : evt.keyCode;

  if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57)){

      return false;

  }

  return true;

}



function isNumberKeys(evt) {

  evt = (evt) ? evt : window.event;

  var charCode = (evt.which) ? evt.which : evt.keyCode;

  if (charCode > 31 && (charCode < 48 || charCode > 57)) {

      return false;

  }

  return true;

}





$(document).ready(function(){



  flatpickr("#from_date", {



    dateFormat: "d-M-Y",



    allowInput: true,



    onOpen: function (selectedDates, dateStr, instance) {



      instance.setDate(instance.input.value, false);



    },



  });



});



$(document).ready(function(){



  flatpickr("#upto_date", {



    dateFormat: "d-M-Y",



    allowInput: true,



    onOpen: function (selectedDates, dateStr, instance) {



      instance.setDate(instance.input.value, false);



    },



  });



});



$(document).ready(function(){



  flatpickr("#fis_function_date_from", {



    dateFormat: "d-M-Y",



    allowInput: true,

    minDate: "today",

    onOpen: function (selectedDates, dateStr, instance) {



      instance.setDate(instance.input.value, false);



    },



  });



});



$(document).ready(function(){



  flatpickr("#fis_function_date_upto", {



    dateFormat: "d-M-Y",



    allowInput: true,

    minDate: "today",


    onOpen: function (selectedDates, dateStr, instance) {



      instance.setDate(instance.input.value, false);



    },



  });



});


$(document).ready(function(){
  flatpickr("#fisd_function_date", {
   dateFormat: "d-M-Y",
   allowInput: true,
    onOpen: function (selectedDates, dateStr, instance) {
   instance.setDate(instance.input.value, false);
  },
 });
});

function search_fis_filter(){

  var useroot = $("#rootXPath").val();

  $(".show_loader").removeClass("hidden");

  $(".no_loader").removeClass("hidden").addClass("hidden")

  $("form#myForms").attr("action",useroot+"information_list/search");

  $("form#myForms").submit();

}

function fetch_status_list(type) {
  var usePath = $.trim($("#rootXPath").val());
  var formData = new FormData();

  var function_from_date = $.trim($("#function_from_date").val());
  var function_upto_date = $.trim($("#function_upto_date").val());
  var statustype = type;
  var department_search = $.trim($("#department_search").val());
  var source_search = $.trim($("#source_search").val());

  formData.append("identity", "STATUSSEARCH");
  formData.append("statustype", statustype);
  formData.append("function_from_date", function_from_date);
  formData.append("function_upto_date", function_upto_date);
  formData.append("department_search", department_search);
  formData.append("source_search", source_search);

  $(".no_loader").addClass("hidden");
  $(".show_loader").removeClass("hidden");

  $.ajax({
    url: usePath + "information_list/ajax_process",
    type: 'POST',
    data: formData,
    async: false,
    contentType: false,
    processData: false,
    success: function (resp) {
      var ntml = '<tr><td colspan="4">No record(s) found.</td></tr>';
      if (resp.status) {
        $("#status_filter_list").html(resp.data);
      } else {
        $("#status_filter_list").html(ntml);
      }
      $(".show_loader").addClass("hidden");
      $(".no_loader").removeClass("hidden");
    },
    error: function () {
      $(".show_loader").addClass("hidden");
      $(".no_loader").removeClass("hidden");
    },
    cache: false
  });
}

function show_open_status_list() {
  $("#venue_status_search").val("open");
  search_fis_filter();
}

function show_mild_status_list() {
  $("#venue_status_search").val("mild");
  search_fis_filter();
}

function show_warm_status_list() {
  $("#venue_status_search").val("warm");
  search_fis_filter();
}

function show_hot_status_list() {
  $("#venue_status_search").val("hot");
  search_fis_filter();
}

function show_closed_status_list() {
  $("#venue_status_search").val("closed");
  search_fis_filter();
}

function show_dead_status_list() {
  $("#venue_status_search").val("dead");
  search_fis_filter();
}

function show_waste_status_list() {
  $("#venue_status_search").val("waste");
  search_fis_filter();
}

function process_save_fis(){

  var usePath           = $.trim( $("#rootXPath").val() );

  var formData          = new FormData();

  var other_data        = $('form#myforms').serializeArray();

  var mid               = $.trim( $("#mid").val() ); 

  //var fis_venue      = $.trim( $("#fis_venue").val() );

  var fis_entryno    = $.trim( $("#fis_entryno").val() );

  var fis_guest_name       = $.trim( $("#fis_guest_name").val() ); 

  var fis_address         = $.trim( $("#fis_address").val() );

  var fis_state      = $.trim( $("#fis_state").val() );

  var fis_client_mobile       = $.trim( $("#fis_client_mobile").val() ); 

  var fis_pin         = $.trim( $("#fis_pin").val() );

  var fis_client_email      = $.trim( $("#fis_client_email").val() );


  // if( fis_venue == ''){

  //   showToast("error","Venue Name is required.");

  //   setTimeout(function(){ set_global_focus('fis_venue');},500);

  //   return false;

  // } 
 if( fis_guest_name == ''){

    showToast("error","Guest name is required.");

    setTimeout(function(){ set_global_focus('fis_guest_name');},500);

    return false;
   }else if( fis_client_mobile == ''){

      showToast("error","Contact No. is required.");
  
      setTimeout(function(){ set_global_focus('fis_client_mobile');},500);
  
      return false;


  }else if( fis_address == ''){

    showToast("error","Address is required.");

    setTimeout(function(){ set_global_focus('fis_address');},500);

    return false;

  }
  // Validate mobile number length
if (fis_client_mobile.length !== 10 || !/^\d+$/.test(fis_client_mobile)) {
  showToast("error", "Mobile number should be exactly 10 digits.");
  setTimeout(function() { set_global_focus('fis_client_mobile'); }, 500);
  return false;
}


// Validate email format
if (fis_client_email) {
var emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
if (!emailPattern.test(fis_client_email)) {
  showToast("error", "Please enter a valid email address.");
  setTimeout(function() { set_global_focus('fis_client_email'); }, 500);
  return false;
}
}

  formData.append("identity", "INFORMATION");

  formData.append("mid", mid);    

  formData.append("fis_entryno", fis_entryno);  

  $.each(other_data,function(key,input){

      formData.append(input.name,input.value);

  });

  

   $(".no_loader").removeClass("hidden").addClass("hidden");

   $(".loader").removeClass("hidden");

    setTimeout(function(){

  $.ajax({

          url: usePath+"information_list/ajax_process",

          type: 'POST',

          data: formData,

          async: false,

          contentType: false,

          processData: false,

          success: function (resp) {

            

            if( resp.status ){

              $("#mid").val(resp.profileid);                         

              showToast("success",resp.message);  
          setTimeout(() => get_pick_a_lead_counts(), 1000);

              let redirectPage = $.trim($("#page_redirect").val());
              let redirectURL = usePath + "information_list";
              if (redirectPage) {
                redirectURL += "?page=" + redirectPage;
              }
              window.location.href = redirectURL;
                    
            }else{  

              $(".no_loader").removeClass("hidden");

               $(".loader").removeClass("hidden").addClass("hidden");                         

              showToast("success",resp.message); 

            }



          },

          error: function () {

            $(".no_loader").removeClass("hidden");

            $(".loader").removeClass("hidden").addClass("hidden");

              $(".process_save").show();

          },

          cache: false

           });



    },500);

}

  function get_pick_a_lead_counts() {
    var usePath = $.trim($("#rootXPath").val());
  
    $.ajax({
      url: usePath + "information_list/ajax_process",
      type: "POST",
      data: { identity: "SHOWCOUNT" },
      success: function (resp) {
        if (resp.guestinfocounts !== undefined) {
          $("#lead_count").text(resp.guestinfocounts);
        }
        if (resp.html) {
          $("#pickaleadgrid").html(resp.html);
        }
      },
      error: function () {
        console.error("Failed to fetch Pick a Lead count.");
      }
    });
  }

  function refreshTotalAmount() {
    var usePath = $.trim($("#rootXPath").val());
    var entry_no = $.trim($("#fis_entryno").val());
  
    $.ajax({
      url: usePath + "information_list/ajax_process",
      type: "POST",
      data: { identity: "GET_TOTAL_AMOUNT", 'entry_no': entry_no },
      success: function (resp) {
        if (resp.total_amount !== undefined) {
          $("#fis_total_amt").val(resp.total_amount);
          calculateDecorFinancials(); // Recalculate all dependent fields
        }
      },
      error: function () {
        console.error("Failed to fetch total amount.");
      }
    });
  }
  
function calculateDecorFinancials() {
  var totalAmount    = parseFloat($("#fis_total_amt").val()) || 0;
  var taxCAmount     = parseFloat($("#fis_tax_c_amt").val()) || 0;
  var taxDAmount     = parseFloat($("#fis_tax_d_amt").val()) || 0;
  var taxPercentC    = parseFloat($("#fis_tax_percent_c").val()) || 0;
  var taxPercentD    = parseFloat($("#fis_tax_percent_d").val()) || 0;
  var advanceCash    = parseFloat($("#fis_advance_cash").val()) || 0;
  var advanceBank    = parseFloat($("#fis_advance_chq").val()) || 0;
  var factor_0 = $("#fis_factor_0").is(":checked") ? 'Y' : 'N';

  // Step 1: Calculate bank payment
  var bankPayment = 0;
  if (taxCAmount >= 0 || taxDAmount >= 0) {
    bankPayment = taxCAmount + taxDAmount;
    $("#fis_cheque").val(bankPayment);
  } else {
    $("#fis_cheque").val(""); // Clear if no bank payment
  }

  // Step 2: Calculate fis_cash_part only if bank payment exists
  var cashPayment = 0;

  if (bankPayment >= 0) {
    if (factor_0 == 'N'){
      cashPayment = ((totalAmount*2) - bankPayment) * 0.1;
    }
    else {
      cashPayment = (totalAmount - bankPayment);
    }
    if (cashPayment < 0) cashPayment = 0;
    $("#fis_cash_part").val(cashPayment);
  } else {
    $("#fis_cash_part").val(""); // Clear if no valid input
  }

  // Step 3: Calculate tax amounts
  var taxAmountC = (taxCAmount * taxPercentC) / 100;
  var taxAmountD = (taxDAmount * taxPercentD) / 100;

  var totalTaxAmount = taxAmountC + taxAmountD;
  $("#fis_tax_amt").val(totalTaxAmount);

  // Step 4: Net amount
  var netAmount = cashPayment + bankPayment + totalTaxAmount;
  $("#fis_net_amt").val(netAmount);

  // Step 5: Total tax %
  var totalTaxPercent = taxPercentC + taxPercentD;
  $("#fis_tax_percent").val(totalTaxPercent);

  // Step 6: Balance
  var balance = netAmount - (advanceCash + advanceBank);
  $("#fis_balance").val(balance);

  // Step 7: Validation border logic
  var sumCheck = cashPayment + taxCAmount + taxDAmount;
  if (bankPayment > 0 && sumCheck != totalAmount) {

  } else {

  }
}
  
  $(document).ready(function () {
    $("#fis_cash_part,#fis_tax_c_amt, #fis_tax_d_amt, #fis_tax_percent_c, #fis_tax_percent_d, #fis_advance_cash, #fis_advance_chq").on("input", function () {
      calculateDecorFinancials();
    });
    refreshTotalAmount();
    // Optional: also calculate once on page load if values exist
    calculateDecorFinancials();
  });

function modify_function_list(
  id, function_type, function_date, function_timings,lead_type,venue_id, location_id,venue_name,location_name,rent,venue_value,
  pax_no, free_pax_no,fisd_extra_plate_charge,menu, menu_type, menu_rate, menu_value,decor_type,decoration_lumpsum, decoration_remarks,entertain_type,
  entertainment_lumpsum, entertainment_remarks
   // <-- Add this new parameter
) {
  // Set Function Details
  $("#prepid").val(id);
  $("#fisd_function_type").val(function_type);
  $("#fisd_function_date").val(function_date);
  $("#fisd_function_timings").val(function_timings);
  // Set Venue and Location
  $("#fisd_lead_type").val(lead_type);
  venue_leadtype();

  $("#fisd_venue_id").val(venue_id);
  $("#fisd_location_id").val(location_id);
  getVenueLocationList();
  $("#fisd_venue_name").val(venue_name);
  $("#fisd_location_name").val(location_name);

  $("#fisd_rent").val(rent);
  $("#fisd_venue_value").val(venue_value);
  // Set Pax Details
  $("#fisd_pax_no").val(pax_no);
  $("#fisd_free_pax_no").val(free_pax_no);
  $("#fisd_extra_plate_charge").val(fisd_extra_plate_charge);

  // Set Menu Details
  $("#fisd_menu").val(menu);
  $("#fisd_menu_type").val(menu_type);
  $("#fisd_menu_rate").val(menu_rate);
  $("#fisd_menu_value").val(menu_value);

  // Set Decoration Details
  $("#fisd_decor_type").val(decor_type);
  $("#fisd_decoration_lumpsum").val(decoration_lumpsum);
  $("#fisd_decoration_remarks").val(decoration_remarks);

  // Set Entertainment Details
  $("#fisd_entertain_type").val(entertain_type);
  $("#fisd_entertainment_lumpsum").val(entertainment_lumpsum);
  $("#fisd_entertainment_remarks").val(entertainment_remarks);
  handleMenuTypeChange();

}


function extractTimeForInput(datetimeStr) {
  if (!datetimeStr) return "";

  // Extract time part from "2000-01-01 10:00:00 UTC"
  const match = datetimeStr.match(/(\d{2}):(\d{2}):\d{2}/);
  if (match) {
    return `${match[1]}:${match[2]}`; // HH:MM
  }

  return "";
}

function reset_functionlist_afteradd() {
  $("#prepid").val('');
  $("#fisd_function_type").val('');
  $("#fisd_function_date").val('');
  $("#fisd_function_timings").val('');
  // Set Venue and Location
  $("#fisd_lead_type").val('');
  venue_leadtype();
  $("#fisd_venue_id").val('');
  $("#fisd_location_id").val('');
  $("#fisd_venue_name").val('');
  $("#fisd_location_name").val('');

  $("#fisd_rent").val('');
  $("#fisd_venue_value").val('');
  // Set Pax Details
  $("#fisd_pax_no").val('');
  $("#fisd_free_pax_no").val('');
  $("#fisd_extra_plate_charge").val('');

  // Set Menu Details
  $("#fisd_menu").val('');
  $("#fisd_menu_type").val('');
  $("#fisd_menu_rate").val('');
  $("#fisd_menu_value").val('');

  // Set Decoration Details
  $("#fisd_decor_type").val('');
  $("#fisd_decoration_lumpsum").val('');
  $("#fisd_decoration_remarks").val('');

  // Set Entertainment Details
  $("#fisd_entertain_type").val('');
  $("#fisd_entertainment_lumpsum").val('');
  $("#fisd_entertainment_remarks").val('');
}



function clear_fee_fields() {

  $("#funcInfoId").val('');

  $("#fisd_function_type").val('');

  $("#fisd_function_date").val('');

  $("#fisd_function_timings").val('');

  $("#fisd_function_veg_nonveg").val('');

  $("#fisd_paxno").val('');

}
function handleAdoTypeChange() {
  const adoType = document.getElementById("ado_type").value;
  const adoRate = document.getElementById("ado_rate");
  const adoFunctionPax = document.getElementById("ado_function_pax");
  const adoAmount = document.getElementById("ado_amount");

  if (adoType === "lumpsum") {
    // For lumpsum, set the rate to 1, make it readonly, and clear amount
    adoRate.value = 1;
    adoRate.readOnly = true;
    if (!adoAmount.value) {
      adoAmount.value = "";
    }
    adoAmount.readOnly = false;
  } else if (adoType === "person") {
    // Make the amount field readonly and calculate amount
    adoRate.readOnly = false; // Allow editing the rate
    adoFunctionPax.addEventListener("input", updateAmount);
    adoRate.addEventListener("input", updateAmount);
    adoAmount.readOnly = true;
    updateAmount(); // Initial calculation
  } else {
    // Default case: Allow editing both rate and amount
    adoRate.readOnly = false;
    adoAmount.readOnly = false;
  }

  function updateAmount() {
    const pax = parseFloat(adoFunctionPax.value) || 0; // Default to 0 if empty
    const rate = parseFloat(adoRate.value) || 0;       // Default to 0 if empty
    adoAmount.value = (pax * rate);         // Calculate and set amount
  }
}



// USING FOR VIEW FIS SCREEN
function get_fis_details_view(id, fis_entry,fnctn_pax) {
  var usePath = $.trim($("#rootXPath").val());

  // Set hidden field values
  $("#ado_fis_dtl_id").val(id);
  $("#ado_fis_enrty_no").val(fis_entry);
  $("#ado_function_pax").val(fnctn_pax);

  // Get values from hidden fields
  const ado_fis_dtl_id = $("#ado_fis_dtl_id").val();
  const ado_fis_enrty_no = $("#ado_fis_enrty_no").val();

  $.ajax({
    url: usePath + "information_list/ajax_process",
    type: "POST",
    data: { 
      ado_fis_dtl_id: ado_fis_dtl_id, 
      ado_fis_enrty_no: ado_fis_enrty_no, 
      identity: "ADDONLISTVIEW" 
    },
    async: false,
    success: function (resp) {
      if (resp.status) {
        // Populate the table with response data
        $("#addon_info_list_fis").html(resp.data);
        //showToast("success", resp.message);
      } else {
        showToast("error", resp.message);
      }
    },
    error: function () {
      showToast("error", "An error occurred while processing the request.");
    },
    cache: false
  });
}
function get_fis_details(id, entry_num,ck) {
  var usePath = $.trim($("#rootXPath").val());
  currentPrepidIndex = ck; // store globally

  // Set hidden field values
  $("#fis_entryno").val(entry_num);
  $("#ado_fis_dtl_id").val(id);

  // Get values from hidden fields
  const ado_fis_dtl_id = $("#ado_fis_dtl_id").val();
  const ado_fis_enrty_no = $("#fis_entryno").val();

  $.ajax({
    url: usePath + "information_list/ajax_process",
    type: "POST",
    data: { 
      ado_fis_dtl_id: ado_fis_dtl_id, 
      ado_fis_enrty_no: ado_fis_enrty_no, 
      identity: "ADDONLIST" 
    },
    async: false,
    success: function (resp) {
      if (resp.status) {
        // Populate the table with response data
        $("#addon_info_list").html(resp.data);
        //showToast("success", resp.message);
      } else {
        showToast("error", resp.message);
      }
    },
    error: function () {
      showToast("error", "An error occurred while processing the request.");
    },
    cache: false
  });
}

function delete_fis_function(id){

  var usePath      = $.trim( $("#rootXPath").val() );

  if( confirm("Are you sure you want to delete?")){

      window.location = usePath+"information_list/add_first_information/"+id+"/deletefisfunction";

    }



}
   var currentPrepidIndex = null;

function fis_addon_list() {
  var usePath = $.trim($("#rootXPath").val());
  var ado_fis_enrty_no = $.trim($("#fis_entryno").val());
  var ado_fis_dtl_id = $.trim($("#fisd_function_type"+currentPrepidIndex).val());
  var ado_addon = $.trim($("#ado_addon").val());
  var ado_type = $.trim($("#ado_type").val());
  var ado_rate = $.trim($("#ado_rate").val());
  var ado_amount = $.trim($("#ado_amount").val());
  var ado_footer_id = $.trim($("#ado_footer_id").val());
    var addtype = $.trim($("#addtype").val());

  if (ado_addon === '') {
    showToast("error","Select Addon from list");
    $("#ado_addon").focus();
    return false;
  } else if (ado_type === '') {
    showToast("error","Select Addon Type.");
    $("#ado_type").focus();
    return false;
  }else if (ado_rate === '') {
    showToast("error","Addon Rate is required.");
    $("#ado_rate").focus();
    return false;
  }else if (ado_amount === '') {
    showToast("error","Addon Amount is required.");
    $("#ado_amount").focus();
    return false;
  }
  $(".no_loader").removeClass("hidden").addClass("hidden");

  $(".loader").removeClass("hidden");     

 
    $.ajax({
      url: usePath+"information_list/ajax_process",
      type: 'POST',
      data: { 'enrty_no': ado_fis_enrty_no, 'fis_dtl_id': ado_fis_dtl_id,'ado_addon': ado_addon, 'ado_type': ado_type,'ado_rate': ado_rate, 'ado_amount': ado_amount, 'ado_footer_id':ado_footer_id,'addtype':addtype,'identity': 'ADDON' },
      async: false,
      success: function (resp) {
        if( resp.status ){         

          $("#addon_info_list").html(resp.data);
          $("#ado_footer_id").html(resp.footerid);
        
          $("#func_info_list").html(resp.fisdtl);
          showToast("success",resp.message); 
            refreshTotalAmount();



          setTimeout(function(){ reset_addons_details();},500);         

                 



        }else{

            $(".no_loader").removeClass("hidden");

            $(".loader").removeClass("hidden").addClass("hidden");     

            $(".process_qualif_save").show();

            showToast("error",resp.message); 

          

        }
       
      },
      error: function () {
        $(".unprocess_loader").addClass("hidden");
        $(".process_loader").removeClass("hidden");
      },
      cache: false
    });
 
}
function reset_addons_details(){

  $("#ado_addon").val('');

  $("#ado_type").val('');

  $("#ado_rate").val('');

  $("#ado_amount").val('');

  $("#ado_footer_id").val('');

}

function edit_addon_list(id,addon,type,rate,amount){

  $("#ado_footer_id").val(id);

  $("#ado_addon").val(addon);

  $("#cur_ado_addon").val(addon);

  $("#ado_type").val(type);

  $("#ado_rate").val(rate);

  $("#ado_amount").val(amount);
  setTimeout(function(){ handleAdoTypeChange();},500);    

}

function delete_addon_record(addonId) {
  const usePath = $("#rootXPath").val();
  var ado_fis_enrty_no = $.trim($("#ado_fis_enrty_no").val());
  var ado_fis_dtl_id = $.trim($("#ado_fis_dtl_id").val());

  if (confirm("Are you sure you want to delete this record ?")) {
      $.ajax({
          url: `${usePath}information_list/ajax_process`,
          type: 'POST',
          data: {
              addonid: addonId,
              ado_fis_enrty_no: ado_fis_enrty_no,
              ado_fis_dtl_id: ado_fis_dtl_id,
              identity: 'DELETE'
          },
          success: function (resp) {
              if (resp.status) {
                  // Update the UI with new data
                  $("#addon_info_list").html(resp.data);

                  $("#func_info_list").html(resp.fisdtl);

                  // Show success toast
                  showToast("success", resp.message);
              } else {
                  // Handle failure response
                  $(".no_loader").addClass("hidden");
                  $(".loader").addClass("hidden");
                  $(".process_qualif_save").show();

                  // Show error toast
                  showToast("error", resp.message);
              }
          },
          error: function () {
              // Handle request failure
              $(".unprocess_loader").removeClass("hidden");
              $(".process_loader").addClass("hidden");

              showToast("error", "An error occurred while processing your request.");
          },
          cache: false
      });
  }
}


function getVenueLocationList() {
  var usePath = $.trim($("#rootXPath").val());
  var fisd_venue = $.trim($("#fisd_venue_id").val());

  $.ajax({
    url: `${usePath}information_list/ajax_process`,
    type: 'POST',
    data: {
      fisd_venue: fisd_venue,
      identity: "VLOC"
    },
    success: function (resp) {
      var sdata = resp.data;
      var mhtml = '<option value="">-Select-</option>';
      if (sdata.length > 0) {
        $.each(sdata, function (key, leds) {
          mhtml += '<option value="' + leds.id + '">' + leds.vloc_locname + '</option>';
        });
      } else {
        mhtml += '<option value="">No locations available</option>';
      }
      $("#fisd_location_id").html(mhtml);
    },
    error: function () {
      showToast("error", "Failed to fetch venue locations. Please try again.");
    },
    cache: false
  });
}


function fill_venue_list(guestInfoId){
  var usePath = $("#rootXPath").val();

  $.ajax({
           url: usePath+"information_list/ajax_process",
           type: 'POST',
           data: {'identity':'FILLGUESTINFO','guestInfoId':guestInfoId},
           async: false,            
           success: function (resp) {
            if (resp.status === 'success') {
              var data = resp.data;
              $("#fis_guestinfo_id").val(data.id || '');
              $("#fis_guest_name").val(data.name || '');
              $("#fis_client_mobile").val(data.contact || '');
              $("#fisd_function_date").val(data.function_date || '');
              $("#fis_city").val(data.city || '');
              $("#fis_client_email").val(data.email || '');   // Not coming in response, left blank
              $("#fis_enq_mode").val(data.source || '');      // Mode of Enquiry dropdown
              $("#fisd_function_type").val(data.function_type || '');  // Function dropdown
              $("#fisd_pax_no").val(data.pax_no || ''); 
              $("#fis_proposal").val(data.remarks || ''); 
            } else {
              alert(resp.message || "Guest not found");
            }
            $("button[data-bs-dismiss='modal']").click();

           },
           error: function (textStatus, errorThrown) {
               alert("Facing technical issue!");
           },
           cache: false

       });
 }

function save_followup_details() {
  var usePath = $.trim($("#rootXPath").val());
  const FLLW_fis_id = $("#FLLW_fis_id").val();
  const FLLW_By_User = document.getElementById('FLLW_By_User').value || '';
  const FLLW_Date = document.getElementById('FLLW_Date').value || '';
  const FLLW_time = document.getElementById('FLLW_time').value || '';
  const FLLW_Next_Date = document.getElementById('FLLW_Next_Date').value || '';
  const FLLW_Next_Time = document.getElementById('FLLW_Next_Time').value || '';
  const FLLW_Next_Remarks = document.getElementById('FLLW_Next_Remarks').value || '';
  const FLLW_Status = document.getElementById('FLLW_Status').value || '';
  const FLLW_FIS_Status = document.getElementById('FLLW_FIS_Status').value || '';
  const FLLW_type = document.getElementById('FLLW_type').value || '';


  // Validation
  if (!FLLW_By_User) {
    alert('Please select a user.');
    return;
  }

  if (FLLW_FIS_Status.toLowerCase() !== 'dead' && FLLW_FIS_Status.toLowerCase() !== 'waste') {
    if (!FLLW_Next_Date) {
      alert('Please select the next follow-up date.');
      return;
    }

    if (!FLLW_Next_Time) {
      alert('Please select the next follow-up time.');
      return;
    }
  }

  // CSRF Token (if needed)
  //const csrfToken = $('meta[name="csrf-token"]').attr('content');

  $.ajax({
    url: usePath + "information_list/ajax_process",
    type: "POST",
    // headers: {
    //   'X-CSRF-Token': csrfToken // Include CSRF token if required
    // },
    data: {
      FLLW_fis_id,
      FLLW_By_User,
      FLLW_Date,
      FLLW_time,
      FLLW_Next_Date,
      FLLW_Next_Time,
      FLLW_Next_Remarks,
      FLLW_Status,
      FLLW_FIS_Status,
      FLLW_type,
      identity: "FOLLOWUP"
    },
    success: function (resp) {
      if (resp.status) {
        showToast("success", resp.message);
        // Close the modal
        const modal = bootstrap.Modal.getInstance(document.getElementById('followUpModal'));
        modal.hide();
        //location.reload(); 
        window.location.reload();

      } else {
        showToast("error", resp.message);
      }
    },
    error: function (xhr, status, error) {
      console.error('AJAX Error:', status, error);
      showToast("error", "An error occurred while processing the request.");
    },
    cache: false
  });
}

function saveTransferAssignee() {
  const usePath = $.trim($("#rootXPath").val());
  const transfer_fis_id = $("#transfr_fis_id").val();
  const current_assignee_id = document.getElementById('current_assigne_id').value || '';
  const new_assignee = document.getElementById('new_assignee').value || '';
  const transfer_date = document.getElementById('transfer_date').value || '';
  const transfer_time = document.getElementById('transfer_time').value || '';
  const remarks = document.getElementById('remarks').value || '';
  const assignee_type = document.getElementById('assignee_type').value || '';

  // Validation
  if (!new_assignee) {
    showToast("error", 'Please select a user to assign.');
    return;
  }
  if (current_assignee_id === new_assignee) {
    showToast("error", 'Please select a different user to assign.');
    return;
  }
  if (!transfer_date) {
    showToast("error", 'Transfer date is required.');
    return;
  }
  if (!transfer_time) {
    showToast("error", 'Transfer time is required.');
    return;
  }

  // Perform AJAX request
  $.ajax({
    url: usePath + "information_list/ajax_process",
    type: "POST",
    data: {
      transfer_fis_id,
      current_assignee_id,
      new_assignee,
      transfer_date,
      transfer_time,
      remarks,
      assignee_type,
      identity: "TRANSFER"
    },
    success: function (resp) {
      if (resp.status) {
        showToast("success", resp.message);

        // Optionally close the modal
        const modal = bootstrap.Modal.getInstance(document.getElementById('transferModal'));
        if (modal) modal.hide();

        // Reload the page or refresh data
        window.location.reload();
      } else {
        showToast("error", resp.message);
      }
    },
    error: function (xhr, status, error) {
      console.error('AJAX Error:', status, error);
      showToast("error", "An error occurred while processing the request.");
    },
    cache: false
  });
}

function get_fis_id_followup(id) {
  $("#FLLW_fis_id").val(id);
}

function share_this_lead(id,venue_id,user_id){
    $("#share_id").val(id);
    $("#venue_id").val(venue_id);
    $("#venue_id").val(venue_id);

}

function get_fis_detals(id) {
  $("#FIS_id").val(id);
}

function get_fis_id_transfr(id,user,username) {
  $("#transfr_fis_id").val(id);
  $("#current_assigne_id").val(user);
  $("#current_assigne").val(username);
}

function view_fis_details(id) {
  var usePath = $.trim($("#rootXPath").val());

  // Set hidden field value
  $("#view_fis_id").val(id);

  $.ajax({
      url: `${usePath}information_list/ajax_process`,
      type: "POST",
      data: {
          fis_id: id,
          identity: "VIEWFIS"
      },
      success: function (resp) {
          if (resp.status) {
              // Update modal content and show modal
              $("#viewDetailsModal .modal-body").html(resp.data);
              $("#viewDetailsModal").modal("show");

              // Optional: Display success notification
              // showToast("success", resp.message);
          } else {
              // Show error message
              showToast("error", resp.message);
          }
      },
      error: function () {
          // Show generic error message
          showToast("error", "An error occurred while processing the request.");
      },
      cache: false
  });
}

function get_items_details(id, entry_num,ck) {
  var usePath = $.trim($("#rootXPath").val());
  currentPrepidIndex = ck; // store globally

  // Set hidden field values
  $("#fis_entryno").val(entry_num);
  $("#vmid_cater_dtl_id").val(id);

  // Get values from hidden fields
  const vmid_cater_dtl_id = $("#vmid_cater_dtl_id").val();
  const vmid_cater_entry_num = $("#fis_entryno").val();

  $.ajax({
    url: usePath + "information_list/ajax_process",
    type: "POST",
    data: { 
      vmid_cater_dtl_id: vmid_cater_dtl_id, 
      vmid_cater_entry_num: vmid_cater_entry_num, 
      identity: "SELECTITEMLIST" 
    },
    async: false,
    success: function (resp) {
      if (resp.status) {
        // Populate the table with response data
        $("#item_grid").html(resp.data);
        //showToast("success", resp.message);
      } else {
        showToast("error", resp.message);
      }
    },
    error: function () {
      showToast("error", "An error occurred while processing the request.");
    },
    cache: false
  });
}





function followup_lead_status(){
  var usePath = $.trim($("#rootXPath").val());
  var lead_status = $.trim($("#FLLW_FIS_Status").val());

  $.ajax({
    url: `${usePath}information_list/ajax_process`,
    type: 'POST',
    data: {
      lead_status: lead_status,
      identity: "FLLWUPSTATUS"
    },
    success: function (resp) {
      var sdata = resp.data;
      var mhtml = '<option value="">--Select--</option>';
      if (sdata.length > 0) {
        $.each(sdata, function (key, leds) {
          mhtml += '<option value="' + leds.followup_status + '">' + leds.followup_status + '</option>';
        });
      } else {
        mhtml += '<option value="">No available</option>';
      }
      $("#FLLW_Status").html(mhtml);
    },
    error: function () {
      showToast("error", "Failed to fetch venue locations. Please try again.");
    },
    cache: false
  });
}

function share_the_selected_leads(){
    var usePath = $.trim($("#rootXPath").val());
    var share_id = $.trim($("#share_id").val());
    var selected_users = [];
    var selected_venues = [];
$(".venue-user-table .venue-user-checkbox:checked").each(function () {
  const row = $(this).closest("tr");
  const userId = row.find(".user-id-field").val();
  const venueId = $(this).data("venue");

  selected_users.push(userId);
  selected_venues.push(venueId);
});
  $.ajax({
      url: `${usePath}information_list/ajax_process`,
      type: "POST",
      data: {
          share_id: share_id,
          selected_venues: selected_venues,
          selected_users: selected_users,
          identity: "SHARELEAD"
      },
      success: function (resp) {
          if (resp.status) {
              // Update modal content and show modal
        showToast("success", resp.message);

        // Optionally close the modal
        const modal = bootstrap.Modal.getInstance(document.getElementById('shareDetailsModal'));
        if (modal) modal.hide();

        // Reload the page or refresh data
        window.location.href = window.location.origin + window.location.pathname;
      } else {
        showToast("error", resp.message);
      }
      },
      error: function () {
          // Show generic error message
          showToast("error", "An error occurred while processing the request.");
      },
      cache: false
  });
}

function same_venue_check() {
  var usePath = $("#rootXPath").val();
  var venue_id = $("#venue_id").val();  // get currently selected dept
var user_id =  $("#user_id").val(); 
  $.ajax({
    url: usePath + "information_list/ajax_process",
    type: 'POST',
    data: {
      'identity': 'SAMEVENUECHECK',
      'venue_id': venue_id,
      'user_id' : user_id
    },
    async: false,
    success: function (resp) {
      if (resp.status === 'success') {
 
      } else {
      }
    },
    error: function (textStatus, errorThrown) {
      alert("Facing technical issue!");
    },
    cache: false
  });
}

$(document).on('change', '.venue-user-checkbox', function () {
    const selectedVenueId = $("#venue_id").val(); // Current record's venue
    const currentCheckboxVenue = $(this).data('venue'); // Selected checkbox's venue ID

    // Count how many checkboxes have the same venue ID
    let sameVenueCount = $(".venue-user-checkbox:checked").filter(function () {
        return $(this).data("venue") == currentCheckboxVenue;
    }).length;

    // Rule 1: Don't allow same venue to be selected multiple times
    if (sameVenueCount > 1) {
        alert("This venue has already been selected with a different user!");
        $(this).prop('checked', false);
        return;
    }

    // Rule 2: Don't allow current venue to be selected
    if (currentCheckboxVenue == selectedVenueId) {
        alert("You cannot select the same venue as the current one.");
        $(this).prop('checked', false);
        return;
    }
});


function changeMenuList(){  
  var vmid_group = $("#vmid_group").val();
  var vmid_title = $("#vmid_title").val();
  var vmid_item=$("#vmid_item").val();
  // var fee_sem=$("#fee_sem").val();
  setTimeout(function(){ show_list(vmid_group,vmid_title,vmid_item);},500);
}

function show_list(vmid_group,vmid_title,vmid_item) {
  var usePath = $("#rootXPath").val();
  var formData = new FormData();
  var vmid_group      = $.trim( $("#vmid_group").val() );
  var vmid_title      = $.trim( $("#vmid_title").val() );
  var vmid_item      = $.trim( $("#vmid_item").val() );
  var vmid_cater_entry_num = $.trim($("#fis_entryno").val());
  var vmid_cater_dtl_id = $.trim($("#fis_function_type"+currentPrepidIndex).val());

  formData.append("identity", "MENULISTSEARCH");
  formData.append("vmid_group", vmid_group);
  formData.append("vmid_title", vmid_title);
  formData.append("vmid_item", vmid_item);
  formData.append("vmid_cater_entry_num", vmid_cater_entry_num);
  formData.append("vmid_cater_dtl_id", vmid_cater_dtl_id);


  $.ajax({
    url: usePath + "lead_department/ajax_process",
    type: 'POST',
    data: formData,
    processData: false,
    contentType: false,
    success: function(resp) {
      if (resp.status) {
        //clear_fee_fields();
        $("#item_grid").html(resp.data);
      } else {
        //showToaster( resp.message);
        $("#item_grid").html('<tr><td colspan="4">No record(s) found.</td></tr>');
      }
    },
    error: function(xhr, status, error) {
      showToast('error', "An error occurred :" + error);
    }
  });

}

  $(document).on("click","#vmid_title_display",function(){
    $("#sidebar-menu-toggle2").toggle();
  });
  
  function close_profile_checkbox2(){
    $("#sidebar-menu-toggle2").hide();
    }
    
    $(document).on('click', function (e) {
        // Check if the click is outside the input box or sidebar menu
        if (!$(e.target).closest('#vmid_title_display, #sidebar-menu-toggle2').length) {
            $("#sidebar-menu-toggle2").hide();
        }
    });
  
function get_selected_item_val2(){
  var selectedValues = [];
  var postype = [];
  var displayNames = [];

  if( $("input[name='post_type_select2[]']").is(":checked") ){
    $("input[name='post_type_select2[]']:checked").each(function(){
      postype.push($(this).attr("id"));
      selectedValues.push($(this).val());

      var groupName = $(this).closest('li').find('span.float-left').text().trim();
      displayNames.push(groupName);
    });
  }

  if( selectedValues.length > 0 ){
    $("#vmid_title").val(postype.join(","));
    $("#vmid_title_display").val(displayNames.join(", "));
  }else{
    $("#vmid_title").val('');
    $("#vmid_title_display").val('');
  }

    get_selected_group_items();
  changeMenuList();
}

  $(document).on("click","#vmid_group_display",function(){
    $("#sidebar-menu-toggle").toggle();
  });
  
  function close_profile_checkbox(){
    $("#sidebar-menu-toggle").hide();
    }
    
    $(document).on('click', function (e) {
        // Check if the click is outside the input box or sidebar menu
        if (!$(e.target).closest('#vmid_group_display, #sidebar-menu-toggle').length) {
            $("#sidebar-menu-toggle").hide();
        }
    });
  
function get_selected_item_val(){
  var selectedValues = [];
  var postype = [];
  var displayNames = [];

  if( $("input[name='post_type_select[]']").is(":checked") ){
    $("input[name='post_type_select[]']:checked").each(function(){
      postype.push($(this).attr("id"));
      selectedValues.push($(this).val());

      var groupName = $(this).closest('li').find('span.float-left').text().trim();
      displayNames.push(groupName);
    });
  }

  if( selectedValues.length > 0 ){
    $("#vmid_group").val(postype.join(","));
    $("#vmid_group_display").val(displayNames.join(", "));
  }else{
    $("#vmid_group").val('');
    $("#vmid_group_display").val('');
  }

    get_selected_group_titles();
  changeMenuList();
}


  $(document).on("click","#vmid_item_display",function(){
    $("#sidebar-menu-toggle3").toggle();
  });
  
  function close_profile_checkbox3(){
    $("#sidebar-menu-toggle3").hide();
    }
    
    $(document).on('click', function (e) {
        // Check if the click is outside the input box or sidebar menu
        if (!$(e.target).closest('#vmid_item_display, #sidebar-menu-toggle3').length) {
            $("#sidebar-menu-toggle3").hide();
        }
    });
  
function get_selected_item_val3(){
  var selectedValues = [];
  var postype = [];
  var displayNames = [];

  if( $("input[name='post_type_select3[]']").is(":checked") ){
    $("input[name='post_type_select3[]']:checked").each(function(){
      postype.push($(this).attr("id"));
      selectedValues.push($(this).val());

      var groupName = $(this).closest('li').find('span.float-left').text().trim();
      displayNames.push(groupName);
    });
  }

  if( selectedValues.length > 0 ){
    $("#vmid_item").val(postype.join(","));
    $("#vmid_item_display").val(displayNames.join(", "));
  }else{
    $("#vmid_item").val('');
    $("#vmid_item_display").val('');
  }

  get_selected_items_type();
    // changeMenuList();

}

function reset_menu_items_details(){
  $("#vmid_group").val('');
  $("#vmid_title").val('');
  $("#vmid_item").val('');
  $("#vmid_group_display").val('')
  $("#vmid_title_display").val('');
  $("#vmid_item_display").val('') ;
  $("#vmid_footer_id").val('');
  $("#vmid_cater_entry_num").val('')
  $("#vmid_cater_dtl_id").val('');
    $("input[name='post_type_select[]']").prop("checked", false);

  // Uncheck all checkboxes in the title section
  $("input[name='post_type_select2[]']").prop("checked", false);

  // Uncheck all checkboxes in the item section
  $("input[name='post_type_select3[]']").prop("checked", false);
  get_selected_group_titles();
  get_selected_group_items();
  get_selected_items_type();
}

function save_item_list() {
  var usePath              = $.trim( $("#rootXPath").val() );
  var formData             = new FormData();
  var other_data           = $('form#myforms').serializeArray();
  var mid                  = $.trim( $("#itemId").val() );
  var menu_description      = $.trim( $("#menu_description").val() );
  var menu_type    = $.trim( $("#menu_type").val() );
  var vmid_group      = $.trim( $("#vmid_group").val() );
  var mld_title      = $.trim( $("#mld_title").val() );
  var mld_item      = $.trim( $("#mld_item").val() );
  var mld_type      = $.trim( $("#mld_type").val() );
  var menu_id                = $.trim( $("#mid").val() );

 if( mid_group == ''){
    showToast("error","Group is required.");
    setTimeout(function(){ set_global_focus('mid_group');},500);
    return false;
  }
  formData.append("identity", "ADDITEM");
  formData.append("itemId", mid);
  formData.append("mid", menu_id);

  $.each(other_data,function(key,input){
    formData.append(input.name,input.value);
  });
  $(".no_loader").removeClass("hidden").addClass("hidden");
  $(".loader").removeClass("hidden");     
  setTimeout(function(){
    $.ajax({
           url: usePath+"menu_list/ajax_process",
           type: 'POST',
           data: formData,
           async: false,
           contentType: false,
           processData: false,
           success: function (resp) {               
              if( resp.status ){         

                $("#item_grid").html(resp.data);
                $(".no_loader").removeClass("hidden");
                $(".loader").removeClass("hidden").addClass("hidden"); 
                showToast("success",resp.message); 
                // window.location = usePath+"menu_list/add_menu/"+menu_id;
                setTimeout(function(){ reset_menu_grid_afteradd();},500);         
                       

              }else{
                  $(".no_loader").removeClass("hidden");
                  $(".loader").removeClass("hidden").addClass("hidden");     
                  $(".process_qualif_save").show();
                  showToast("error",resp.message); 
                
              }
           },
           error: function () {
            $(".no_loader").removeClass("hidden");
            $(".loader").removeClass("hidden").addClass("hidden");     
           },
           cache: false
   });

  },500);

}

function delete_menu_item(menuitemid) {
  const usePath = $("#rootXPath").val();
  var vmid_cater_entry_num = $.trim($("#vmid_cater_entry_num").val());
  var vmid_cater_dtl_id = $.trim($("#vmid_cater_dtl_id").val());

  if (confirm("Are you sure you want to delete this record ?")) {
      $.ajax({
          url: `${usePath}information_list/ajax_process`,
          type: 'POST',
          data: {
            menuitemid: menuitemid,
              vmid_cater_entry_num: vmid_cater_entry_num,
              vmid_cater_dtl_id: vmid_cater_dtl_id,
              identity: 'DELETEMENUITM'
          },
          success: function (resp) {
              if (resp.status) {
                  // Update the UI with new data
                  $("#item_grid").html(resp.data);

                  // $("#func_info_list").html(resp.fisdtl);

                  // Show success toast
                  showToast("success", resp.message);
              } else {
                  // Handle failure response
                  $(".no_loader").addClass("hidden");
                  $(".loader").addClass("hidden");
                  $(".process_qualif_save").show();

                  // Show error toast
                  showToast("error", resp.message);
              }
          },
          error: function () {
              // Handle request failure
              $(".unprocess_loader").removeClass("hidden");
              $(".process_loader").addClass("hidden");

              showToast("error", "An error occurred while processing your request.");
          },
          cache: false
      });
  }
}

function save_menu_items_to_list() {
  var usePath = $.trim($("#rootXPath").val());
  var prepid = $.trim($("#prepid").val());
  var vmid_cater_entry_num = $.trim($("#fis_entryno").val());
  var vmid_cater_dtl_id = $.trim($("#fisd_function_type"+currentPrepidIndex).val());
  var vmid_group = $.trim($("#vmid_group").val()).split(",");
  var vmid_title = $.trim($("#vmid_title").val()).split(",");
  var vmid_item = $.trim($("#vmid_item").val()).split(",");
  // var ado_amount = $.trim($("#ado_amount").val());
  var vmid_footer_id = $.trim($("#vmid_footer_id").val());
  // var addtype = $.trim($("#addtype").val());
  var fisd_menu = $.trim($("#fisd_menu").val());
    $.ajax({
      url: usePath+"information_list/ajax_process",
      type: 'POST',
      data: { 'vmid_cater_entry_num': vmid_cater_entry_num, 'vmid_cater_dtl_id': vmid_cater_dtl_id,'vmid_group[]': vmid_group, 'vmid_title[]': vmid_title,'vmid_item[]': vmid_item, 'fisd_menu':fisd_menu,'vmid_footer_id':vmid_footer_id,'identity': 'ADDMENUITEM' },
      async: false,
      success: function (resp) {
        if( resp.status ){         

          $("#item_grid").html(resp.data);
          $("#vmid_footer_id").html(resp.footerid);
        
          // $("#func_info_list").html(resp.fisdtl);
          showToast("success",resp.message); 
          // refreshTotalAmount();

          setTimeout(function(){ reset_menu_items_details();},500);         

        }else{

            $(".process_qualif_save").show();

            showToast("error",resp.message); 

        }
       
      },
      error: function () {
        $(".unprocess_loader").addClass("hidden");
        $(".process_loader").removeClass("hidden");
      },
      cache: false
    });
 
}

function get_selected_group_titles(){
  var usePath = $.trim($("#rootXPath").val());
  var mld_group = $.trim($("#vmid_group").val()).split(",");

  $.ajax({
    url: usePath + "lead_department/ajax_process",
    type: 'POST',
    data: {'mld_group[]': mld_group, 'identity': 'GETITLES'},
    async: false,
    success: function (resp) {
      var sdata = resp.data;
      var html = '';

      if(sdata.length > 0){
        $.each(sdata, function(index, item){
          html += '<li style="display:flex;">' +
                    '<div style="width: 100%;">' +
                      '<span class="float-left">' + item.tc_title_counter + '</span>' +
                      '<span class="float-right">' +
                        '<input type="checkbox" onclick="get_selected_item_val2();" name="post_type_select2[]" id="' + item.id + '" value="' + item.id + '" style="width: 20px;height: 18px;" />' +
                      '</span>' +
                    '</div>' +
                  '</li>';
        });
      } else {
        html = '<li><div>No titles available</div></li>';
      }

      // Add Close button again at the end
      html += '<li class="mt5 mr5" style="display: flex;">' +
                '<div style="width: 100%;">' +
                  '<span class="float-left"></span>' +
                  '<span class="float-right" onclick="close_profile_checkbox2();">' +
                    '<button type="button" title="Close" class="btn-close" aria-label="Close"></button>' +
                  '</span>' +
                '</div>' +
              '</li>';

          $("#process_specification2").html(html); // Replace full UL content
        },
        error: function () {
          console.error("Error fetching titles");
        },
        cache: false
      });
    }


function get_selected_group_items() {
  var usePath   = $.trim($("#rootXPath").val());
  var mld_group = $.trim($("#vmid_group").val()).split(",");
  var mld_title = $.trim($("#vmid_title").val()).split(",");

  $.ajax({
    url: usePath + "lead_department/ajax_process",
    type: 'POST',
    data: { 'mld_group[]': mld_group, 'mld_title[]': mld_title, 'identity': 'GETITEMS' },
    async: false,
    success: function(resp) {
      var sdata = resp.data;
      var html = '<option value="">-Select-</option>';

      if(sdata.length > 0){
        $.each(sdata, function(index, item){
          html += '<li style="display:flex;">' +
                    '<div style="width: 100%;">' +
                      '<span class="float-left">' + item.mi_item + '</span>' +
                      '<span class="float-right">' +
                        '<input type="checkbox" onclick="get_selected_item_val3();" name="post_type_select3[]" id="' + item.id + '" value="' + item.id + '" style="width: 20px;height: 18px;" />' +
                      '</span>' +
                    '</div>' +
                  '</li>';
        });
      } else {
        html = '<li><div>No titles available</div></li>';
      }
      // Add Close button again at the end
      html += '<li class="mt5 mr5" style="display: flex;">' +
                '<div style="width: 100%;">' +
                  '<span class="float-left"></span>' +
                  '<span class="float-right" onclick="close_profile_checkbox3();">' +
                    '<button type="button" title="Close" class="btn-close" aria-label="Close"></button>' +
                  '</span>' +
                '</div>' +
              '</li>';

          $("#process_specification3").html(html);
    },
    error: function() { console.log("Error fetching items"); },
    cache: false
  });
}

function get_selected_items_type() {
  var usePath   = $.trim($("#rootXPath").val());
  var mld_group = $.trim($("#vmid_group").val()).split(",");
  var mld_title = $.trim($("#vmid_title").val()).split(",");
  var mld_item = $.trim($("#vmid_item").val()).split(",");

  $.ajax({
    url: usePath + "lead_department/ajax_process",
    type: 'POST',
    data: { 'mld_group[]': mld_group, 'mld_title[]': mld_title, 'mld_item[]': mld_item, 'identity': 'GETTYPE' },
    async: false,
    success: function(resp) {
      var sdata = resp.data;
      var inputValue = "";

      if (sdata.length > 0) {
        inputValue = sdata[0].mi_type; // Assuming first item is the default value
      }
      
      $("#vmid_type").val(inputValue);
    },
    error: function() { console.log("Error fetching items"); },
    cache: false
  });
}

  function search_additional_remarks() {
    var usePath = $.trim($("#rootXPath").val());
    var fis_addtional_remrks = $.trim($("#fis_addtional_remrks").val());

  if (fis_addtional_remrks !== '') {
        $(".load_employee").removeClass("hidden");

        setTimeout(function () {
            $.ajax({
                url: usePath + "information_list/ajax_process",
                type: 'POST',
                data: {
                    'requestcode': '',
                    'additional_remarks_fis': fis_addtional_remrks,
                    'requesttype': 'CODE',
                    'identity': 'ADDREMARKSEARCH'
                },
                async: false,
                success: function (resp) {
                    $(".load_employee").addClass("hidden");
                    var nhtml = '';

                    if (resp.status) {
                        nhtml += '<select id="new_remarks_select" onchange="selected_my_remarks_list(this.value);"><option value="">-Select-</option>';
                        var sdata = resp.data;

                        if (sdata.length > 0) {
                            $.each(sdata, function (key, leds) {
                                nhtml += `<option value="${leds.fis_addtional_remrks}">${leds.fis_addtional_remrks}</option>`;
                            });
                        }

                        nhtml += '</select>';
                    }

                    $("#additional_remarks_fis").html(nhtml);
                },
                error: function () {
                    $(".load_employee").addClass("hidden");
                },
                cache: false
            });
        }, 500);
    }
}

function selected_my_remarks_list(val){            
    var nstr         = val.split(",");
    for(var i = 0; i < nstr.length; i++) {
       nstr[i] = nstr[i].replace(/'/g, "");
    }   
     if( nstr[0] =='null' ){
         nstr[0] = '';
     }
     if( nstr[1] =='null' ){
         nstr[1] = '';
     }
     $("#fis_addtional_remrks").val(nstr[0]);
     $("#additional_remarks_fis").html('');
}



function open_forward_lead_modal(leadno){
          $('#contractno').val(leadno); 
          $('#display_contractno').text(leadno); 
}


  function get_department_users() {
    var usePath = $.trim($("#rootXPath").val());
    var departmnet = $.trim($("#forward_to").val());

  if (departmnet !== '') {
        $(".show_loader").removeClass("hidden");
        $(".no_loader").removeClass("hidden").addClass("hidden");
        setTimeout(function () {
            $.ajax({
                url: usePath + "contract_venue_list/ajax_process",
                type: 'POST',
                data: {
                    'departmnet': departmnet,
                    'requesttype': 'CODE',
                    'identity': 'GETDEPTUSERS'
                },
                async: false,
                success: function (resp) {
                    $(".show_loader").removeClass("hidden").addClass("hidden");
                    $(".no_loader").removeClass("hidden");
                    var nhtml = '';

                    if (resp.status) {
                        nhtml += '<select class="form-select"><option value="">-Select-</option>';

                        var sdata = resp.data;

                        if (sdata.length > 0) {
                            $.each(sdata, function (key, leds) {
                                nhtml += `<option value="${leds.id}">${leds.username}</option>`;
                            });
                        }

                        nhtml += '</select>';
                    }

                    $("#forward_to_user").html(nhtml);
                },
                error: function () {
                    $(".show_loader").removeClass("hidden").addClass("hidden");
                    $(".no_loader").removeClass("hidden");
                },
                cache: false
            });
        }, 500);
    }
}



function forward_to_departments() {
    var usePath = $.trim($("#rootXPath").val());
    var contractno = $.trim($("#contractno").val());
    var departmnet = $.trim($("#forward_to").val());
    var userid = $.trim($("#forward_to_user").val());

if (!departmnet ) {
   showToast("info","Select Department you want to forward this contract to ");
   $("#forward_to").focus();
   return false;
  }

    // Show the loader
    $(".process_loader_table").show();

    $.ajax({
        url: usePath + "information_list/ajax_process",
        type: 'POST',
        data: { 'identity': 'FORWARD', 'contractno':contractno , 'departmnet' : departmnet, 'userid' : userid},
        success: function (resp) {
          if (resp.status) {
            showToast("success", resp.message);
          if (departmnet.toLowerCase() === "venue") {
            alert("Contract forwarded to Venue Department!");
          } else if (departmnet.toLowerCase() === "catering") {
            alert("Contract forwarded to Catering Department!");
          } else if (departmnet.toLowerCase() === "entertainment") {
            alert("Contract forwarded to Entertainment Department!");
          }            
            const modal = bootstrap.Modal.getInstance(document.getElementById('forwardToDeptModal'));
            modal.hide();
            //location.reload(); 
            window.location.reload();

          } else {
            alert(resp.message);
            showToast("error", resp.message);
          }
        },
        error: function () {
            alert("An error occurred while processing the request.");
        },
        complete: function () {
            // Hide the loader when done
            $(".process_loader_table").hide();
        },
        cache: false
    });
}
