$(document).ready(function(){
  flatpickr("#fp_event_date", {
    dateFormat: "d-M-Y",
    allowInput: true,
    onOpen: function (selectedDates, dateStr, instance) {
      instance.setDate(instance.input.value, false);

    },
  });
});


function get_contracts() {
    var usePath = $.trim($("#rootXPath").val());
    var department = $.trim($("#fp_dept").val());

    $.ajax({
        url: usePath + "contract_transaction_list/ajax_process",
        type: 'POST',
        data: { 'department': department, 'identity': 'DEPTCHANGE' },
        async: false,
        success: function (resp) {
            if (resp.status) {
                var contractDropdown = $("#fp_contract_no");
                contractDropdown.empty();
                contractDropdown.append('<option value="">-Select-</option>');

                $.each(resp.data, function (index, contract) {
                    var label = contract.entry_no + ' - ' + contract.guest_name + ' (' + contract.contact_no + ')';
                    contractDropdown.append('<option value="' + contract.entry_no + '">' + label + '</option>');
                });
            } else {
                alert("No contracts found for selected department.");
            }
        },
        error: function () {
            alert("Error while fetching contracts.");
        },
        cache: false
    });
}


function get_functions() {
    var usePath = $.trim($("#rootXPath").val());
    var contractno = $.trim($("#fp_contract_no").val());
    var department = $.trim($("#fp_dept").val());

    $.ajax({
        url: usePath + "contract_transaction_list/ajax_process",
        type: 'POST',
        data: { 'contractno': contractno,  'department': department, 'identity': 'CONTRACTCHANGE' },
        async: false,
        success: function (resp) {
            if (resp.status) {
                var functionDropdown = $("#fp_function_type");
                functionDropdown.empty();
                functionDropdown.append('<option value="">-Select-</option>');

                $.each(resp.data, function (index, functiontype) {
                    functionDropdown.append('<option value="' + functiontype.function_id + '">' + functiontype.function_type + '</option>');
                });
             
            } else {
                alert("No functions found for selected contract.");
              
            }
        },
        error: function () {
            alert("Error while fetching contracts.");
        },
        cache: false
    });
}


function print_fp(){

  var usePath       = $.trim( $("#rootXPath").val() );
  var fp_evnt_dte   = $.trim($("#fp_event_date").val());
  var fp_dept       = $.trim($("#fp_dept").val());
  var fp_cont_no    = $.trim($("#fp_contract_no").val());
  var fp_func_type  = $.trim($("#fp_function_type").val());
  var fp_notes      = $.trim($("#fp_notes").val());
  var fp_cheff_attn = $.trim($("#fp_cheff_attn").val());
  var fp_assign_to   = $.trim($("#fp_assign_to").val());
  var fp_created_by = $.trim($("#fp_created_by").val());

  var printurl     = $.trim( $("#printexceled").attr("rel") );

  if(fp_evnt_dte == ''){
    showToast('error',"Date is required");
    return false;
  }
  if(fp_dept == ''){
    showToast('error',"Department is required.");
    return false;
  }
  if(fp_cont_no == ''){
    showToast('error',"Contract no is required.");
    return false;
  }
 if(fp_func_type == ''){
    showToast('error',"Function Type is required.");
    return false;
  }
  

   $.ajax({

               url: usePath+"generate_fp/ajax_process",

               type: 'POST',

               data: {'fp_evnt_dte':fp_evnt_dte,'fp_dept':fp_dept,'fp_cont_no':fp_cont_no,'fp_func_type':fp_func_type,'fp_notes':fp_notes,'fp_cheff_attn':fp_cheff_attn,'fp_assign_to':fp_assign_to,'fp_created_by':fp_created_by,'identity':'PRNTFP'},

               async: false,

               success: function (resp) {

                    if(resp.status){
                        showToast('success', resp.message);   // use resp.message, not message
                        window.open(printurl, '_blank');
                    }else{
                        showToast('warning', resp.message || "No record(s) found.");
                        return false;
                    }

               },

               error: function () {

                  showToast('error', "Something went wrong.");

               },

               cache: false

       });


}


