    $("#search_venue_contract").on("keypress", function(e) {
    if (e.which === 13) { // 13 = Enter key
        e.preventDefault();
        search_venue_contract_list_filter();
    }
});


  function search_and_fill() {
    var usePath = $.trim($("#rootXPath").val());
    var fis_client_mobile = $.trim($("#fisc_client_mobile").val());

  if (fis_client_mobile !== '') {
        $(".show_loader").removeClass("hidden");
        $(".no_loader").removeClass("hidden").addClass("hidden");
        setTimeout(function () {
            $.ajax({
                url: usePath + "contract_venue_list/ajax_process",
                type: 'POST',
                data: {
                    'requestcode': '',
                    'contact_no': fis_client_mobile,
                    'requesttype': 'CODE',
                    'identity': 'SEARCHANDFILL'
                },
                async: false,
                success: function (resp) {
                    $(".show_loader").removeClass("hidden").addClass("hidden");
                    $(".no_loader").removeClass("hidden");
                    var nhtml = '';

                    if (resp.status) {
                        nhtml += '<select id="new_search_and_fill_select" onchange="selected_my_contact_list(this.value); "><option value="">-Select-</option>';
                        var sdata = resp.data;

                        if (sdata.length > 0) {
                            $.each(sdata, function (key, leds) {
                                nhtml += `<option value="${leds.fis_client_mobile},${leds.fis_entryno}">${leds.fis_entryno}-${leds.fis_guest_name}-${leds.fis_client_mobile}</option>`;
                            });
                        }

                        nhtml += '</select>';
                    }

                    $("#contact_no").html(nhtml);
                },
                error: function () {
                    $(".show_loader").removeClass("hidden").addClass("hidden");
                    $(".no_loader").removeClass("hidden");
                },
                cache: false
            });
        }, 500);
    }
}

$(document).ready(function(){
  flatpickr("#fisc_contract_date", {
    dateFormat: "d-M-Y",
    allowInput: false,        
    minDate: new Date().fp_incr(-3),        
    maxDate: "today",
    onOpen: function (selectedDates, dateStr, instance) {
      instance.setDate(instance.input.value, false);
    },
  });
});

function selected_my_contact_list(val){            
    var nstr         = val.split(",");
    for(var i = 0; i < nstr.length; i++) {
       nstr[i] = nstr[i].replace(/'/g, "");
    }   
     if( nstr[0] =='null' ){
         nstr[0] = '';
     }
     if( nstr[1] =='null' ){
         nstr[1] = '';
     }
     $("#fisc_client_mobile").val(nstr[0]);
     $("#venue_entry_no").val(nstr[1]);
     $("#contact_no").html('');
     setTimeout(function(){ search_filter_venue_contact();},500);
}
   
$(document).ready(function() {
  $('#client_search').select2({
    placeholder: "-Select-",
    allowClear: true,
    width: 'resolve' 
  });
  
   $('#client_search').on('select2:open', function () {
    $('.select2-search__field').focus();
  });
  
});
   
    function search_filter_venue_contact() {
    var usePath = $.trim($("#rootXPath").val());
    var venue_entry_no = $.trim($("#venue_entry_no").val());
  
    if (venue_entry_no !== '') {
        $(".show_loader").removeClass("hidden");
        $(".no_loader").removeClass("hidden").addClass("hidden");  
        setTimeout(function () {
            $.ajax({
                url: usePath + "contract_venue_list/ajax_process",
                type: 'POST',
                data: {
                    'fis_entryno': venue_entry_no,
                    'requesttype': 'CODE',
                    'identity': 'VENUECONTACT'
                },
                
                async: false,
                dataType: 'json',
                success: function (resp) {
                    $(".show_loader").removeClass("hidden").addClass("hidden");
                    $(".no_loader").removeClass("hidden");
                    if (resp.status) {
                        var sdata = resp.data;
                        $("#venue_entry_no").val(sdata.fis_entryno);
                        $("#fisc_guest_name").val(sdata.fis_guest_name);
                        $("#fisc_address").val(sdata.fis_address);
                        $("#fisc_state").val(sdata.fis_state);
                        $("#fisc_city").val(sdata.fis_city);
                        $("#fisc_pin").val(sdata.fis_pin);
                        $("#fisc_client_email").val(sdata.fis_client_email);
                        $("#fisc_enq_mode").val(sdata.fis_enq_mode);
                        $("#fisc_proposal").val(sdata.fis_proposal);
                        $("#fisc_total_amt").val(sdata.fis_total_amt);
                        $("#fisc_cash_part").val(sdata.fis_cash_part);
                        $("#fisc_cheque").val(sdata.fis_cheque);
                        if (sdata.fisc_food_tax == "Y") {
                          $("#fisc_food_tax").prop("checked", true);
                        } else {
                          $("#fisc_food_tax").prop("checked", false);
                        }
                      $("#fisc_tax_c_amt").val(sdata.fis_tax_c_amt);
                      $("#fisc_tax_d_amt").val(sdata.fis_tax_d_amt);
                      $("#fisc_tax_percent_c").val(sdata.fis_tax_percent_c);
                      $("#fisc_tax_percent_d").val(sdata.fis_tax_percent_d);
                      $("#fisc_food_taste_no").val(sdata.fis_food_taste_no);
                      $("#fisc_factor_0").val(sdata.fis_factor_0);

                        $("#fisc_tax_percent").val(sdata.fis_tax_percent);
                        $("#fisc_tax_amt").val(sdata.fis_tax_amt);
                        $("#fisc_net_amt").val(sdata.fis_net_amt);
                        $("#fisc_advance_cash").val(sdata.fis_advance_cash);
                        $("#fisc_advance_chq").val(sdata.fis_advance_chq);
                        $("#fisc_balance").val(sdata.fis_balance);
                      $("#fisc_addtional_remrks").val(sdata.fis_addtional_remrks);
                      $("#fisc_entryby").val(sdata.fisc_entryby);
                      $("#fisc_entryby_display").val(resp.entryby_name);
                        if(resp.data2){
                          $("#venueContractdetailgrid").html(resp.data2);
                        }
                    } else {
                     
                        alert(resp.message);
                    }
                },
                error: function () {
                    
                    $(".show_loader").removeClass("hidden").addClass("hidden");
                    $(".no_loader").removeClass("hidden");
                },
                cache: false
            });
        }, 500);
    }
  }  

function alertChecked(url){
    if( confirm("Are you sure want to delete ?")){
      
        window.location = url
    }
  }

function isFloatNegativeKey(e,vls){

  if (e.charCode >= 32 && e.charCode < 127 && !/^-?\d*[.,]?\d*$/.test(vls + '' + String.fromCharCode(e.charCode)))
  {
    return false;
  }
  return true;
}

function isNumberFloatKey(evt)
{
  var charCode = (evt.which) ? evt.which : evt.keyCode;
  if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57)){
      return false;
  }
  return true;
}

function isNumberKeys(evt) {
  evt = (evt) ? evt : window.event;
  var charCode = (evt.which) ? evt.which : evt.keyCode;
  if (charCode > 31 && (charCode < 48 || charCode > 57)) {
      return false;
  }
  return true;
}


$(document).ready(function(){

  flatpickr("#from_date", {

    dateFormat: "d-M-Y",

    allowInput: true,

    onOpen: function (selectedDates, dateStr, instance) {

      instance.setDate(instance.input.value, false);

    },

  });

});

$(document).ready(function(){

  flatpickr("#upto_date", {

    dateFormat: "d-M-Y",

    allowInput: true,

    onOpen: function (selectedDates, dateStr, instance) {

      instance.setDate(instance.input.value, false);

    },

  });

});

  
  
  function search_venue_contract_list_filter(){
    var useroot = $("#rootXPath").val();
    $(".show_loader").removeClass("hidden");
    $(".no_loader").removeClass("hidden").addClass("hidden")
    $("form#myForms").attr("action",useroot+"contract_venue_list/search");
    $("form#myForms").submit();
  }
  
  
  function isFloatNegativeKey(e,vls){
  
    if (e.charCode >= 32 && e.charCode < 127 && !/^-?\d*[.,]?\d*$/.test(vls + '' + String.fromCharCode(e.charCode)))
    {
      return false;
    }
    return true;
  }
  
  function isNumberFloatKey(evt)
  {
    var charCode = (evt.which) ? evt.which : evt.keyCode;
    if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57)){
        return false;
    }
    return true;
  }
  
  function isNumberKeys(evt) {
    evt = (evt) ? evt : window.event;
    var charCode = (evt.which) ? evt.which : evt.keyCode;
    if (charCode > 31 && (charCode < 48 || charCode > 57)) {
        return false;
    }
    return true;
  }
  
  
  
  $(document).ready(function(){
  
    flatpickr("#function_date", {
  
      dateFormat: "d-M-Y",
  
      allowInput: true,
  
      onOpen: function (selectedDates, dateStr, instance) {
  
        instance.setDate(instance.input.value, false);
  
      },
  
    });
  
  });
  
  $(document).ready(function(){
  
    flatpickr("#CntrcD_Function_date", {
  
      dateFormat: "d-M-Y",
  
      allowInput: true,
  
      onOpen: function (selectedDates, dateStr, instance) {
  
        instance.setDate(instance.input.value, false);
  
      },
  
    });
  
  });
  
  function get_department_users() {
    var usePath = $.trim($("#rootXPath").val());
    var departmnet = $.trim($("#forward_to").val());

  if (departmnet !== '') {
        $(".show_loader").removeClass("hidden");
        $(".no_loader").removeClass("hidden").addClass("hidden");
        setTimeout(function () {
            $.ajax({
                url: usePath + "contract_venue_list/ajax_process",
                type: 'POST',
                data: {
                    'departmnet': departmnet,
                    'requesttype': 'CODE',
                    'identity': 'GETDEPTUSERS'
                },
                async: false,
                success: function (resp) {
                    $(".show_loader").removeClass("hidden").addClass("hidden");
                    $(".no_loader").removeClass("hidden");
                    var nhtml = '';

                    if (resp.status) {
                        nhtml += '<select class="form-select"><option value="">-Select-</option>';

                        var sdata = resp.data;

                        if (sdata.length > 0) {
                            $.each(sdata, function (key, leds) {
                                nhtml += `<option value="${leds.id}">${leds.username}</option>`;
                            });
                        }

                        nhtml += '</select>';
                    }

                    $("#forward_to_user").html(nhtml);
                },
                error: function () {
                    $(".show_loader").removeClass("hidden").addClass("hidden");
                    $(".no_loader").removeClass("hidden");
                },
                cache: false
            });
        }, 500);
    }
}


  function save_venue_contract_details(){
    var usePath = $.trim($("#rootXPath").val());
    var entry_no = $.trim($("#fisc_entryno").val());
    var fisc_addtional_remrks =  $.trim($("#fisc_addtional_remrks").val());
    var fisc_location =  $.trim($("#fisc_location").val());
    var fisc_proposal = $.trim($("#fisc_proposal").val())
    var fisc_contract_date = $.trim($("#fisc_contract_date").val())
    var fisc_total_amt = $.trim($("#fisc_total_amt").val())

  var formData = new FormData();
  var otherData = $('form#myforms').serializeArray();
  formData.append("identity", "SAVECONTRACT");
  formData.append("entry_no", entry_no);
  var fileUploaded = false;

  $("[id^='fiscd_file_']").each(function () {
    var fileInput = this;
    var file = fileInput.files[0];
    if (file !== undefined) {
      fileUploaded = true; // At least one file is uploaded
      var functionKey = $(fileInput).attr('name').match(/\[(.*?)\]/)[1]; // extract function name
      formData.append("fiscd_file[" + functionKey + "]", file);
    }
  });

 if (!fisc_addtional_remrks ) {
   showToast("error","Additional Remarks are required!");
   $("#fisc_addtional_remrks").focus();
   return false;
  }

   if (!fisc_location ) {
   showToast("error","Booking Location are required!");
   $("#fisc_location").focus();
   return false;
  }

   if (!fisc_proposal ) {
   showToast("error","Proposal is required!");
   $("#fisc_proposal").focus();
   return false;
  }

 if (fisc_total_amt === "" || parseFloat(fisc_total_amt) <= 0) {
  showToast("error", "Total Amount Cannot Be 0!");
  $("#fisc_total_amt").focus();
  return false;
 }

  var confirmMessage = `Do you want to save contract on this (${fisc_contract_date})?`;
  if (!confirm(confirmMessage)) {
   $("#fisc_contract_date").focus();
    return false; 
  }
  
  otherData.forEach((input) => {
    formData.append(input.name, input.value);
  });
    
        $(".show_loader").removeClass("hidden");
        $(".no_loader").removeClass("hidden").addClass("hidden");  
      
        $.ajax({
            url: usePath + "contract_venue_list/ajax_process",
            type: 'POST',
            data: formData,
            contentType: false,
            processData: false,
            success: function(resp){
                    $(".show_loader").removeClass("hidden").addClass("hidden");
                    $(".no_loader").removeClass("hidden");
                if(resp.status){
                  showToast("success",resp.message);
                  // window.location.href = usePath + "contract_venue_list";
                    // Optionally redirect or reload page
              let redirectPage = $.trim($("#page_redirect").val());
              let redirectURL = usePath + "contract_venue_list";
              if (redirectPage) {
                redirectURL += "?page=" + redirectPage;
              }
              window.location.href = redirectURL;
                } else {
                showToast("success",resp.message);
                 alert("Date Saved Successfully!");
		            window.location.href = usePath + "contract_venue_list";
              }
            },
            error: function(){
                $(".show_loader").removeClass("hidden").addClass("hidden");
                $(".no_loader").removeClass("hidden");
                alert("Server error occurred.");
            },
            cache: false
        });
    }  
  

function update_venue_save(){
  var usePath = $.trim($("#rootXPath").val());
  var entry_no = $.trim($("#fisc_entryno").val());
  var mid = $.trim($("#mid").val());
 // Entry No. must be in hidden field or somewhere
  var formData = new FormData();
  var otherData = $('form#myforms').serializeArray();
  formData.append("identity", "UPDATECONTRACT");
  formData.append("entry_no", entry_no);
  formData.append("mid", mid);

  otherData.forEach((input) => {
    formData.append(input.name, input.value);
  });
  
        $(".show_loader").removeClass("hidden");
        $(".no_loader").removeClass("hidden").addClass("hidden");
    
      $.ajax({
          url: usePath + "contract_venue_list/ajax_process",
          type: 'POST',
          data: formData,
          contentType: false,
          processData: false,
          success: function(resp){
                $(".show_loader").removeClass("hidden").addClass("hidden");
                $(".no_loader").removeClass("hidden");
              if(resp.status){
                showToast("success",resp.message);
                window.location.href = usePath + "contract_venue_list";
              let redirectPage = $.trim($("#page_redirect").val());
              let redirectURL = usePath + "contract_venue_list";
              if (redirectPage) {
               redirectURL += "?page=" + redirectPage;
              }
              window.location.href = redirectURL;
              } else {
                showToast("error",resp.message);
              }
          },
          error: function(){
                    $(".show_loader").removeClass("hidden").addClass("hidden");
                    $(".no_loader").removeClass("hidden");
                   alert("Server error occurred.");
          },
          cache: false
      });  
}

  function refreshTotalAmount() {
    var usePath = $.trim($("#rootXPath").val());
    var entry_no = $.trim($("#fisc_entryno").val());
  
    $.ajax({
      url: usePath + "contract_venue_list/ajax_process",
      type: "POST",
      data: { identity: "GET_TOTAL_AMOUNT", entry_no: entry_no },
      success: function (resp) {
        if (resp.total_amount !== undefined) {
          $("#fisc_total_amt").val(resp.total_amount);
          calculateDecorFinancials(); // Recalculate all dependent fields
        }
      },
      error: function () {
        console.error("Failed to fetch total amount.");
      }
    });
  }
  

function calculateDecorFinancials() {
  var totalAmount    = parseFloat($("#fisc_total_amt").val()) || 0;
  var taxCAmount     = parseFloat($("#fisc_tax_c_amt").val()) || 0;
  var taxDAmount     = parseFloat($("#fisc_tax_d_amt").val()) || 0;
  var taxPercentC    = parseFloat($("#fisc_tax_percent_c").val()) || 0;
  var taxPercentD    = parseFloat($("#fisc_tax_percent_d").val()) || 0;
  var advanceCash    = parseFloat($("#fisc_advance_cash").val()) || 0;
  var advanceBank    = parseFloat($("#fisc_advance_chq").val()) || 0;
  var factor_0 = $("#fisc_factor_0").val();

  // Step 1: Calculate bank payment
  var bankPayment = 0;
  if (taxCAmount >= 0 || taxDAmount >= 0) {
    bankPayment = taxCAmount + taxDAmount;
    $("#fisc_cheque").val(bankPayment);
  } else {
    $("#fisc_cheque").val(""); // Clear if no bank payment
  }

  // Step 2: Calculate dh_cash_part only if bank payment exists
  var cashPayment = 0;

  if (bankPayment >= 0) {
    if (factor_0 == 'N'){
      cashPayment = ((totalAmount*2) - bankPayment) * 0.1;
    }
    else {
      cashPayment = (totalAmount - bankPayment);
    }
    if (cashPayment < 0) cashPayment = 0;
    $("#fisc_cash_part").val(cashPayment);
  } else {
    $("#fisc_cash_part").val(""); // Clear if no valid input
  }

  // Step 3: Calculate tax amounts
  var taxAmountC = (taxCAmount * taxPercentC) / 100;
  var taxAmountD = (taxDAmount * taxPercentD) / 100;

  var totalTaxAmount = taxAmountC + taxAmountD;
  $("#fisc_tax_amt").val(totalTaxAmount);

  // Step 4: Net amount
  var netAmount = cashPayment + bankPayment + totalTaxAmount;
  $("#fisc_net_amt").val(netAmount);

  // Step 5: Total tax %
  var totalTaxPercent = taxPercentC + taxPercentD;
  $("#fisc_tax_percent").val(totalTaxPercent);

  // Step 6: Balance
  var balance = netAmount - (advanceCash + advanceBank);
  $("#fisc_balance").val(balance);

  // Step 7: Validation border logic
  var sumCheck = cashPayment + taxCAmount + taxDAmount;
  if (bankPayment > 0 && sumCheck != totalAmount) {

  } else {

  }
}


$(document).ready(function () {
  $("#fisc_cash_part, #fisc_tax_c_amt, #fisc_tax_d_amt, #fisc_tax_percent_c, #fisc_tax_percent_d, #fisc_advance_cash, #fisc_advance_chq").on("input", function () {
    //calculateDecorFinancials();
  });
//refreshTotalAmount();
setTimeout(function () {
  //calculateDecorFinancials();
}, 300);
});

function print_venue_contract_list(entryno){

  var usePath      = $.trim( $("#rootXPath").val() );

  var printurl     = $.trim( $("#printexceled").attr("rel") );

   $.ajax({

               url: usePath+"contract_venue_list/ajax_process",

               type: 'POST',

               data: {'entryno':entryno,'identity':'PRTCNTRCT'},

               async: false,

               success: function (resp) {

                    if(resp.status){

                        window.open(printurl, '_blank');

                    }else{

                        alert("No record(s) found.");

                        return false;

                    }

               },

               error: function () {



               },

               cache: false

       });


}

$(document).on("change", "[id^='fiscd_file_']", function () {
    var fileInput = this;
    var file = fileInput.files[0];
    var functionKey = $(fileInput).data('function');
    var ck = fileInput.id.split("_").pop(); // get ck from ID

    if (file !== undefined) {
        var formData = new FormData();
        var usePath = $.trim($("#rootXPath").val());
        var entryNo = $.trim($("#fisc_entryno").val());
        var functionDate = $.trim($("#fiscd_function_date_" + ck).val());
        var menuRate = $.trim($("#fiscd_menu_rate_" + ck).val());
        var menuValue = $.trim($("#fiscd_menu_value_" + ck).val());
        var extraplate = $.trim($("#fiscd_extra_plate_charge_" + ck).val());

        // UI: Show loader and message
        $("#loader_" + ck).show();
        $("#file_status_" + ck).text("Uploading...");

        // Append to formData
        formData.append("fiscd_file", file);
        formData.append("fiscd_function_type", functionKey);
        formData.append("fiscd_entryno", entryNo);
        formData.append("fiscd_function_date", functionDate);
        formData.append("fiscd_menu_rate", menuRate);
        formData.append("fiscd_menu_value", menuValue);
        formData.append("fiscd_extra_plate_charge", extraplate);

        formData.append("identity", "PrdFILE");

        $.ajax({
            url: usePath + "contract_venue_list/ajax_process",
            type: 'POST',
            data: formData,
            contentType: false,
            processData: false,
            cache: false,
            success: function (resp) {
                $("#loader_" + ck).hide();
                if (resp.status == true) {
                    $("#file_status_" + ck).html("✔️ Uploaded");
                    $("#curfiscd_file_" + ck).val(resp.filename);

                } else {
                    $("#file_status_" + ck).html("❌ " + resp.message);
                }
            },
            error: function () {
                $("#loader_" + ck).hide();
                $("#file_status_" + ck).html("❌ Upload failed");
            }
        });
    }
});



function get_payment_recieve(fiscEntryNo) {
    var usePath = $.trim($("#rootXPath").val());
    var mid = $.trim($("#mid").val());
    var department = "venue";
    var page = $.trim($("#page_redirect").val()); 
    if (fiscEntryNo) {
        window.location.href = usePath + 'payment/payment_receive?order_no=' +
            encodeURIComponent(fiscEntryNo) +
            '&department=' + encodeURIComponent(department) +
            '&mid=' + encodeURIComponent(mid) +
            '&page=' + encodeURIComponent(page) +
            '&redirect=contract_venue_list';
    } else {
        alert("No entry number found!");
    }
}

function get_payment_receive_history_list(contractno,guestname,contactno,packageamount) {
    var usePath = $.trim($("#rootXPath").val());
          $('#contractno').html(contractno); 
          $('#guestname').html(guestname);
          $('#contactno').html(contactno);
                    $('#package_amount').html(packageamount);

  var factor_0 = $.trim($("#fisc_factor_0").val()) || 'N';
     
    // Show the loader
    $(".process_loader_table").show();

    $.ajax({
        url: usePath + "contract_venue_list/ajax_process",
        type: 'POST',
        data: { 'identity': 'VIEWHISTORY', 'orderno':contractno , 'factor_0' : factor_0},
        success: function (resp) {
            if (resp.status) {
                $("#receive_payment_list").html(resp.data);
                 $("#addon_payment_list").html(resp.data2);

            } else {
                alert("No record(s) found.");
            
            }
        },
        error: function () {
            alert("An error occurred while processing the request.");
        },
        complete: function () {
            // Hide the loader when done
            $(".process_loader_table").hide();
        },
        cache: false
    });
}

function forward_to_departments() {
    var usePath = $.trim($("#rootXPath").val());
    var contractno = $.trim($("#contractno").val());
    var departmnet = $.trim($("#forward_to").val());
    var userid = $.trim($("#forward_to_user").val());

if (!departmnet ) {
   showToast("info","Select Department you want to forward this contract to ");
   $("#forward_to").focus();
   return false;
  }

    // Show the loader
    $(".process_loader_table").show();

    $.ajax({
        url: usePath + "contract_venue_list/ajax_process",
        type: 'POST',
        data: { 'identity': 'FORWARD', 'contractno':contractno , 'departmnet' : departmnet, 'userid' : userid},
        success: function (resp) {
          if (resp.status) {
            showToast("success", resp.message);
          if (departmnet.toLowerCase() === "decor") {
            alert("Contract forwarded to Decor Department!");
          } else if (departmnet.toLowerCase() === "catering") {
            alert("Contract forwarded to Catering Department!");
          } else if (departmnet.toLowerCase() === "entertainment") {
            alert("Contract forwarded to Entertainment Department!");
          }            
            const modal = bootstrap.Modal.getInstance(document.getElementById('forwardToDeptModal'));
            modal.hide();
            //location.reload(); 
            window.location.reload();

          } else {
            alert(resp.message);
            showToast("error", resp.message);
          }
        },
        error: function () {
            alert("An error occurred while processing the request.");
        },
        complete: function () {
            // Hide the loader when done
            $(".process_loader_table").hide();
        },
        cache: false
    });
}

function open_forward_lead_modal(contractno){
          $('#contractno').val(contractno); 
          $('#display_contractno').text(contractno); 
}

// Download only the modal body as PDF
 document.getElementById('downloadPdfBtn').addEventListener('click', async () => {
    const { jsPDF } = window.jspdf;
    const target = document.getElementById('receiptModalBody');
    const today = new Date();
    const dateStr = today.toLocaleDateString('en-GB', {
      day: '2-digit', month: 'short', year: 'numeric'
    });

    // Make sure we capture all content
    const originalOverflow = target.style.overflow;
    target.style.overflow = 'visible';

    const canvas = await html2canvas(target, {
      scale: 2,
      useCORS: true,
      backgroundColor: '#ffffff',
      windowWidth: target.scrollWidth,
      windowHeight: target.scrollHeight
    });

    target.style.overflow = originalOverflow;

    const imgData = canvas.toDataURL('image/jpeg', 0.95);

    const pdf = new jsPDF('p', 'mm', 'a4');
    const pageWidth = pdf.internal.pageSize.getWidth();
    const pageHeight = pdf.internal.pageSize.getHeight();
    const margin = 10;

    const imgWidth = pageWidth - margin * 2;
    const imgHeight = (canvas.height * imgWidth) / canvas.width;

    let heightLeft = imgHeight;
    let position = margin;

    // Function to add footer date
    const addFooter = (doc, pageNum, totalPages) => {
      doc.setFontSize(10);
      doc.setTextColor(100);
      doc.text(`Generated on: ${dateStr}`, margin, pageHeight - 5);
      doc.text(`Page ${pageNum} of ${totalPages}`, pageWidth - margin - 30, pageHeight - 5);
    };

    // First page
    pdf.addImage(imgData, 'JPEG', margin, position, imgWidth, imgHeight);
    heightLeft -= (pageHeight - margin * 2);

    let pageNum = 1;
    let totalPages = 1;

    // Calculate total pages first
    if (heightLeft > 0) {
      totalPages = Math.ceil(imgHeight / (pageHeight - margin * 2));
    }

    addFooter(pdf, pageNum, totalPages);

    // Additional pages
    while (heightLeft > 0) {
      pdf.addPage();
      pageNum++;
      position = margin - (imgHeight - heightLeft);
      pdf.addImage(imgData, 'JPEG', margin, position, imgWidth, imgHeight);
      addFooter(pdf, pageNum, totalPages);
      heightLeft -= (pageHeight - margin * 2);
    }

    pdf.save(`Payment-Receive-History-${dateStr}.pdf`);
  });

      function cancel_the_contract(){
    var usePath = $.trim($("#rootXPath").val());
    var contract_no = $.trim($("#contract_no").val());
    var cancel_remarks = $.trim($("#fisc_cancel_remarks").val())

    if (!cancel_remarks ) {
   showToast("info","Remarks for Cancellation is required!");
   $("#fisc_cancel_remarks").focus();
   return false;
  }

 if (!confirm("This will cancel the contract. Are you sure you want to cancel the contract?")) {
    return false; // Stop if user clicks Cancel
  }

        setTimeout(function () {
            $.ajax({
                url: usePath + "contract_venue_list/ajax_process",
                type: 'POST',
                data: {
                    'contract_no': contract_no,
                    'cancel_remarks': cancel_remarks,
                    'identity': 'CANCELCONTRACT'
                },
                async: false,
                success: function (resp) {
                  if (resp.status) {
                    showToast("success", resp.data);
          
                    const modal = bootstrap.Modal.getInstance(document.getElementById('cancelremarks'));
                    modal.hide();
                    //location.reload(); 
                    window.location.reload();

                  } else {
                    alert(resp.data);
                    showToast("error", resp.data);
                  }
                },
                error: function () {
                    $(".show_loader").removeClass("hidden").addClass("hidden");
                    $(".no_loader").removeClass("hidden");
                },
                cache: false
            });
        }, 500);
    
  }

function  open_cancel_remarks_window(){
     $("#fisc_cancel_remarks").focus();

}

function open_view_log_table(contractno,departmnet){
    var usePath = $.trim($("#rootXPath").val())     
    $.ajax({
        url: usePath + "contract_venue_list/ajax_process",
        type: 'POST',
        data: { 'identity': 'VIEWLOG', 'contractno':contractno , 'departmnet' : departmnet},
        success: function (resp) {
            if (resp.status) {
                $("#viewloggrid").html(resp.data);
            } else {
                alert("No record(s) found.");
            
            }
        },
        error: function () {
            alert("An error occurred while processing the request.");
        },
        complete: function () {
            // Hide the loader when done
            $(".process_loader_table").hide();
        },
        cache: false
    });
}

function getQueryParam(name) {
    let urlParams = new URLSearchParams(window.location.search);
    return urlParams.get(name);
}

document.addEventListener("DOMContentLoaded", function () {
    let dept = getQueryParam("department");
    let contract = getQueryParam("contractno");

    if (dept && contract) {
      $("#header_buttons").addClass("hidden");
      $("#update_header_button").addClass("hidden");
      $("[id^='upload_ppt_button']").addClass("hidden");
      $("#submit_buttons").addClass("hidden");

    }
});



function print_menu_catering_contract_list(contractno){

  var usePath      = $.trim( $("#rootXPath").val() );

  var printurl     = $.trim( $("#printmenu").attr("rel") );

   $.ajax({

               url: usePath+"contract_venue_list/ajax_process",

               type: 'POST',

               data: {'contractno':contractno,'identity':'PRTCNTRCTMENU'},

               async: false,

               success: function (resp) {

                    if(resp.status){

                        window.open(printurl, '_blank');

                    }else{

                        alert("No record(s) found.");

                        return false;

                    }

               },

               error: function () {



               },

               cache: false

       });


}