
function isNumberFloatKey(evt)

{

  var charCode = (evt.which) ? evt.which : evt.keyCode;

  if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57)){

      return false;

  }

  return true;

}

    $(document).ready(function() {
      $('#trn_cater_contract_no').select2({
        placeholder: "-Select-",
        allowClear: true,
        width: 'resolve'  // auto width
      });
      
       $('#trn_cater_contract_no').on('select2:open', function () {
        $('.select2-search__field').focus();
      });
      
    });


        $("#search_catering_transaction").on("keypress", function(e) {
    if (e.which === 13) { // 13 = Enter key
        e.preventDefault();
        search_transaction_filter();
    }
});


function get_contracts() {
    var usePath = $.trim($("#rootXPath").val());
    var department = $.trim($("#trn_cater_dept").val());

    $.ajax({
        url: usePath + "contract_transaction_list/ajax_process",
        type: 'POST',
        data: { 'department': department, 'identity': 'DEPTCHANGELIST' },
        async: false,
        success: function (resp) {
            if (resp.status) {
                var contractDropdown = $("#trn_cater_contract_no");
                contractDropdown.empty();
                contractDropdown.append('<option value="">-Select-</option>');

                $.each(resp.data, function (index, contract) {
                    var label = contract.entry_no + ' - ' + contract.guest_name + ' (' + contract.contact_no + ')';
                    contractDropdown.append('<option value="' + contract.entry_no + '">' + label + '</option>');
                });
            } else {
                alert("No contracts found for selected department.");
            }
        },
        error: function () {
            alert("Error while fetching contracts.");
        },
        cache: false
    });
}

function search_transaction_filter(){
  var useroot = $("#rootXPath").val();
  $(".show_loader").removeClass("hidden");
  $(".no_loader").removeClass("hidden").addClass("hidden")
  $("form#myForms").attr("action",useroot+"contract_transaction_list/search");
  $("form#myForms").submit();
}

$(document).ready(function(){

  flatpickr("#from_date", {

    dateFormat: "d-M-Y",

    allowInput: true,

    onOpen: function (selectedDates, dateStr, instance) {

      instance.setDate(instance.input.value, false);

    },

  });

});

$(document).ready(function(){

  flatpickr("#upto_date", {

    dateFormat: "d-M-Y",

    allowInput: true,

    onOpen: function (selectedDates, dateStr, instance) {

      instance.setDate(instance.input.value, false);

    },

  });

});

function get_functions() {
    var usePath = $.trim($("#rootXPath").val());
    var contractno = $.trim($("#trn_cater_contract_no").val());
    var department = $.trim($("#trn_cater_dept").val());

    $.ajax({
        url: usePath + "contract_transaction_list/ajax_process",
        type: 'POST',
        data: { 'contractno': contractno,  'department': department, 'identity': 'CONTRACTCHANGE' },
        async: false,
        success: function (resp) {
            if (resp.status) {
                var functionDropdown = $("#trn_function_type");
                functionDropdown.empty();
                functionDropdown.append('<option value="">-Select-</option>');

                $.each(resp.data, function (index, functiontype) {
                    functionDropdown.append('<option value="' + functiontype.function_id + '">' + functiontype.function_type + '</option>');
                });
              $("#guest_details_card").removeClass("hidden");
              $("#guest_details_card").html(resp.data2);
            } else {
                alert("No functions found for selected contract.");
                $("#guest_details_card").hide().html(""); // on contract dropdown reset

            }
        },
        error: function () {
            alert("Error while fetching contracts.");
        },
        cache: false
    });
}

function get_items_details() {
  var usePath = $.trim($("#rootXPath").val());

  // Get values from hidden fields
  const trn_function_type = $("#trn_function_type").val();
  const trn_cater_contract_no = $("#trn_cater_contract_no").val();
  const trn_cater_dept = $("#trn_cater_dept").val();

  $.ajax({
    url: usePath + "contract_transaction_list/ajax_process",
    type: "POST",
    data: { 
      trn_cater_contract_no: trn_cater_contract_no, 
      trn_function_type: trn_function_type, 
      trn_cater_dept: trn_cater_dept,
      identity: "SELECTITEMLIST" 
    },
    async: false,
    success: function (resp) {
      if (resp.status) {
        // Populate the table with response data
        $("#item_grid").html(resp.data);
        //showToast("success", resp.message);
      } else {
        showToast("error", resp.message);
      }
    },
    error: function () {
      showToast("error", "An error occurred while processing the request.");
    },
    cache: false
  });
}

  function get_all_items_details() {
    var usePath = $.trim($("#rootXPath").val());

  // Get values from hidden fields
    const trn_function_type = $("#trn_function_type").val();
    const trn_cater_contract_no = $("#trn_cater_contract_no").val();
    const trn_cater_dept = $("#trn_cater_dept").val();
    const mid = $("#mid").val();
    $.ajax({
      url: usePath + "contract_transaction_list/ajax_process",
      type: "POST",
      data: { 
        trn_cater_contract_no: trn_cater_contract_no, 
        trn_function_type: trn_function_type, 
        trn_cater_dept: trn_cater_dept,
        mid: mid,
        identity: "SHOWALLITEMS" 
      },
      async: false,
      success: function (resp) {
        if (resp.status) {
          $("#item_grid").html(resp.data); 
        } else {
          showToast("error", resp.message);
        }
      },
      error: function () {
        showToast("error", "An error occurred while processing the request.");
      },
      cache: false
    });
  }

  function get_all_add_items_details() {
    var usePath = $.trim($("#rootXPath").val());

  // Get values from hidden fields
    const trn_function_type = $("#trn_function_type").val();
    const trn_cater_contract_no = $("#trn_cater_contract_no").val();
    const mid = $("#mid").val();
    $.ajax({
      url: usePath + "contract_transaction_list/ajax_process",
      type: "POST",
      data: { 
        trn_cater_contract_no: trn_cater_contract_no, 
        trn_function_type: trn_function_type, 
        mid: mid,
        identity: "SHOWADDITEMS" 
      },
      async: false,
      success: function (resp) {
        if (resp.status) {
          $("#item_grid_2").html(resp.data); 

        } else {
          showToast("error", resp.message);
        }
      },
      error: function () {
        showToast("error", "An error occurred while processing the request.");
      },
      cache: false
    });
  }

  $(document).on("click","#trn_title_display",function(){
    $("#sidebar-menu-toggle2").toggle();
  });
  
  function close_profile_checkbox2(){
    $("#sidebar-menu-toggle2").hide();
    }
    
    $(document).on('click', function (e) {
        // Check if the click is outside the input box or sidebar menu
        if (!$(e.target).closest('#trn_title_display, #sidebar-menu-toggle2').length) {
            $("#sidebar-menu-toggle2").hide();
        }
    });
  
function get_selected_item_val2(){
  var selectedValues = [];
  var postype = [];
  var displayNames = [];

  if( $("input[name='post_type_select2[]']").is(":checked") ){
    $("input[name='post_type_select2[]']:checked").each(function(){
      postype.push($(this).attr("id"));
      selectedValues.push($(this).val());

      var groupName = $(this).closest('li').find('span.float-left').text().trim();
      displayNames.push(groupName);
    });
  }

  if( selectedValues.length > 0 ){
    $("#trn_title").val(postype.join(","));
    $("#trn_title_display").val(displayNames.join(", "));
  }else{
    $("#trn_title").val('');
    $("#trn_title_display").val('');
  }

    get_selected_group_items();
//   changeMenuList();
}

  $(document).on("click","#trn_group_display",function(){
    $("#sidebar-menu-toggle").toggle();
  });
  
  function close_profile_checkbox(){
    $("#sidebar-menu-toggle").hide();
    }
    
    $(document).on('click', function (e) {
        // Check if the click is outside the input box or sidebar menu
        if (!$(e.target).closest('#trn_group_display, #sidebar-menu-toggle').length) {
            $("#sidebar-menu-toggle").hide();
        }
    });
  
function get_selected_item_val(){
  var selectedValues = [];
  var postype = [];
  var displayNames = [];

  if( $("input[name='post_type_select[]']").is(":checked") ){
    $("input[name='post_type_select[]']:checked").each(function(){
      postype.push($(this).attr("id"));
      selectedValues.push($(this).val());

      var groupName = $(this).closest('li').find('span.float-left').text().trim();
      displayNames.push(groupName);
    });
  }

  if( selectedValues.length > 0 ){
    $("#trn_group").val(postype.join(","));
    $("#trn_group_display").val(displayNames.join(", "));
  }else{
    $("#trn_group").val('');
    $("#trn_group_display").val('');
  }

    get_selected_group_titles();
//   changeMenuList();
}


  $(document).on("click","#trn_item_display",function(){
    $("#sidebar-menu-toggle3").toggle();
  });
  
  function close_profile_checkbox3(){
    $("#sidebar-menu-toggle3").hide();
    }
    
    $(document).on('click', function (e) {
        // Check if the click is outside the input box or sidebar menu
        if (!$(e.target).closest('#trn_item_display, #sidebar-menu-toggle3').length) {
            $("#sidebar-menu-toggle3").hide();
        }
    });
  
function get_selected_item_val3(){
  var selectedValues = [];
  var postype = [];
  var displayNames = [];

  if( $("input[name='post_type_select3[]']").is(":checked") ){
    $("input[name='post_type_select3[]']:checked").each(function(){
      postype.push($(this).attr("id"));
      selectedValues.push($(this).val());

      var groupName = $(this).closest('li').find('span.float-left').text().trim();
      displayNames.push(groupName);
    });
  }

  if( selectedValues.length > 0 ){
    $("#trn_item").val(postype.join(","));
    $("#trn_item_display").val(displayNames.join(", "));
  }else{
    $("#trn_item").val('');
    $("#trn_item_display").val('');
  }

  get_selected_items_type();
    // changeMenuList();

}

function get_selected_items_type() {
  var usePath   = $.trim($("#rootXPath").val());
  var mld_group = $.trim($("#trn_group").val()).split(",");
  var mld_title = $.trim($("#trn_title").val()).split(",");
  var mld_item = $.trim($("#trn_item").val()).split(",");

  $.ajax({
    url: usePath + "lead_department/ajax_process",
    type: 'POST',
    data: { 'mld_group[]': mld_group, 'mld_title[]': mld_title, 'mld_item[]': mld_item, 'identity': 'GETTYPE' },
    async: false,
    success: function(resp) {
      var sdata = resp.data;
      var inputValue = "";

      if (sdata.length > 0) {
        inputValue = sdata[0].mi_type; // Assuming first item is the default value
      }
      
      $("#trn_type").val(inputValue);
    },
    error: function() { console.log("Error fetching items"); },
    cache: false
  });
}


function get_selected_group_titles(){
  var usePath = $.trim($("#rootXPath").val());
  var mld_group = $.trim($("#trn_group").val()).split(",");

  $.ajax({
    url: usePath + "lead_department/ajax_process",
    type: 'POST',
    data: {'mld_group[]': mld_group, 'identity': 'GETITLES'},
    async: false,
    success: function (resp) {
      var sdata = resp.data;
      var html = '';

      if(sdata.length > 0){
        $.each(sdata, function(index, item){
          html += '<li style="display:flex;">' +
                    '<div style="width: 100%;">' +
                      '<span class="float-left">' + item.tc_title_counter + '</span>' +
                      '<span class="float-right">' +
                        '<input type="checkbox" onclick="get_selected_item_val2();" name="post_type_select2[]" id="' + item.id + '" value="' + item.id + '" style="width: 20px;height: 18px;" />' +
                      '</span>' +
                    '</div>' +
                  '</li>';
        });
      } else {
        html = '<li><div>No titles available</div></li>';
      }

      // Add Close button again at the end
      html += '<li class="mt5 mr5" style="display: flex;">' +
                '<div style="width: 100%;">' +
                  '<span class="float-left"></span>' +
                  '<span class="float-right" onclick="close_profile_checkbox2();">' +
                    '<button type="button" title="Close" class="btn-close" aria-label="Close"></button>' +
                  '</span>' +
                '</div>' +
              '</li>';

          $("#process_specification2").html(html); // Replace full UL content
        },
        error: function () {
          console.error("Error fetching titles");
        },
        cache: false
      });
    }


function get_selected_group_items() {
  var usePath   = $.trim($("#rootXPath").val());
  var mld_group = $.trim($("#trn_group").val()).split(",");
  var mld_title = $.trim($("#trn_title").val()).split(",");

  $.ajax({
    url: usePath + "lead_department/ajax_process",
    type: 'POST',
    data: { 'mld_group[]': mld_group, 'mld_title[]': mld_title, 'identity': 'GETITEMS' },
    async: false,
    success: function(resp) {
      var sdata = resp.data;
      var html = '<option value="">-Select-</option>';

      if(sdata.length > 0){
        $.each(sdata, function(index, item){
          html += '<li style="display:flex;">' +
                    '<div style="width: 100%;">' +
                      '<span class="float-left">' + item.mi_item + '</span>' +
                      '<span class="float-right">' +
                        '<input type="checkbox" onclick="get_selected_item_val3();" name="post_type_select3[]" id="' + item.id + '" value="' + item.id + '" style="width: 20px;height: 18px;" />' +
                      '</span>' +
                    '</div>' +
                  '</li>';
        });
      } else {
        html = '<li><div>No Items available</div></li>';
      }
      // Add Close button again at the end
      html += '<li class="mt5 mr5" style="display: flex;">' +
                '<div style="width: 100%;">' +
                  '<span class="float-left"></span>' +
                  '<span class="float-right" onclick="close_profile_checkbox3();">' +
                    '<button type="button" title="Close" class="btn-close" aria-label="Close"></button>' +
                  '</span>' +
                '</div>' +
              '</li>';

          $("#process_specification3").html(html);
    },
    error: function() { console.log("Error fetching items"); },
    cache: false
  });
}

function reset_menu_items_details(){
  $("#trn_group").val('');
  $("#trn_title").val('');
  $("#trn_item").val('');
  $("#trn_group_display").val('')
  $("#trn_title_display").val('');
  $("#trn_item_display").val('') ;
  $("#trn_footer_id").val('');
  $("#trn_cater_entry_num").val('')
  $("#trn_cater_dtl_id").val('');
    $("input[name='post_type_select[]']").prop("checked", false);

  // Uncheck all checkboxes in the title section
  $("input[name='post_type_select2[]']").prop("checked", false);

  // Uncheck all checkboxes in the item section
  $("input[name='post_type_select3[]']").prop("checked", false);
  get_selected_group_titles();
  get_selected_group_items();
  get_selected_items_type();
}

function process_add_to_list() {
    var usePath = $.trim($("#rootXPath").val());
    var formData = new FormData();
    var mid = $.trim($("#mid").val());
    var trn_addon_dept = $.trim($("#trn_cater_dept").val());
    var trn_addon_contract_no = $.trim($("#trn_cater_contract_no").val());
    var trn_function_type = $.trim($("#trn_function_type").val());
  
    // Input Validation
    if (!trn_addon_dept) {
      showToast("error","Please Select Department!");
      $("#trn_cater_dept").focus();
      return false;
    }
  
    if (!trn_addon_contract_no) {
      showToast("error","Contact No. is required");
      $("#trn_cater_contract_no").focus();
      return false;
    }
  
    if (!trn_function_type) {
      showToast("error","Function Type is required");
      $("#trn_function_type").focus();
      return false;
    }
  
    // Prepare Form Data
    formData.append("identity", "ADDMENUITEM");
    var otherData = $('form#myforms').serializeArray();
    otherData.forEach((input) => {
      formData.append(input.name, input.value);
    });
    // formData.append("trd_otherloc", trndbrach);
    $(".no_loader").removeClass("hidden").addClass("hidden");
    $(".loader").removeClass("hidden");  
    // AJAX Request
    $.ajax({
      url: `${usePath}contract_transaction_list/ajax_process`,
      type: "POST",
      data: formData,
      contentType: false,
      processData: false,
      success: function (resp) {
        if (resp.message) {
          $(".no_loader").removeClass("hidden");
          $(".loader").removeClass("hidden").addClass("hidden"); 
          showToast("success",resp.message);
        }
  
        if (resp.headerid > 0) {
          $(".no_loader").removeClass("hidden");
          $(".loader").removeClass("hidden").addClass("hidden"); 
          $("#mid").val(resp.headerid);
          $("#prepid").val(resp.prepid); 
        } else {
          $(".no_loader").removeClass("hidden");
          $(".loader").removeClass("hidden").addClass("hidden"); 
          $("#mid").val('');
        }
  
        if (resp.data && resp.message !== "Already Exists.") {
          $(".no_loader").removeClass("hidden");
          $(".loader").removeClass("hidden").addClass("hidden"); 
          $("#item_grid_2").html(resp.data);

          
        }
  
         setTimeout(() => reset_menu_items_details(), 500);
      
      },
      error: function (xhr, status, error) {
        console.error("AJAX Error:", status, error);
        alert("An error occurred while processing the request.");
      },
      cache: false,
    });
  }

  function process_remove_from_venue_list(rowId, vcmid_title, vcmid_item, vcmid_group, vcmid_approv_req, vcmid_approv_ack, vcmid_cost) {
  var usePath = $.trim($("#rootXPath").val());
  var formData = new FormData();

  var trn_cater_dtl_id = $.trim($("#trn_function_type").val());
  var trn_cater_dept = $.trim($("#trn_cater_dept").val());
  var trn_cater_contract_no = $.trim($("#trn_cater_contract_no").val());

    if (!trn_cater_dept) {
      showToast("error","Please Select Department!");
      $("#trn_cater_dept").focus();
      return false;
    }
  
    if (!trn_cater_contract_no) {
      showToast("error","Contact No. is required");
      $("#trn_cater_contract_no").focus();
      return false;
    }
  
    if (!trn_function_type) {
      showToast("error","Function Type is required");
      $("#trn_function_type").focus();
      return false;
    }

  formData.append("identity", "REMOVEMENUITM");
  formData.append("trn_newtitle", vcmid_title);
  formData.append("trn_newitem", vcmid_item);
  formData.append("trn_newgroup", vcmid_group);
  formData.append("trn_approv_req", vcmid_approv_req);
  formData.append("trn_approv_ack", vcmid_approv_ack);
  formData.append("trn_cost", vcmid_cost);
  formData.append("trn_footer_id", rowId);

  // Include other fields from form
  var otherData = $('form#myforms').serializeArray();
  otherData.forEach((input) => {
    formData.append(input.name, input.value);
  });

  $(".loader").removeClass("hidden");

  $.ajax({
    url: `${usePath}contract_transaction_list/ajax_process`,
    type: "POST",
    data: formData,
    contentType: false,
    processData: false,
    success: function (resp) {
      $(".loader").addClass("hidden");

      if (resp.message) showToast("success", resp.message);
      if (resp.headerid > 0) {
        $("#mid").val(resp.headerid);
        $("#prepid").val(resp.prepid);
      }

      if (resp.data) {
       get_all_items_details();
      }

      // Add strike-through effect

    },
    error: function (xhr, status, error) {
      $(".loader").addClass("hidden");
      alert("An error occurred while processing.");
    },
    cache: false,
  });
}
  
function process_remove_from_catering_list(rowId, cmid_title, cmid_item, cmid_group, cmid_approv_req, cmid_approv_ack, cmid_cost) {
  var usePath = $.trim($("#rootXPath").val());
  var formData = new FormData();

  var trn_cater_dtl_id = $.trim($("#trn_function_type").val());
  var trn_cater_dept = $.trim($("#trn_cater_dept").val());
  var trn_cater_contract_no = $.trim($("#trn_cater_contract_no").val());

    if (!trn_cater_dept) {
      showToast("error","Please Select Department!");
      $("#trn_cater_dept").focus();
      return false;
    }
  
    if (!trn_cater_contract_no) {
      showToast("error","Contact No. is required");
      $("#trn_cater_contract_no").focus();
      return false;
    }
  
    if (!trn_function_type) {
      showToast("error","Function Type is required");
      $("#trn_function_type").focus();
      return false;
    }

  formData.append("identity", "REMOVEMENUITM");
  formData.append("trn_newtitle", cmid_title);
  formData.append("trn_newitem", cmid_item);
  formData.append("trn_newgroup", cmid_group);
  formData.append("trn_approv_req", cmid_approv_req);
  formData.append("trn_approv_ack", cmid_approv_ack);
  formData.append("trn_cost", cmid_cost);
  formData.append("trn_footer_id", rowId);

  // Include other fields from form
  var otherData = $('form#myforms').serializeArray();
  otherData.forEach((input) => {
    formData.append(input.name, input.value);
  });

  $(".loader").removeClass("hidden");

  $.ajax({
    url: `${usePath}contract_transaction_list/ajax_process`,
    type: "POST",
    data: formData,
    contentType: false,
    processData: false,
    success: function (resp) {
      $(".loader").addClass("hidden");

      if (resp.message) showToast("success", resp.message);
      if (resp.headerid > 0) {
        $("#mid").val(resp.headerid);
        $("#prepid").val(resp.prepid);
      }

      if (resp.data) {
       get_all_items_details();
      }

      // Add strike-through effect

    },
    error: function (xhr, status, error) {
      $(".loader").addClass("hidden");
      alert("An error occurred while processing.");
    },
    cache: false,
  });
}

$(document).ready(function() {
  get_all_items_details();
  get_all_add_items_details();

    var contractno = $.trim($("#trn_cater_contract_no").val());
    if (contractno !== ''){
      get_guest_details();
    }
});


function delete_menu_item(menuitemid) {
  const usePath = $("#rootXPath").val();
  var trn_cater_entry_num = $.trim($("#trn_cater_entry_num").val());
  var trn_cater_dtl_id = $.trim($("#trn_cater_dtl_id").val());

  if (confirm("Are you sure you want to delete this record ?")) {
      $.ajax({
          url: `${usePath}contract_transaction_list/ajax_process`,
          type: 'POST',
          data: {
            menuitemid: menuitemid,
              identity: 'DELETEMENUITM'
          },
          success: function (resp) {
              if (resp.status) {
                  // Update the UI with new data
                  $("#item_grid_2").html(resp.data);

                  // $("#func_info_list").html(resp.fisdtl);

                  // Show success toast
                  showToast("success", resp.message);
              } else {
                  // Handle failure response
                  $(".no_loader").addClass("hidden");
                  $(".loader").addClass("hidden");
                  $(".process_qualif_save").show();

                  // Show error toast
                  showToast("error", resp.message);
              }
          },
          error: function () {
              // Handle request failure
              $(".unprocess_loader").removeClass("hidden");
              $(".process_loader").addClass("hidden");

              showToast("error", "An error occurred while processing your request.");
          },
          cache: false
      });
  }
}

function process_add_again(menuitemid) {
  const usePath = $("#rootXPath").val();
  var trn_cater_entry_num = $.trim($("#trn_cater_entry_num").val());
  var trn_cater_dtl_id = $.trim($("#trn_cater_dtl_id").val());
  var trn_cater_contract_no = $.trim($("#trn_cater_contract_no").val());
      $.ajax({
          url: `${usePath}contract_transaction_list/ajax_process`,
          type: 'POST',
          data: {
            menuitemid: menuitemid,
            trn_cater_contract_no : trn_cater_contract_no,
              identity: 'ADDAGAIN'
          },
          success: function (resp) {
              if (resp.status) {
                  // Update the UI with new data
                  showToast("success", resp.message);

                  get_all_items_details();
                  // $("#func_info_list").html(resp.fisdtl);

                  // Show success toast
              } else {
                  // Handle failure response
                  $(".no_loader").addClass("hidden");
                  $(".loader").addClass("hidden");
                  $(".process_qualif_save").show();

                  // Show error toast
                  showToast("error", resp.message);
              }
          },
          error: function () {
              // Handle request failure
              $(".unprocess_loader").removeClass("hidden");
              $(".process_loader").addClass("hidden");

              showToast("error", "An error occurred while processing your request.");
          },
          cache: false
      });
  
}

function process_update_this_transaction(){
      var usePath = $.trim($("#rootXPath").val());
      var transaction_no = $.trim($("#trn_cater_no").val());
      var departmnet = $.trim($("#trn_cater_dept").val());
  // Get values from hidden fields
    var function_type = $("#trn_function_type").val();
    var contract_no = $("#trn_cater_contract_no").val();
    var mid = $("#mid").val();
    $.ajax({
      url: usePath + "contract_transaction_list/ajax_process",
      type: "POST",
      data: { 
        contract_no: contract_no, 
        function_type: function_type, 
        transaction_no: transaction_no,
        departmnet: departmnet,
        mid: mid,
        identity: "UPDATETRNSCTN" 
      },
      async: false,
      success: function (resp) {
        alert(resp.message);
        window.location.reload();
      },
      error: function () {
        showToast("error", "An error occurred while processing the request.");
      },
      cache: false
    });
}

function process_cancel_this_transaction(){
      var usePath = $.trim($("#rootXPath").val());
      var transaction_no = $.trim($("#trn_cater_no").val());
      var departmnet = $.trim($("#trn_cater_dept").val());
  // Get values from hidden fields
    var function_type = $("#trn_function_type").val();
    var contract_no = $("#trn_cater_contract_no").val();
    var mid = $("#mid").val();
    $.ajax({
      url: usePath + "contract_transaction_list/ajax_process",
      type: "POST",
      data: { 
        contract_no: contract_no, 
        function_type: function_type, 
        transaction_no: transaction_no,
        departmnet: departmnet,
        mid: mid,
        identity: "CANCELTRNSCTN" 
      },
      async: false,
      success: function (resp) {
        alert(resp.message);
        window.location.reload();
      },
      error: function () {
        showToast("error", "An error occurred while processing the request.");
      },
      cache: false
    });
}

function get_guest_details() {
    var usePath = $.trim($("#rootXPath").val());
    var contractno = $.trim($("#trn_cater_contract_no").val());
    var department = $.trim($("#trn_cater_dept").val());
    $.ajax({
        url: usePath + "contract_transaction_list/ajax_process",
        type: 'POST',
        data: { 'contractno': contractno,  'department': department, 'identity': 'CONTRACTCHANGE' },
        async: false,
        success: function (resp) {
            if (resp.status) {
              $("#guest_details_card").removeClass("hidden");
              $("#guest_details_card").html(resp.data2);
            } else {
                alert("No functions found for selected contract.");
                $("#guest_details_card").hide().html(""); 
            }
        },
        error: function () {
            alert("Error while fetching contracts.");
        },
        cache: false
    });
}


// Global array to store selected product values
var selectedProducts = JSON.parse(localStorage.getItem('selectedProducts')) || [];

// Toggle Select All
function check_unchecked_products() {
    let allCheckbox = $("input[name='select_all_mitem[]']");
    let isChecked = allCheckbox.is(":checked");
    allCheckbox.prop("checked", !isChecked).trigger("change");
}

// Event listener for product checkboxes
$(document).on("change", "input[name='select_all_mitem[]']", function () {
    var checkboxValue = $(this).val();

    if ($(this).is(':checked')) {
        if (!selectedProducts.includes(checkboxValue)) {
            selectedProducts.push(checkboxValue);
        }
    } else {
        selectedProducts = selectedProducts.filter(function (v) {
            return v !== checkboxValue;
        });
    }

    localStorage.setItem('selectedProducts', JSON.stringify(selectedProducts));
});

// Clear selected items function
function clearSelectedProducts() {
    selectedProducts = [];
    localStorage.removeItem('selectedProducts');
    $("input[name='select_all_mitem[]']").prop('checked', false);
}

// Remove items function
function remove_all_selected_items() {
    var usePath = $("#rootXPath").val().trim();
    var department = $("#trn_cater_dept").val().trim();
    var contractno = $("#trn_cater_contract_no").val().trim();
    var functiontype = $("#trn_function_type").val().trim();

    if (selectedProducts.length <= 0) {
        showToast("error", "Please select at least one checkbox.");
        return;
    }

    var selectedProducts2 = [...new Set(selectedProducts)];

    $(".show_loaders").show();
    $(".noshow_loaders").hide();

    $.ajax({
        url: usePath + "contract_transaction_list/ajax_process",
        type: 'POST',
        data: {
            identity: 'DELMULTIITM',
            department: department,
            contractno: contractno,
            functiontype: functiontype,
            allprodval: selectedProducts2.join(',')
        },
        success: function (resp) {
            $(".show_loaders").hide();
            $(".noshow_loaders").show();

            if (resp.status) {
                $("#item_grid_2").html(resp.data);
                clearSelectedProducts();
            } else {
                showToast("error", resp.message || "Something went wrong.");
            }
        }
    });
}

// Reset selection on page load
$(document).ready(function () {
    clearSelectedProducts();
});
