function alertChecked(url){
  if( confirm("Are you sure want to delete ?")){
    
      window.location = url
  }
}

    $("#search_decor_contract").on("keypress", function(e) {
    if (e.which === 13) { // 13 = Enter key
        e.preventDefault();
        search_contract_list_filter();
    }
});



function search_contract_list_filter(){
  var useroot = $("#rootXPath").val();
  $(".show_loader").removeClass("hidden");
  $(".no_loader").removeClass("hidden").addClass("hidden")
  $("form#myForms").attr("action",useroot+"contract_list/search");
  $("form#myForms").submit();
}


function isFloatNegativeKey(e,vls){

  if (e.charCode >= 32 && e.charCode < 127 && !/^-?\d*[.,]?\d*$/.test(vls + '' + String.fromCharCode(e.charCode)))
  {
    return false;
  }
  return true;
}

function isNumberFloatKey(evt)
{
  var charCode = (evt.which) ? evt.which : evt.keyCode;
  if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57)){
      return false;
  }
  return true;
}

function isNumberKeys(evt) {
  evt = (evt) ? evt : window.event;
  var charCode = (evt.which) ? evt.which : evt.keyCode;
  if (charCode > 31 && (charCode < 48 || charCode > 57)) {
      return false;
  }
  return true;
}


$(document).ready(function(){

  flatpickr("#from_date", {

    dateFormat: "d-M-Y",

    allowInput: true,

    onOpen: function (selectedDates, dateStr, instance) {

      instance.setDate(instance.input.value, false);

    },

  });

});

$(document).ready(function(){

  flatpickr("#upto_date", {

    dateFormat: "d-M-Y",

    allowInput: true,

    onOpen: function (selectedDates, dateStr, instance) {

      instance.setDate(instance.input.value, false);

    },

  });

});

$(document).ready(function(){
  flatpickr("#dhc_contract_date", {
    dateFormat: "d-M-Y",
    allowInput: false,         
    minDate: new Date().fp_incr(-3),        
    maxDate: "today",
    onOpen: function (selectedDates, dateStr, instance) {
      instance.setDate(instance.input.value, false);
    },
  });
});

$(document).ready(function(){

  flatpickr("#function_date", {

    dateFormat: "d-M-Y",

    allowInput: true,

    onOpen: function (selectedDates, dateStr, instance) {

      instance.setDate(instance.input.value, false);

    },

  });

});

$(document).ready(function(){

  flatpickr("#CntrcD_Function_date", {

    dateFormat: "d-M-Y",

    allowInput: true,

    onOpen: function (selectedDates, dateStr, instance) {

      instance.setDate(instance.input.value, false);

    },

  });

});

  function search_and_fill() {
    var usePath = $.trim($("#rootXPath").val());
    var dhc_contact_no = $.trim($("#dhc_contact_no").val());

  if (dhc_contact_no !== '') {
        $(".show_loader").removeClass("hidden");
        $(".no_loader").removeClass("hidden").addClass("hidden");
        setTimeout(function () {
            $.ajax({
                url: usePath + "contract_list/ajax_process",
                type: 'POST',
                data: {
                    'requestcode': '',
                    'contact_no': dhc_contact_no,
                    'requesttype': 'CODE',
                    'identity': 'SEARCHANDFILL'
                },
                async: false,
                success: function (resp) {
                    $(".show_loader").removeClass("hidden").addClass("hidden");
                    $(".no_loader").removeClass("hidden");
                    var nhtml = '';

                    if (resp.status) {
                        nhtml += '<select id="new_search_and_fill_select" onchange="selected_my_contact_list(this.value); search_filter_decor_contact();"><option value="">-Select-</option>';
                        var sdata = resp.data;

                        if (sdata.length > 0) {
                            $.each(sdata, function (key, leds) {
                                nhtml += `<option value="${leds.dh_contact_no},${leds.dh_entry_no}">${leds.dh_entry_no}-${leds.dh_guest_name}-${leds.dh_contact_no}</option>`;
                            });
                        }

                        nhtml += '</select>';
                    }

                    $("#contact_no").html(nhtml);
                },
                error: function () {
                    $(".show_loader").removeClass("hidden").addClass("hidden");
                    $(".no_loader").removeClass("hidden");
                },
                cache: false
            });
        }, 500);
    }
}


function selected_my_contact_list(val){            
    var nstr         = val.split(",");
    for(var i = 0; i < nstr.length; i++) {
       nstr[i] = nstr[i].replace(/'/g, "");
    }   
     if( nstr[0] =='null' ){
         nstr[0] = '';
     }
     if( nstr[1] =='null' ){
         nstr[1] = '';
     }
     $("#dhc_contact_no").val(nstr[0]);
     $("#decor_entry_no").val(nstr[1]);
     $("#contact_no").html('');
     setTimeout(function(){ search_filter_decor_contact();},500);

}

function search_filter_decor_contact() {
  var usePath = $.trim($("#rootXPath").val());
  var decor_entry_no = $.trim($("#decor_entry_no").val());

  if (decor_entry_no !== '') {
        $(".show_loader").removeClass("hidden");
        $(".no_loader").removeClass("hidden").addClass("hidden");
      setTimeout(function () {
          $.ajax({
              url: usePath + "contract_list/ajax_process",
              type: 'POST',
              data: {
                  'dh_entry_no': decor_entry_no,
                  'requesttype': 'CODE',
                  'identity': 'DECORCONTACT'
              },
              async: false,
              dataType: 'json',
              success: function (resp) {
                    $(".show_loader").removeClass("hidden").addClass("hidden");
                    $(".no_loader").removeClass("hidden");
                  if (resp.status) {
                      var sdata = resp.data;
                      $("#decor_entry_no").val(sdata.dh_entry_no);
                      $("#dhc_guest_name").val(sdata.dh_guest_name);
                      $("#dhc_address").val(sdata.dh_address);
                      $("#dhc_state").val(sdata.dh_state);
                      $("#dhc_city").val(sdata.dh_city);
                      $("#dhc_pincode").val(sdata.dh_pincode);
                      $("#dhc_email").val(sdata.dh_email);
                      $("#dhc_enquiry_mode").val(sdata.dh_enquiry_mode);
                      $("#dhc_proposal").val(sdata.dh_proposal);
                      $("#dhc_total_amt").val(sdata.dh_total_amt);
                      $("#dhc_cash_part").val(sdata.dh_cash_part);
                      $("#dhc_cheque").val(sdata.dh_cheque);

                      $("#dhc_tax_c_amt").val(sdata.dh_tax_c_amt);
                      $("#dhc_tax_d_amt").val(sdata.dh_tax_d_amt);
                      $("#dhc_tax_percent_c").val(sdata.dh_tax_percent_c);
                      $("#dhc_tax_percent_d").val(sdata.dh_tax_percent_d);
                      $("#dhc_factor_0").val(sdata.dh_factor_0);

                      $("#dhc_tax_percent").val(sdata.dh_tax_percent);
                      $("#dhc_tax_amt").val(sdata.dh_tax_amt);
                      $("#dhc_net_amt").val(sdata.dh_net_amt);
                      $("#dhc_advance_cash").val(sdata.dh_advance_cash);
                      $("#dhc_advance_chq").val(sdata.dh_advance_chq);
                      $("#dhc_balance").val(sdata.dh_balance);
                      $("#dhc_addtional_remrks").val(sdata.dh_addtional_remrks);
                      $("#dhc_decor_entryby").val(sdata.dh_decor_entryby);
                      $("#dhc_decor_entryby_display").val(resp.entryby_name);
                      if(resp.data2){
                        $("#decorcontractdetailgrid").html(resp.data2);
                      }
                  } else {
                   
                      alert(resp.message);
                  }
              },
              error: function () {
                  
                    $(".show_loader").removeClass("hidden").addClass("hidden");
                    $(".no_loader").removeClass("hidden");
              },
              cache: false
          });
      }, 500);
  }
}

function save_decor_contract_details(){
  var usePath = $.trim($("#rootXPath").val());
  var entry_no = $.trim($("#dhc_entry_no").val());
  var mid = $.trim($("#mid").val());
  var dhc_addtional_remrks =  $.trim($("#dhc_addtional_remrks").val());
  var dhc_location =  $.trim($("#dhc_location").val());
 var dhc_contract_date =  $.trim($("#dhc_contract_date").val());
     var dhc_total_amt = $.trim($("#dhc_total_amt").val());

 // Entry No. must be in hidden field or somewhere
  var formData = new FormData();
  var otherData = $('form#myforms').serializeArray();
  formData.append("identity", "SAVECONTRACT");
  formData.append("entry_no", entry_no);
  var fileUploaded = false;

  $("[id^='dhcd_file_']").each(function () {
    var fileInput = this;
    var file = fileInput.files[0];
    if (file !== undefined) {
      fileUploaded = true; // At least one file is uploaded
      var functionKey = $(fileInput).attr('name').match(/\[(.*?)\]/)[1]; // extract function name
      formData.append("dhcd_file[" + functionKey + "]", file);
    }
  });

 if (!dhc_location ) {
   showToast("error","Booking Location are required!");
   $("#dhc_location").focus();
   return false;
  }

 if (!dhc_addtional_remrks ) {
   showToast("error","Additional Remarks are required!");
   $("#dhc_addtional_remrks").focus();
   return false;
  }

 if (dhc_total_amt === "" || parseFloat(dhc_total_amt) <= 0) {
  showToast("error", "Total Amount Cannot Be 0!");
  $("#dhc_total_amt").focus();
  return false;
 }

  var confirmMessage = `Do you want to save contract on this (${dhc_contract_date})?`;
  if (!confirm(confirmMessage)) {
   $("#dhc_contract_date").focus();
    return false; 
  }

  
  otherData.forEach((input) => {
    formData.append(input.name, input.value);
  });
  
        $(".show_loader").removeClass("hidden");
        $(".no_loader").removeClass("hidden").addClass("hidden");
    
      $.ajax({
          url: usePath + "contract_list/ajax_process",
          type: 'POST',
          data: formData,
          contentType: false,
          processData: false,
          success: function(resp){
                $(".show_loader").removeClass("hidden").addClass("hidden");
                $(".no_loader").removeClass("hidden");
              if(resp.status){
                showToast("success",resp.message);
                window.location.href = usePath + "contract_list";
                 
              } else {
                showToast("success");
                 alert("Date Saved Successfully!");
		 window.location.href = usePath + "contract_list";
              }
          },
          error: function(){
                    $(".show_loader").removeClass("hidden").addClass("hidden");
                    $(".no_loader").removeClass("hidden");
                   alert("Server error occurred.");
          },
          cache: false
      });  
}


function update_decor_save(){
  var usePath = $.trim($("#rootXPath").val());
  var entry_no = $.trim($("#dhc_entry_no").val());
  var mid = $.trim($("#mid").val());
 // Entry No. must be in hidden field or somewhere
  var formData = new FormData();
  var otherData = $('form#myforms').serializeArray();
  formData.append("identity", "UPDATECONTRACT");
  formData.append("entry_no", entry_no);
  formData.append("mid", mid);

  otherData.forEach((input) => {
    formData.append(input.name, input.value);
  });
  
        $(".show_loader").removeClass("hidden");
        $(".no_loader").removeClass("hidden").addClass("hidden");
    
      $.ajax({
          url: usePath + "contract_list/ajax_process",
          type: 'POST',
          data: formData,
          contentType: false,
          processData: false,
          success: function(resp){
                $(".show_loader").removeClass("hidden").addClass("hidden");
                $(".no_loader").removeClass("hidden");
              if(resp.status){
                showToast("success",resp.message);
                window.location.href = usePath + "contract_list";
                 
              } else {
                showToast("error",resp.message);
              }
          },
          error: function(){
                    $(".show_loader").removeClass("hidden").addClass("hidden");
                    $(".no_loader").removeClass("hidden");
                   alert("Server error occurred.");
          },
          cache: false
      });  
}


function refreshTotalAmount() {
  var usePath = $.trim($("#rootXPath").val());
  var entry_no = $.trim($("#dhc_entry_no").val());

  $.ajax({
    url: usePath + "contract_list/ajax_process",
    type: "POST",
    data: { identity: "GET_TOTAL_AMOUNT", entry_no: entry_no },
    success: function (resp) {
      if (resp.total_amount !== undefined) {
        $("#dhc_total_amt").val(resp.total_amount);
        calculateDecorFinancials(); // Recalculate all dependent fields
      }
    },
    error: function () {
      console.error("Failed to fetch total amount.");
    }
  });
}

function calculate_factor() {
  var usePath = $.trim($("#rootXPath").val());
  var entry_no = $.trim($("#dhc_entry_no").val());

  $.ajax({
    url: usePath + "contract_list/ajax_process",
    type: "POST",
    data: { identity: "GET_FACTOR", entry_no: entry_no },
    success: function (resp) {
      if (resp.factor_total_amt !== undefined) {
        $("#dhc_total_amt").val(resp.factor_total_amt.toFixed(2));
        $("#dhc_cash_part").val(resp.factor_cash_part.toFixed(2));
        $("#dhc_cheque").val(resp.factor_cheque.toFixed(2));
        $("#dhc_tax_c_amt").val(resp.factor_tax_c_amt.toFixed(2));
        $("#dhc_tax_d_amt").val(resp.factor_tax_d_amt.toFixed(2));
        $("#dhc_tax_percent_c").val(resp.factor_tax_percent_c.toFixed(2));
        $("#dhc_tax_percent_d").val(resp.factor_tax_percent_d.toFixed(2));
        $("#dhc_tax_percent").val(resp.factor_tax_percent.toFixed(2));
        $("#dhc_tax_amt").val(resp.factor_tax_amt.toFixed(2));
        $("#dhc_net_amt").val(resp.factor_net_amt.toFixed(2));
        $("#dhc_advance_cash").val(resp.factor_advance_cash.toFixed(2));
        $("#dhc_advance_chq").val(resp.factor_advance_chq.toFixed(2));
        $("#dhc_balance").val(resp.factor_balance.toFixed(2));

      }
    },
    error: function () {
      console.error("Failed to fetch total amount.");
    }
  });
}

function calculateDecorFinancials() {
  var totalAmount    = parseFloat($("#dhc_total_amt").val()) || 0;
  var taxCAmount     = parseFloat($("#dhc_tax_c_amt").val()) || 0;
  var taxDAmount     = parseFloat($("#dhc_tax_d_amt").val()) || 0;
  var taxPercentC    = parseFloat($("#dhc_tax_percent_c").val()) || 0;
  var taxPercentD    = parseFloat($("#dhc_tax_percent_d").val()) || 0;
  var advanceCash    = parseFloat($("#dhc_advance_cash").val()) || 0;
  var advanceBank    = parseFloat($("#dhc_advance_chq").val()) || 0;
  var factor_0 = $("#dhc_factor_0").val();

  // Step 1: Calculate bank payment
  var bankPayment = 0;
  if (taxCAmount >= 0 || taxDAmount >= 0) {
    bankPayment = taxCAmount + taxDAmount;
    $("#dhc_cheque").val(bankPayment);
  } else {
    $("#dhc_cheque").val(""); // Clear if no bank payment
  }

  // Step 2: Calculate dh_cash_part only if bank payment exists
  var cashPayment = 0;

  if (bankPayment >= 0) {
    if (factor_0 == 'N'){
      cashPayment = ((totalAmount*2) - bankPayment) * 0.1;
    }
    else {
      cashPayment = (totalAmount - bankPayment);
    }
    if (cashPayment < 0) cashPayment = 0;
    $("#dhc_cash_part").val(cashPayment);
  } else {
    $("#dhc_cash_part").val(""); // Clear if no valid input
  }

  // Step 3: Calculate tax amounts
  var taxAmountC = (taxCAmount * taxPercentC) / 100;
  var taxAmountD = (taxDAmount * taxPercentD) / 100;

  var totalTaxAmount = taxAmountC + taxAmountD;
  $("#dhc_tax_amt").val(totalTaxAmount);

  // Step 4: Net amount
  var netAmount = cashPayment + bankPayment + totalTaxAmount;
  $("#dhc_net_amt").val(netAmount);

  // Step 5: Total tax %
  var totalTaxPercent = taxPercentC + taxPercentD;
  $("#dhc_tax_percent").val(totalTaxPercent);

  // Step 6: Balance
  var balance = netAmount - (advanceCash + advanceBank);
  $("#dhc_balance").val(balance);

  // Step 7: Validation border logic
  var sumCheck = cashPayment + taxCAmount + taxDAmount;
  if (bankPayment > 0 && sumCheck != totalAmount) {

  } else {

  }
}

$(document).ready(function () {
  $("#dhc_cash_part, #dhc_tax_c_amt, #dhc_tax_d_amt, #dhc_tax_percent_c, #dhc_tax_percent_d, #dhc_advance_cash, #dhc_advance_chq").on("input", function () {
    // calculateDecorFinancials();
  });
//refreshTotalAmount();
setTimeout(function () {
//  calculateDecorFinancials();
}, 300); // Also run on page load
});

function print_decor_contract_list(entryno){

  var usePath      = $.trim( $("#rootXPath").val() );

  var printurl     = $.trim( $("#printexceled").attr("rel") );

   $.ajax({

               url: usePath+"contract_list/ajax_process",

               type: 'POST',

               data: {'entryno':entryno,'identity':'PRTCNTRCT'},

               async: false,

               success: function (resp) {

                    if(resp.status){

                        window.open(printurl, '_blank');

                    }else{

                        alert("No record(s) found.");

                        return false;

                    }

               },

               error: function () {



               },

               cache: false

       });


}

$(document).on("change", "[id^='dhcd_file_']", function () {
    var fileInput = this;
    var file = fileInput.files[0];
    var functionKey = $(fileInput).data('function');
    var ck = fileInput.id.split("_").pop(); // get ck from ID

    if (file !== undefined) {
        var formData = new FormData();
        var usePath = $.trim($("#rootXPath").val());
        var entryNo = $.trim($("#dhc_entry_no").val());

        // UI: Show loader and message
        $("#loader_" + ck).show();
        $("#file_status_" + ck).text("Uploading...");

        // Append to formData
        formData.append("dhcd_file", file);
        formData.append("dhcd_function", functionKey);
        formData.append("dhcd_entry_no", entryNo);
        formData.append("identity", "PrdFILE");

        $.ajax({
            url: usePath + "contract_list/ajax_process",
            type: 'POST',
            data: formData,
            contentType: false,
            processData: false,
            cache: false,
            success: function (resp) {
                $("#loader_" + ck).hide();
                if (resp.status == true) {
                    $("#file_status_" + ck).html("✔️ Uploaded");
                    $("#curdhcd_file_" + ck).val(resp.filename);

                } else {
                    $("#file_status_" + ck).html("❌ " + resp.message);
                }
            },
            error: function () {
                $("#loader_" + ck).hide();
                $("#file_status_" + ck).html("❌ Upload failed");
            }
        });
    }
});

function get_payment_recieve(dhcEntryNo) {
    var usePath = $.trim($("#rootXPath").val());
    var mid = $.trim($("#mid").val());
    var department = "decor";

    if (dhcEntryNo) {
        window.location.href = usePath + 'payment/payment_receive?order_no=' +
            encodeURIComponent(dhcEntryNo) +
            '&department=' + encodeURIComponent(department) +
            '&mid=' + encodeURIComponent(mid) +
            '&redirect=contract_list';
    } else {
        alert("No entry number found!");
    }
}

function get_payment_receive_history_list(contractno,guestname,contactno,packageamount) {
    var usePath = $.trim($("#rootXPath").val());
          $('#contractno').html(contractno); 
          $('#guestname').html(guestname);
          $('#contactno').html(contactno);
                    $('#package_amount').html(packageamount);

  var factor_0 = $.trim($("#dhc_factor_0").val());
     
    // Show the loader
    $(".process_loader_table").show();

    $.ajax({
        url: usePath + "contract_list/ajax_process",
        type: 'POST',
        data: { 'identity': 'VIEWHISTORY', 'orderno':contractno , 'factor_0' : factor_0},
        success: function (resp) {
            if (resp.status) {
                $("#receive_payment_list").html(resp.data);
                 $("#addon_payment_list").html(resp.data2);
            } else {
                alert("No record(s) found.");
            
            }
        },
        error: function () {
            alert("An error occurred while processing the request.");
        },
        complete: function () {
            // Hide the loader when done
            $(".process_loader_table").hide();
        },
        cache: false
    });
}


function forward_to_departments() {
    var usePath = $.trim($("#rootXPath").val());
    var contractno = $.trim($("#contractno").val());
    var departmnet = $.trim($("#forward_to").val());
    var userid = $.trim($("#forward_to_user").val());

if (!departmnet ) {
   showToast("info","Select Department you want to forward this contract to ");
   $("#forward_to").focus();
   return false;
  }

    // Show the loader
    $(".process_loader_table").show();

    $.ajax({
        url: usePath + "contract_list/ajax_process",
        type: 'POST',
        data: { 'identity': 'FORWARD', 'contractno':contractno , 'departmnet' : departmnet, 'userid' : userid},
        success: function (resp) {
          if (resp.status) {
            showToast("success", resp.message);
          if (departmnet.toLowerCase() === "venue") {
            alert("Contract forwarded to Venue Department!");
          } else if (departmnet.toLowerCase() === "catering") {
            alert("Contract forwarded to Catering Department!");
          } else if (departmnet.toLowerCase() === "entertainment") {
            alert("Contract forwarded to Entertainment Department!");
          }            
            const modal = bootstrap.Modal.getInstance(document.getElementById('forwardToDeptModal'));
            modal.hide();
            //location.reload(); 
            window.location.reload();

          } else {
            alert(resp.message);
            showToast("error", resp.message);
          }
        },
        error: function () {
            alert("An error occurred while processing the request.");
        },
        complete: function () {
            // Hide the loader when done
            $(".process_loader_table").hide();
        },
        cache: false
    });
}


  function get_department_users() {
    var usePath = $.trim($("#rootXPath").val());
    var departmnet = $.trim($("#forward_to").val());

  if (departmnet !== '') {
        $(".show_loader").removeClass("hidden");
        $(".no_loader").removeClass("hidden").addClass("hidden");
        setTimeout(function () {
            $.ajax({
                url: usePath + "contract_venue_list/ajax_process",
                type: 'POST',
                data: {
                    'departmnet': departmnet,
                    'requesttype': 'CODE',
                    'identity': 'GETDEPTUSERS'
                },
                async: false,
                success: function (resp) {
                    $(".show_loader").removeClass("hidden").addClass("hidden");
                    $(".no_loader").removeClass("hidden");
                    var nhtml = '';

                    if (resp.status) {
                        nhtml += '<select class="form-select"><option value="">-Select-</option>';

                        var sdata = resp.data;

                        if (sdata.length > 0) {
                            $.each(sdata, function (key, leds) {
                                nhtml += `<option value="${leds.id}">${leds.username}</option>`;
                            });
                        }

                        nhtml += '</select>';
                    }

                    $("#forward_to_user").html(nhtml);
                },
                error: function () {
                    $(".show_loader").removeClass("hidden").addClass("hidden");
                    $(".no_loader").removeClass("hidden");
                },
                cache: false
            });
        }, 500);
    }
}


function open_forward_lead_modal(contractno){
          $('#contractno').val(contractno); 
          $('#display_contractno').text(contractno); 
}

function payemnt_receive_cancel(obj){
    if( confirm("Are you sure want to cancel?") ){
        window.location = obj.rel;
    }
}

// Download only the modal body as PDF
 document.getElementById('downloadPdfBtn').addEventListener('click', async () => {
    const { jsPDF } = window.jspdf;
    const target = document.getElementById('receiptModalBody');
    const today = new Date();
    const dateStr = today.toLocaleDateString('en-GB', {
      day: '2-digit', month: 'short', year: 'numeric'
    });

    // Make sure we capture all content
    const originalOverflow = target.style.overflow;
    target.style.overflow = 'visible';

    const canvas = await html2canvas(target, {
      scale: 2,
      useCORS: true,
      backgroundColor: '#ffffff',
      windowWidth: target.scrollWidth,
      windowHeight: target.scrollHeight
    });

    target.style.overflow = originalOverflow;

    const imgData = canvas.toDataURL('image/jpeg', 0.95);

    const pdf = new jsPDF('p', 'mm', 'a4');
    const pageWidth = pdf.internal.pageSize.getWidth();
    const pageHeight = pdf.internal.pageSize.getHeight();
    const margin = 10;

    const imgWidth = pageWidth - margin * 2;
    const imgHeight = (canvas.height * imgWidth) / canvas.width;

    let heightLeft = imgHeight;
    let position = margin;

    // Function to add footer date
    const addFooter = (doc, pageNum, totalPages) => {
      doc.setFontSize(10);
      doc.setTextColor(100);
      doc.text(`Generated on: ${dateStr}`, margin, pageHeight - 5);
      doc.text(`Page ${pageNum} of ${totalPages}`, pageWidth - margin - 30, pageHeight - 5);
    };

    // First page
    pdf.addImage(imgData, 'JPEG', margin, position, imgWidth, imgHeight);
    heightLeft -= (pageHeight - margin * 2);

    let pageNum = 1;
    let totalPages = 1;

    // Calculate total pages first
    if (heightLeft > 0) {
      totalPages = Math.ceil(imgHeight / (pageHeight - margin * 2));
    }

    addFooter(pdf, pageNum, totalPages);

    // Additional pages
    while (heightLeft > 0) {
      pdf.addPage();
      pageNum++;
      position = margin - (imgHeight - heightLeft);
      pdf.addImage(imgData, 'JPEG', margin, position, imgWidth, imgHeight);
      addFooter(pdf, pageNum, totalPages);
      heightLeft -= (pageHeight - margin * 2);
    }

    pdf.save(`Payment-Receive-History-${dateStr}.pdf`);
  });

  function cancel_the_contract(){
    var usePath = $.trim($("#rootXPath").val());
    var contract_no = $.trim($("#contract_no").val());
    var cancel_remarks = $.trim($("#dhc_cancel_remarks").val())

    if (!cancel_remarks ) {
   showToast("info","Remarks for Cancellation is required!");
   $("#dhc_cancel_remarks").focus();
   return false;
  }

 if (!confirm("This will cancel the contract. Are you sure you want to cancel the contract?")) {
    return false; // Stop if user clicks Cancel
  }

        setTimeout(function () {
            $.ajax({
                url: usePath + "contract_list/ajax_process",
                type: 'POST',
                data: {
                    'contract_no': contract_no,
                    'cancel_remarks': cancel_remarks,
                    'identity': 'CANCELCONTRACT'
                },
                async: false,
                success: function (resp) {
                  if (resp.status) {
                    showToast("success", resp.data);
          
                    const modal = bootstrap.Modal.getInstance(document.getElementById('cancelremarks'));
                    modal.hide();
                    //location.reload(); 
                    window.location.reload();

                  } else {
                    alert(resp.data);
                    showToast("error", resp.data);
                  }
                },
                error: function () {
                    $(".show_loader").removeClass("hidden").addClass("hidden");
                    $(".no_loader").removeClass("hidden");
                },
                cache: false
            });
        }, 500);
    
  }

function  open_cancel_remarks_window(){
     $("#dhc_cancel_remarks").focus();

}

function open_view_log_table(contractno,departmnet){
    var usePath = $.trim($("#rootXPath").val())     
    $.ajax({
        url: usePath + "contract_list/ajax_process",
        type: 'POST',
        data: { 'identity': 'VIEWLOG', 'contractno':contractno , 'departmnet' : departmnet},
        success: function (resp) {
            if (resp.status) {
                $("#viewloggrid").html(resp.data);
            } else {
                alert("No record(s) found.");
            
            }
        },
        error: function () {
            alert("An error occurred while processing the request.");
        },
        complete: function () {
            // Hide the loader when done
            $(".process_loader_table").hide();
        },
        cache: false
    });
}

function getQueryParam(name) {
    let urlParams = new URLSearchParams(window.location.search);
    return urlParams.get(name);
}

document.addEventListener("DOMContentLoaded", function () {
    let dept = getQueryParam("department");
    let contract = getQueryParam("contractno");

    if (dept && contract) {
      $("#header_buttons").addClass("hidden");
      $("#update_header_button").addClass("hidden");
      $("[id^='upload_ppt_button']").addClass("hidden");
      $("#submit_buttons").addClass("hidden");

    }
});

$(document).ready(function() {
  $('#client_search').select2({
    placeholder: "-Select-",
    allowClear: true,
    width: 'resolve' 
  });
  
   $('#client_search').on('select2:open', function () {
    $('.select2-search__field').focus();
  });
  
});


function closeModalBeforeImage() {

    $('#showpaymenthistory').modal('hide');

    // Watch the overlay for hide event
    const observer = new MutationObserver(function (mutations) {
        mutations.forEach(function (mutation) {
            if (mutation.attributeName === "style") {
                const display = $('#lightboxOverlay').css('display');
                if (display === 'none') {
                    $('#showpaymenthistory').modal('show'); // reopen modal
                    observer.disconnect();
                }
            }
        });
    });

    observer.observe(document.getElementById('lightboxOverlay'), {
        attributes: true
    });
}
